<div ng-controller="viewrequiredtestCtrl">
    <div class="row multi_line white no-border color-dark-gray container" style="margin: 0 !important;">
        <div class="titles border-bottom row gutter_vertical">
            <h3 class="uppercase gutter_vertical left">View Required Tests</h3>
        </div>
        <div class="border-bottom gutter_vertical">
            <div class="relative gutter_vertical clearfix">
                <div class="grid_3 pull small_gutter_r">
                    <?php
                    echo CHtml::dropDownList('listname','', $allCountries,
                        array('empty' => 'Choose Country', 'ng-model'=>'whichcountry', 'class'=>'grid_3')
                    );
                    ?>
                </div>
                <div class="grid_3 pull small_gutter_r">
                    <?php
                    echo CHtml::dropDownList('listname','', $allMajors,
                        array('empty' => 'Choose Major', 'ng-model'=>'whichmajor', 'class'=>'grid_3')
                    );
                    ?>
                </div>
                <div class="grid_2 pull small_gutter_r">
                    <button class="button-blue tny small_gutter_r" ng-click="findTests();">View Tests</button>
                </div>
            </div>
        </div>
        <loading></loading>
        <div class="row multi_line lightyellow border-bottom gutter_vertical" ng-if="noResults && !defaultMessage">
            <div class="row multi_line small-gutter center">
                <span class="gutter20">There are no required tests.</span>
            </div>
        </div>
        <div class="row multi_line lightyellow border-bottom gutter_vertical" ng-if="defaultMessage">
            <div class="row multi_line small-gutter center">
                <span class="gutter20">Choose Country and Major to view required tests.</span>
            </div>
        </div>
        <div ng-if="requiredTests.length">
            <div class="row gutter_vertical gray">
                <div class="grid_5 pull gutter-left-35" ><small>Test Name</small></div>
                <div class="grid_2 pull center" style="text-align: center"><small>Coaching Need</small></div>
                <div class="grid_2 pull center" style="text-align: center"><small>Students Appeared</small></div>
            </div>
            <div class="row multi_line gutter_vertical border-top relative visible clearfix" style="min-height: 65px"
                    ng-repeat="requiredTest in requiredTests">
                <div class="heading grid_4 pull">
                    <div class="gutter_vertical small_gutter_l">
                        <h4><a title="{{requiredTest.full_name}}" href="{{requiredTest.link}}" target="_blank">
                            {{requiredTest.name == requiredTest.full_name ? requiredTest.name : (requiredTest.name +' - '+requiredTest.full_name)}}
                        </a></h4>
                        <span class="lightgray">{{requiredTest.type + ' Test'}}</span>
                    </div>
                </div>
                <div class="right">
                    <div class="grid_2 pull center">{{requiredTest.need_coaching}}</div>
                    <div class="grid_2 right center" ng-if="requiredTest.last_year_students">
                        {{requiredTest.last_year_students | number}}
                    </div>
                    <div class="grid_2 right center" ng-if="!requiredTest.last_year_students">N/A</div>
                </div>
                <div title="{{!requiredTest.shortlisted ? 'Add to' : 'Remove from'}} Shortlist" class="tag-image"
                     ng-class="requiredTest.shortlisted ? 'addedtag' : 'addtag'"
                     ng-click="updateTestShortlist(requiredTest, !requiredTest.shortlisted ? 'ADD':'REMOVE')">&nbsp;
                </div>
            </div>
        </div>
    </div>
</div>