<?php
class CustomCareerPlanWidget extends CWidget{

    public $studentID = null;

    public function run() {
        if(!$this->studentID) return;

        $userModel = TblUserMaster::model()->findByPk($this->studentID);
        Yii::app()->session->add('studentID', $userModel->user_id);
        Yii::app()->session->add('classLevel', $userModel->present_class);
        $boardInfo = LookupBoardEquivalent::GetBoardDetail($userModel->present_class, $userModel->present_board_ref_id);
        Yii::app()->session->add('boardEquivalentID', $boardInfo ? $boardInfo['board_equivalent_id'] : false);

        if(in_array($userModel->present_class, array(11, 12)) &&
                $userModel->passout_year && $userModel->passout_month){

            $this->render('career_plan_widget_11n12');

        }else if(in_array($userModel->present_class, array(9, 10)) &&
                $userModel->passout_year){

            $this->render('career_plan_widget_9n10');
        }
    }
}