<?php

/**
 * @author Shiva <shiva.dharana@univariety.com>
 * @package application.models 
 * 
 * BaseStudentIdealListCollegeLog is autogenerate by UniModel generator
 *
 * This is the model class for table "student_ideal_list_college_log".
 *
 * The followings are the available columns in table 'student_ideal_list_college_log':
 * @property string $student_ideal_list_college_log_id
 * @property string $student_ideal_list_ref_id
 * @property integer $uni_ref_id
 * @property string $suggest_type
 * @property string $suggested_by
 * @property string $comment
 * @property string $comment_by
 * @property string $status
 * @property string $added_on
 */
class BaseStudentIdealListCollegeLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentIdealListCollegeLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_ideal_list_college_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_ideal_list_ref_id, uni_ref_id, suggested_by', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('student_ideal_list_ref_id, suggested_by, comment_by', 'length', 'max'=>10),
			array('suggest_type', 'length', 'max'=>7),
			array('status', 'length', 'max'=>8),
			array('comment, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_ideal_list_college_log_id, student_ideal_list_ref_id, uni_ref_id, suggest_type, suggested_by, comment, comment_by, status, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_ideal_list_college_log_id' => 'Student Ideal List College Log',
			'student_ideal_list_ref_id' => 'Student Ideal List Ref',
			'uni_ref_id' => 'Uni Ref',
			'suggest_type' => 'Suggest Type',
			'suggested_by' => 'Suggested By',
			'comment' => 'Comment',
			'comment_by' => 'Comment By',
			'status' => 'Status',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_ideal_list_college_log_id',$this->student_ideal_list_college_log_id,true);
		$criteria->compare('student_ideal_list_ref_id',$this->student_ideal_list_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('suggest_type',$this->suggest_type,true);
		$criteria->compare('suggested_by',$this->suggested_by,true);
		$criteria->compare('comment',$this->comment,true);
		$criteria->compare('comment_by',$this->comment_by,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}