<?php 

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiProductDebit is autogenerate by UniModel generator
 *
 * This is the model class for table "di_product_debit".
 *
 * The followings are the available columns in table 'di_product_debit':
 * @property string $di_product_debit_id
 * @property integer $di_ref_id
 * @property integer $product_ref_id
 * @property string $user_ref_id
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupProduct $productRef
 * @property Di $diRef
 * @property LoginMaster $addedBy
 * @property TblUserMaster $userRef
 */
class BaseDiProductDebit extends CActiveRecord
{
    public $ConsumedCount;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiProductDebit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_product_debit';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_ref_id, product_ref_id, user_ref_id, added_by, added_on', 'required'),
			array('di_ref_id, product_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_product_debit_id, di_ref_id, product_ref_id, user_ref_id, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'productRef' => array(self::BELONGS_TO, 'LookupProduct', 'product_ref_id'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_product_debit_id' => 'Di Product Debit',
			'di_ref_id' => 'Di Ref',
			'product_ref_id' => 'Product Ref',
			'user_ref_id' => 'User Ref',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_product_debit_id',$this->di_product_debit_id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('product_ref_id',$this->product_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    static public function getConsumedFreeEOICount(){

        $criteria=new CDbCriteria;
        $criteria->select = "COUNT(t.product_ref_id) AS ConsumedCount";
        $criteria->join = " INNER JOIN lookup_product lp ON lp.product_id = t.product_ref_id";
        $criteria->addCondition("t.di_ref_id = '".Yii::app()->user->di_id."' AND lp.product_shortcode='EOI'", "AND");
        $sData = self::model()->find($criteria);
        return $sData ? $sData->ConsumedCount : 0;
    }

    static public function getConsumedBuyProfileCount(){

        $criteria=new CDbCriteria;
        $criteria->select = "COUNT(t.product_ref_id) AS ConsumedCount";
        $criteria->join = " INNER JOIN lookup_product lp ON lp.product_id = t.product_ref_id";
        $criteria->addCondition("t.di_ref_id = '".Yii::app()->user->di_id."' AND lp.product_shortcode='Buy'", "AND");
        $sData = self::model()->find($criteria);
        return $sData ? $sData->ConsumedCount : 0;
    }
}