<?php
/*** 
 * Helper clas for Di ( Destination Institutes )
    getUsedUniversityList()
    getDiUserList()
    RbacInsert()
    GetDiDetails()
    getDiUserDetails()
    getCountryList()
    getDurationData
    getDiUserDepartment
    getCourseLevel
    getStudentData
    getStudentDepartmentData
    GetStudentDetail
    DataFormating
    majorFormating
    preferredStartingSessions
    GetUserHotleadById
    GetUserAllHotleads
    getUserStandardExamDetail
    getUserCompetitiveExamDetail
    loggedInUserDetails
    errorAndSuccessCodes
    GetProductType
    GetProductCreditData
    getProductCreditWithCreditLabel
    getProductTypeList
    getProductDetail
    getDiTotalCreditCount
    getDiTotalCashCredit
    getDiTotalCashCreditUsed
    getDiProductCredit
    getDiProductDebit
    availableDiProductCredit
    addDiProductDebit
    buyThisProfile
    buyEoiThisProfile
    getDiCashCredit
    getDiCashDebit
    availableDiCashCredit
    DiProductPriceIsActive
    DiProductPrice
    DiProductId
    addDiCashDebit
    getDiProductCreditList
    getDiProductCreditAccountBalanceChart
    getDiCashCreditAccountBalanceChart
    getDiCurrency
    getStudentHotLeadDetailById
    getHotLeadUserFullDetail
    getAlertMatchUserFullDetail
    getDiScholarship
    getUniversityId
    addUserEoi
    addUserScholarship
    addDiUserCriteriaShortlist
    SendMail
    getUserEmailAddress
    addScholarship
    addScholarshipDepartment
    addScholarshipHostInstitute
    addScholarshipPackage
    diHotLeadStatusToRead
    getDiAndStudentCommonDepartments
    cronHotleadRefund
    getBoard
    getDIUserHotLeadIdDetails
    getEntranceExam
    getEntranceExamDropDown
    getEntranceExamModule
    getEntranceExamModuleHtml
    getDiUserCriteriaDuration
    getDiUserCriteriaLikelyPeriod
    getDiUserCriteriaEntranceExamId
    getDiUserCriteriaEntranceExam
    getDiUserCriteriaEntranceExamIdData
    disabledCriteria
    criteriaCount
    getCriteria
    criteriaCronQuery
    criteriaCron
    storeCriteriaMatch
    getStudentInterestedCountries
    getDiUserCriteriaMatch
 */
class DiHelperBase{


    /*
     *  function Retrieve data from lookup_product_type table and return in array form
     *
     */

    public static function getUsedUniversityList(){
        $criteria           =   new CDbCriteria;
        $criteria->order    = 'uniRef.uni_name';
        $criteria->select   =   "t.uni_ref_id";
        $model              =   New Di;
        $data               =   $model->with('uniRef')->findAll($criteria);
        $list               =   CHtml::listData($data,'uni_ref_id', 'uniRef.uni_name');
        return $list;
    }

    /*
     *  function Retrieve data from lookup_product_type table and return in array form
     *
     */

    public static function getDiUserList(){
        $criteria           =   new CDbCriteria;
        $criteria->select   =   't.di_ref_id, t.first_name,t.last_name';
        $model              =   New DiUser();
        $data               =   $model->findAll($criteria);
        $list               =   CHtml::listData($data,'di_ref_id', 'concatened');
        return $list;
    }

    /*
     *  function which help to insert roll base access control entry in rbac_authassignmen tabel
     *  you need to pass two param one is user id and second is roll
     */

    public function RbacInsert($user_id="",$role = "" ){
        $model  =   new RbacAuthassignment();
        $model->itemname    =   $role;
        $model->userid      =   $user_id;
        if($model->save()):
            return 'Data saved Successfully';
        else:
            return 'error while storing data';
        endif;
    }

    /*
     *  function retrieving the data of di from di table
     */

    public static function GetDiDetails($di_id =   '0'){
        $data   =   Di::model()->findByPk($di_id);
        if($data===null)
            throw new CHttpException(404,'The requested page does not exist.');
        return $data;
    }

    public static function getDiUserDetails($diUser=0){
        $data   =   DiUser::model()->findByPk($diUser);
        return $data;
    }

    /*
     *  getCountryList function fetch the data from tbl_country_master table
     *  and return array of country data
     */

    public static function getCountryList(){
        $model  =   new CountryMaster();
        $Result =   CHtml::listData($model->findAll(),'country_id','country_name');
       return $Result;
    }

    public static function getDurationData(){
        $model  =   new LookupDuration;
        $data   =   $model->findAll();
        return $data;
    }

    /*
     * function getDiUserDepartment retrieve the department data from di_user_department order by di_user_id
     * result will be di alloted department list
     * param - 1). $di_user_id (di user_id from di_user table)
     */
    public static function getDiUserDepartment($di_user_id = '0'){
        $model                  =   new DiUserDepartment();
        $criteria               =   new CDbCriteria;
        $criteria->select       =   't.di_user_ref_id,t.main_department_ref_id';
        $criteria->condition    =   't.di_user_ref_id= :x';
        $criteria->params       =   array(':x'=>$di_user_id);
        $data                   =   $model->findAll($criteria);
        $result                 =   CHtml::listData($data,'main_department_ref_id','mainDepartmentRef.department_name');
        return $result;
    }

    /*
     *
     * function getCourseLevel retireve course level data from lookup_course_level table
     * result data will be list of parent courses
     * param - empty
     *
     */

    public static function getCourseLevel(){
        $model                  =   new LookupCourseLevel;
        $criteria               =   new CDbCriteria;
        $criteria->select       =   't.level_id, t.course_level';
        $criteria->condition    =   't.parent_ref_id =:x';
        $criteria->params       =   array(':x'=>'0');
        $result =   CHtml::listData($model->findAll($criteria),'level_id','course_level');
        return $result;
    }

    /*
     *
     * function getStudentData retrieve user data from tbl_user_master table
     * result data will be user data
     * param - 1). $user_id , 2). $login_master_id
     * criteria : you can send both id either $user_id or login_master_id which will be store in session
     *
     */

    public static function getStudentData($user_id='0', $login_master_id='0'){
        $model                  =   new TblUserMaster;
        $criteria               =   new CDbCriteria;
        if($user_id!=0){
            $data       =   $model->findByPk($user_id);
        }else if($login_master_id!='0'){
            $criteria->condition    =   't.login_ref_id=:x';
            $criteria->params       =   array(':x'=>$login_master_id);
            $data       =   $model->findAll($criteria);
        }
        return $data;
    }

    /*
     * function getStudentDepartmentData get user department data from student preferred department
     * table
     * params : 1). user_id from user_master_table
     * result will be user department
     */

    public static function getStudentDepartmentData($user_id='0'){
        $model                  =   new StudentPreferredDepartment;
        $criteria               =   new CDbCriteria;

        $criteria->condition    =   't.user_ref_id=:x';
        $criteria->params       =   array(':x'=>$user_id);
        $data       =   $model->findAll($criteria);
        return $data;
    }

    public static function GetStudentDetail($user_id='0'){
        $model                  =   new TblUserMaster();
        $criteria               =   new CDbCriteria();
        $criteria->select       =   "t.user_id,t.first_name,t.last_name";
        $criteria->condition    =   "t.user_id =:x";
        $criteria->params       =   array(":x"=>$user_id);
        $data        =   $model->find($criteria);
        return $data;
    }

    public static function DataFormating($data="", $Saparator=" , "){
        if(count($data)>0){
            $string =   implode(array_values($data),$Saparator);
        }else{
            $string =   "";
        }
        return $string;
    }

    public static function majorFormating($data,$bar=false){
        $department_ids =     DiHelper::getStudentDepartmentData($data);
        $department_Data   =   CHtml::listData($department_ids,'mainDeptRef.department_name','mainDeptRef.department_name');
        $string = "";
		//Department Preferences
		$departmentPrefArray = array();
		foreach($department_ids as $prefDept){
				if($prefDept->not_sure){
						$departmentPrefArray[0] = 'Not Decided';
						break;
				}else{
						$departmentPrefArray[$prefDept->preference_order] = $prefDept->mainDeptRef->attributes['department_name'];
				}
		}
		ksort($departmentPrefArray);
		foreach($departmentPrefArray as $departmentPrefArray)
		{
			if($bar){
			$string.=$departmentPrefArray." | ";
			}else{
			$string.="<span>- ".$departmentPrefArray."</span>";
			}
		}
		if($bar)
		$string = rtrim($string," | ");
		//Department Preferences_END			
        return $string;

    }

    public static function preferredStartingSessions($user_ref_id){

        $model = StudentPreferredPeriod::model()->with('periodRef')->findAll(
            array(
                "condition" =>"t.user_ref_id={$user_ref_id}",
                'order' => 't.year, t.period_ref_id'
            ));
        $string = "";

        if(count($model)>0){
            foreach($model as $data){
                if(isset($data->periodRef) && isset($data->periodRef->months)){
                   // CVarDumper::dump($data->periodRef->month,10,true);

                    $string .=    "<span>- ".$data->periodRef->months.' '.$data->year."</span>";
                }
            }
        }

        return $string;

    }

    /*
     * function GetUserHotlead get user holeads from student_hotlead table
     * params : 1). $user_ref_id (tbl_user_master) 2). $uni_ref_id (tbl_university_master)
     * result will be user hotlead data
     */

    public static function GetUserHotleadById($user_id='0',$uni_ref_id='0'){
        $model                  =   new StudentHotlead();
        $criteria               =   new CDbCriteria();
        if($uni_ref_id!='0'){
            $criteria->condition    =   't.user_ref_id=:x';
            $criteria->params       =   array(':x'=>$user_id);
        }else{
            $criteria->condition    =   't.user_ref_id=:x AND t.uni_ref_id=:y';
            $criteria->params       =   array(':x'=>$user_id,':y'=>$uni_ref_id);
        }
        $data                       =   $model->find($criteria);
        return $data;
    }

    /*
     * function GetUserAllHotleads get user holeads from student_hotlead table
     * params : 1). $user_ref_id (tbl_user_master) 2). $uni_ref_id (tbl_university_master)
     * 3). $user_not_in (tbl_university_master) to exclude university id
     * result will be user hotlead data
     */

    public static function GetUserAllHotleads($user_id='0',$uni_ref_id='0',$user_not_in='0', $limit=''){
        $model                  =   new StudentHotlead();
        $criteria               =   new CDbCriteria();
        if($uni_ref_id=='0' && $user_not_in=='0'){

            $criteria->condition    =   't.user_ref_id=:x';
            $criteria->params       =   array(':x'=>$user_id);
        }else if($user_not_in!='0'){

            $criteria->condition    =   't.user_ref_id=:x AND t.uni_ref_id<>:y';
            $criteria->params       =   array(':x'=>$user_id,':y'=>$user_not_in);
        }else{
            $criteria->condition    =   't.user_ref_id=:x AND t.uni_ref_id=:y';
            $criteria->params       =   array(':x'=>$user_id,':y'=>$uni_ref_id);
        }
        if($limit){
            $criteria->limit = $limit;
        }
        $criteria->order = "added_on DESC";
        $data                       =   $model->findAll($criteria);
        return $data;
    }

    /*
     *  function getUserEducationDetail get user education detail
     *  param : 1). userid from tbl_user_master
     *  result user education details
     */

    public static function getUserStandardExamDetail($user_id='0'){
            $model                  =   new StudentEducation();
        $sql                    =   'SELECT * FROM student_education WHERE class_level IN(SELECT MAX(class_level) FROM student_education WHERE user_ref_id = '.$user_id.') AND user_ref_id = '.$user_id.'';
        $data                   =   $model->findBySql($sql);
        return $data;
    }

    /*
     *
     * function getUserExamEducationDetail get details of competitive exams detail of users
     * param : 1). $user_id (tpl_user_master)
     * result exams details
     */

    public static function getUserCompetitiveExamDetail($user_id= 0 ){
		$model      =   new UserEntranceExamModule();
		$sqlSelect	=	"SELECT ueexm.*,uexm.* FROM `user_entrance_exam_module` AS ueexm ";
		$sqlJoin	=	"LEFT JOIN `user_entrance_exam` uexm ON uexm.user_entrance_exam_id = ueexm.user_entrance_exam_ref_id ";
		$sqlWhere	=	"WHERE `user_ref_id`=$user_id order by ueexm.user_entrance_exam_module_id";
		$finalSql	=	$sqlSelect.$sqlJoin.$sqlWhere;
		
        $data       =   $model->findAllBySql($finalSql);
		
		if(count($data)>0){
            foreach($data as $value){
                $array[$value->userEntranceExamRef->entranceExamRef->entrance_short_name." - ".$value->entranceExamModuleEntranceExamRef->entranceExamModuleRef->module_name]      =   $value->marks;
            }
        }else{
            $array  =   array();
        }
        return $array;
    }

    /*
     * function loggedInUserDetails get logged in user details
     * param : 1). login_id
     * result will be login user details
     */

    public static function loggedInUserDetails($login_id = '0'){
        $model      =   new LoginMaster();
        $data       =   $model->findByPk($login_id);
        return $data;
    }


    public static function errorAndSuccessCodes($code =   ""){
        switch($code){
            case 'Error-code-1':
                return "Error : No free credits are available Please contact to univariety";
                break;
            case 'Error-code-2':
                return "Error : Sorry! You dont have enough credit in your account to buy this profile";
                break;
            case 'Error-code-3':
                return "Error : Oops! Something went wrong. Please try again later.";
                break;
            case 'Error-code-4':
                return "Error : Sorry! This feature is not yet available for you";
                break;
            case 'Error-code-5':
                return "Error : This hotlead already bought by anoth moderator";
                break;
            case 'Success-code-1':
                return "Success : Congratulations! Your interest to make an offer sent successfully";
                break;
            default:
                break;
        }
    }

    /*
    *  function to fetch product type from lookup_product table with three criteria
    *  criteria 1 => when we pass product_id and user_type_ref_id.
    *  criteria 2 => when we pass only product_id.
    *  criteria 3 => when we pass only user_type_ref_id.
    *  default criteria will be goes with criteria three with user_type_ref_id=3 Destination Institute (DI)
    */

    public function GetProductType($productID='',$UserTypeId='3', $details_for = array()){

        $criteria   			=	new CDbCriteria();
        if(isset($productID) && !empty($productID) && isset($UserTypeId) && !empty($UserTypeId)){

            $criteria->condition    =   't.user_type_ref_id = :x1 AND t.product_id = :x2';
            $criteria->params        =   array(':x1' => $UserTypeId, ':x2'=>$productID);
        }elseif(isset($productID) && !empty($productID)){

            $criteria->condition    =   't.product_id = :x2';
            $criteria->params        =   array(':x2'=>$productID);

        }elseif(isset($UserTypeId) && !empty($UserTypeId)){

            $criteria->condition    =   't.user_type_ref_id =:x1';
            $criteria->params        =   array(':x1'=> $UserTypeId);
        }

        if (count($details_for)) {
            $criteria->condition    .=   " AND product_shortcode IN ('".implode("','", $details_for)."') ";
        }

        $data   =   LookupProduct::model()->findAll($criteria);
        return $data;
    }

    /*
     *  function GetProductCreditData return data and url from di_product_credit table
     *  two params are passing with two conditions
     *  one param is di_ref_id to get the data of
     *  second param set condition to get URL or the data
     */

    public function GetProductCreditData($di_ref_id =  "", $url   =   '0'){
        $ProductCreditUrl       =   Yii::app()->params['ProductCreditUrl'];
        $criteria               =   NEW CDbCriteria();
        $criteria->condition    =   'di_ref_id=:x';
        $criteria->params       =   array(':x' => $di_ref_id);
        $result                 =   DiProductCredit::model()->findAll($criteria);
        if($url){
            if(count($result)>0){
                $data    =   Yii::app()->createUrl($ProductCreditUrl. '/update',array('id'=>$di_ref_id));
            }else{
                $data    =   Yii::app()->createUrl($ProductCreditUrl. '/create',array('id'=>$di_ref_id));
            }
        }else{
            $data   =  $result;
        }
        return $data;
    }

    /*
     *  function Retrieves data from di_product_credit and return the data of particular
     *  Di and return the data in array form
     */

    public function getProductCreditWithCreditLabel($di_ref_id){
        $data       =   self::GetProductCreditData($di_ref_id);

        $product  = array();
        if(count($data)>0){
            foreach($data as $productid){
                $product[$productid->productRef->product_description]    =   $productid->credit_count;
            }
        }else{
            $product    =   array();
        }
        return $product;
    }

    /*
     *  function Retrieve data from lookup_product_type table and return in array form.
     *  Its using already written function GetProductType to get product type list
     */

    public static function getProductTypeList(){
        $data   =   self::GetProductType();
        $list =  CHtml::listData($data,'product_id', 'product_description');
        return $list;
    }

    /*
    *
    *  function getProductDetail retrieve the data from lookup_product table using product id
    *
    */

    public static function getProductDetail($id){
        $model  =   new LookupProduct();
        $data   =    $model->findByPk($id);
        return $data;
    }
    /*
     *
     *  function getDiTotalCreditCount retrieve data from di_product_credit using di_id
     *  result will be used of total provided free credit to di
     */

    public static function getDiTotalCreditCount($Di_id = '0'){
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   'di_ref_id=:x';
        $criteria->params       =   array(':x'=>$Di_id);
        $data                   =   DiProductCredit::model()->findAll($criteria);
        $total                  =   0;
        if(count($data)>0){
            foreach($data as $value){
                $total  += $value->credit_count;
            }
        }else{
            $total      =   0;
        }
        return $total;
    }

    /*
     *  function getDiTotalCashCredit retrieve user data from di_cash_credit using di_id
     *  result will be the total provided paid credit to di user
     */

    public static function getDiTotalCashCredit($Di_id = '0'){
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   'di_ref_id=:x';
        $criteria->params       =   array(':x'=>$Di_id);
        $data                   =   DiCashCredit::model()->findAll($criteria);
        $total                  =   '0';
        if(count($data)>0){
            foreach($data as $value){
                $total  += $value->amount;
            }
        }
        return $total;
    }

    public static function getDiTotalCashCreditUsed($Di_id =  '0'){
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   'di_ref_id=:x';
        $criteria->params       =   array(':x'=>$Di_id);
        $data                   =   DiCashDebit::model()->findAll($criteria);
        $total                  =   '0';
        if(count($data)>0){
            foreach($data as $value){
                $total  += $value->subtotal;
            }
        }
        return $total;
    }

    public static function getDiProductCredit($Di_Id='0', $Product_Id='0'){
        $criteria               =   new CDbCriteria();
        $criteria->select       =   'sum(t.credit_count) AS credit_count';
        $criteria->condition    =   'di_ref_id=:x AND product_ref_id=:y';
        $criteria->params       =   array(':x'=>$Di_Id,':y'=>$Product_Id);
        $data                   =   DiProductCredit::model()->find($criteria);
        if($data->credit_count===NULL){
            return 0;
        }else{
            return $data->credit_count;
        }
    }
    public static function getDiProductDebit($Di_Id='0', $Product_Id='0'){
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   'di_ref_id=:x AND product_ref_id=:y';
        $criteria->params       =   array(':x'=>$Di_Id,':y'=>$Product_Id);
        $data                   =   DiProductDebit::model()->count($criteria);
        if($data==0){
            return 0;
        }else{
            return $data;
        }
    }

    public static function availableDiProductCredit($Di_Id='0', $Product_Id='0'){
        $getDiProductCredit =   self::getDiProductCredit($Di_Id, $Product_Id);
        $getDiProductDebit  =   self::getDiProductDebit($Di_Id, $Product_Id);
        return (int)$getDiProductCredit  -   (int)$getDiProductDebit;
    }


    public static function addDiProductDebit($arrayData  =    array()){
        $model                      =   new DiProductDebit();
        $model->di_ref_id           =   $arrayData['di_ref_id'];
        $model->product_ref_id      =   $arrayData['product_ref_id'];
        $model->user_ref_id         =   $arrayData['user_ref_id'];
        $model->added_by            =   $arrayData['added_by'];
        $model->added_on            =   new CDbExpression('NOW()');
        $dataSaved                  =   $model->save();
        return $dataSaved;
    }

    public static function buyThisProfile($di_Hotlead_Id='0'){
        $FiledUpdate    =   DiUserHotlead::model()->updateByPk($di_Hotlead_Id,array('status'=>'Buy'));
        return $FiledUpdate;
    }
    public static function buyEoiThisProfile($listId='0'){
        $FiledUpdate    =   DiUserCriteriaMatch::model()->updateByPk($listId,array('status'=>'EOI'));
        return $FiledUpdate;
    }

    public static function getDiCashCredit($Di_Id = '0'){
        $criteria               =   new CDbCriteria;
        $criteria->select       =   'sum(t.amount) AS amount';
        $criteria->condition    =   'di_ref_id=:x';
        $criteria->params       =   array(':x'=>$Di_Id);
        $data                   =   DiCashCredit::model()->find($criteria);
        if($data->amount===NULL){
            return 0;
        }else{
            return $data->amount;
        }
    }

    public static function getDiCashDebit($Di_Id = '0'){
        $criteria               =   new CDbCriteria;
        $criteria->select       =   'sum(t.subtotal) AS subtotal';
        $criteria->condition    =   'di_ref_id=:x';
        $criteria->params       =   array(':x'=>$Di_Id);
        $data                   =   DiCashDebit::model()->find($criteria);
        if($data->subtotal===NULL){
            return 0;
        }else{
            return $data->subtotal;
        }
    }

    public static function availableDiCashCredit($Di_Id = '0'){
        $getDiCashCredit =   self::getDiCashCredit($Di_Id);
        $getDiCashDebit  =   self::getDiCashDebit($Di_Id);
        return (int)$getDiCashCredit -   (int)$getDiCashDebit;
    }

    public static function getDiCreditLimit($Di_Id = '0'){
        $criteria               =   new CDbCriteria;
        $criteria->select       =   'credit_limit';
        $criteria->condition    =   'di_id=:x';
        $criteria->params       =   array(':x'=>$Di_Id);
        $data                   =   Di::model()->find($criteria);
        if($data->credit_limit===NULL){
            return 0;
        }else{
            return $data->credit_limit;
        }
    }
	
    public static function DiProductPriceIsActive($Di_Id = '0', $Product_Id = '0'){
	
		$todayDate = date("Y-m-d");
        $criteria               =   new CDbCriteria;
        $criteria->select       =   't.di_product_id';
        $criteria->condition    =   'di_ref_id=:x AND product_ref_id=:y AND is_active=:z AND (:today >= start_date AND :today <= end_date)';
        $criteria->params       =   array(':today'=>$todayDate, ':x'=>$Di_Id,':y'=>$Product_Id,':z'=>'1');
        $data                   =   DiProduct::model()->find($criteria);
        if($data===NULL){
            return false;
        }else{
            return true;
        }
    }

    public static function DiProductPrice($Di_Id = '0', $Product_Id = '0'){

        // product price selection from multiple price range
        // Price functionality is referred by Ansual ( Product Manager )

        $criteria               =   new CDbCriteria;
        $criteria->select       =   't.price';
        $criteria->condition    =   'di_ref_id=:x AND product_ref_id=:y AND is_active=:z AND start_date <= DATE(NOW())';
        $criteria->params       =   array(':x'=>$Di_Id,':y'=>$Product_Id,':z'=>'1');
        $criteria->order        =   'start_date DESC';
        $data                   =   DiProduct::model()->find($criteria);

        if($data===NULL){
            return 0;
        }else{
            return $data->price;
        }
    }

    public static function DiProductId($Di_Id = '0', $Product_Id = '0'){
        $criteria               =   new CDbCriteria;
        $criteria->select       =   't.di_product_id';
        $criteria->condition    =   'di_ref_id=:x AND product_ref_id=:y AND is_active=:z';
        $criteria->params       =   array(':x'=>$Di_Id,':y'=>$Product_Id,':z'=>'1');
        $data                   =   DiProduct::model()->find($criteria);
        if($data===NULL){
            return 0;
        }else{
            return $data->di_product_id;
        }
    }

    public static function addDiCashDebit($arrayData  =    array()){
        $model                      =   new DiCashDebit;
        $model->di_ref_id           =   $arrayData['di_ref_id'];
        $model->di_product_ref_id   =   $arrayData['di_product_ref_id'];
        $model->user_ref_id         =   $arrayData['user_ref_id'];
        $model->quantity            =   '1';
        $model->subtotal            =   $arrayData['subtotal'];
        $model->added_on            =   new CDbExpression('NOW()');
        $model->added_by            =   Yii::app()->user->id;
		
        $dataSaved                  =   $model->save();
        return $dataSaved;
    }

    public static function getDiProductCreditList($Di_Id = '0'){
        $model                      =   new DiProductCredit();
        $criteria                   =   new CDbCriteria;
        $criteria->select           =   't.di_ref_id,t.product_ref_id,SUM(t.credit_count) as credit_count';
        $criteria->condition        =   't.di_ref_id=:x';
        $criteria->params           =   array(':x'=>$Di_Id);
        $criteria->group            =   't.product_ref_id';
        $data                       =   $model->findAll($criteria);
        return $data;
    }
    public static function getDiProductCreditAccountBalanceChart($Di_Id = '0'){
        $data                       =   self::getDiProductCreditList($Di_Id);
        echo "<table cellspacing='2' class='accountbalance' cellpadding='2' border='1'>";
        echo "<tr><th>Product Name</th><th>Provided Credits</th><th>Balance</th></tr>";
        foreach($data as $key => $value){
            $balance    =   self::availableDiProductCredit($value->di_ref_id, $value->product_ref_id);
            echo "<tr>
                <td>{$value->productRef->product_shortcode}</td>
                <td>{$value->credit_count}</td>
                <td>{$balance}</td>
            </tr>";

        }
        echo "</table>";
    }

    public static function getDiCashCreditAccountBalanceChart($Di_Id = '0'){
        $totalCashCredit        =   self::getDiCashCredit($Di_Id);
        $availableCashCredit    =   self::availableDiCashCredit($Di_Id);
        $currency               =   self::getDiCurrency($Di_Id);
		$credit_limit = self::getDiCreditLimit($Di_Id);
        echo "<table cellspacing='2' class='accountbalance' cellpadding='2' border='1'>";
        echo "<tr><th colspan='3'>Your credit limit is = ".$credit_limit."</th></tr>";
        echo "<tr><th>Currency</th><th>Cash Credit</th><th>Cash Balance</th></tr>";
		
			$credit_limit_msg = "";
			if($credit_limit>0){
				$credit_limit_msg = " ( You can use overdraft limit till ".$credit_limit." ) ";
			}
		
            echo "<tr>
                <td>{$currency}</td>
                <td>{$totalCashCredit}</td>
                <td><strong>{$availableCashCredit}</strong> ".$credit_limit_msg."</td>
            </tr>";
        echo "</table>";
    }

     public static function getDiCurrency($Di_Id,$pdfDownload=false){
        $data   =   Di::model()->findByPk($Di_Id);
        if($data===null)
            throw new CHttpException(404,'The requested page does not exist.');
        //return $data->currencyRef->currency_code;
		if($data->currencyRef->currency_id==1){
			if($pdfDownload){
				return "Rs.";
			}else{
				return "<span class='WebRupee'>".$data->currencyRef->html_entity."</span>";
    }
		}
		else{
			return $data->currencyRef->html_entity;
		}
    }

	public static function getStudentHotLeadDetailById($Student_hotlead_id = '0'){
        $model  =   new StudentHotlead();
        $data   =   $model->findByPk($Student_hotlead_id);
        if($data===NULL){
            return false;
        }else{
            return $data;
        }
    }
    public static function getHotLeadUserFullDetail($id = ''){

        $data                   =   self::getDIUserHotLeadIdDetails($id);
        $student_data           =   self::GetStudentDetail($data->studentHotleadRef->user_ref_id);
        $student_countrylist    =   CHtml::listData($student_data->studentPreferredCountries,'countryRef.country_name','countryRef.country_name');
        $mainDepart             =   CHtml::listData($student_data->studentPreferredDepartments,'mainDeptRef.department_name','mainDeptRef.department_name');

        $otherPreferredUniversity   =   self::GetUserAllHotleads($data->studentHotleadRef->user_ref_id,'',$data->studentHotleadRef->uni_ref_id, 3);
        $otheruniversities      =   CHtml::listData($otherPreferredUniversity,'uniRef.uni_name','uniRef.uni_name');
//echo $data->studentHotleadRef->user_ref_id;

        $standardExam           =   self::getUserStandardExamDetail($data->studentHotleadRef->user_ref_id);
        $CompititiveExam        =   self::getUserCompetitiveExamDetail($data->studentHotleadRef->user_ref_id);
        ?>
    <div class="userFullDetail">
        <div class="clear">
            <table class="bordered float_left" style="width:300px; margin:15px 20px;">
			<?php if(isset($standardExam)): ?>
                <thead>
                <tr>
                    <th colspan="2">Student Scores</th>
                </tr>
                </thead>
                <tbody>
                <?php if($standardExam): ?>
                    <tr>
					<?php
					if(isset($standardExam->boardRef->boardRef->board_desc) && ($standardExam->boardRef->boardRef->board_desc!="")){
					$board_desc = $standardExam->boardRef->boardRef->board_desc;
					} else{
					$board_desc = "";
					}
					?>

                        <td><?php echo $standardExam->class_level.'th '. ($standardExam->status == 'Pursuing' ? 'Expected' : '').' ( ' .$board_desc. ' )'; ?></td>
                        <td style="text-align: center; font-weight: bold;">
                            <?php
                            $overallType = $standardExam->boardRef->overall_type;
                            switch($overallType){
                                case 'Marks':{
                                    echo ($standardExam->overall_marks=="") ? "" : round($standardExam->overall_marks).'%';
                                    break;
                                }
                                case 'Points':{
                                    echo round($standardExam->overall_marks);
                                    break;
                                }
                                case 'Grades':{
                                    $gradesString = StudentGradeCount::phraseStudentOverallGrades($standardExam->class_level, $standardExam->user_ref_id);
									//$gradesString = explode(' ',$gradesString);
									//$gradesString = array_unique($gradesString);
									//$gradesString = implode(' ',$gradesString);
                                    echo $gradesString;
                                    break;
                                }
                            }

                            ?>
                        </td>
                    </tr>
                <?php endif; ?>

                <?php if($CompititiveExam): ?>
                    <?php foreach($CompititiveExam as $key => $exams){ ?>
                    <tr>
                        <td><?php echo $key; ?></td>
                        <td style="text-align: center; font-weight: bold;"><?php echo (int)$exams; ?></td>
                    </tr>
                    <?php } ?>
                 <?php endif; ?>

                </tbody>
			<?php endif; ?>	
            </table>
            <div class="float_left" style="width:361px">

                <?php if(isset($data->studentHotleadRef->status)): ?>
                <h4>Current Status:</h4>
                <p class="border-bottom"><?php
                    if($data->studentHotleadRef->status=="WillApply"){
                        echo 'Will Apply';
                    }else if($data->studentHotleadRef->status=="MightApply"){
                        echo 'Might Apply';
                    }else{
                        echo $data->studentHotleadRef->status;
                    }

                    ?></p>
                <?php
                    endif;
                    if(isset($student_countrylist)):
                ?>
                <h4>Countries of Interest:</h4>
                <p class="border-bottom"><?php //echo DiHelper::DataFormating($student_countrylist,' | ');

					//Country Preferences
					$countryPrefArray = array();
					foreach($student_data->studentPreferredCountries as $prefCountry){
						if($prefCountry->not_sure){
						$countryPrefArray[0] = 'Not Decided';
						break;
						}else{
						$countryPrefArray[$prefCountry->preference_order] = $prefCountry->countryRef->attributes['country_name'];
						}
					}
					ksort($countryPrefArray);
					if(count($countryPrefArray) > 0){
						echo implode(' | ', $countryPrefArray);
					}else{
						echo 'N/A';
					}
					//Country Preferences_END













				?></p>
                <?php
                    endif;
                    if(isset($mainDepart)):
                ?>
                <h4>Majors of Interest:</h4>
                <p class="border-bottom"><?php //echo DiHelper::DataFormating($mainDepart,' | ');
				echo DiHelper::majorFormating($data->studentHotleadRef->user_ref_id,true);
				
				?></p>
                <?php
                    endif;
                    if(isset($otheruniversities) && count($otheruniversities)>0):
                ?>
                <h4>Other colleges viewed by student:</h4>
                <p><?php echo DiHelper::DataFormating($otheruniversities,' | '); ?></p>
                    <?php endif; ?>
                </div>
        </div>
        <p class="footer_strip">
		<?php echo DiHelper::userFullDetalFooterStrip($data->studentHotleadRef->user_ref_id); ?>
        </p>
    </div>
    <?php
    }

    public static function getAlertMatchUserFullDetail($id = ''){

        $DiUserCriteriaMatch    =   DiUserCriteriaMatch::model()->findByPk($id);

        $student_id             =   $DiUserCriteriaMatch->user_ref_id;
        $student_data           =   self::GetStudentDetail($student_id);

        $student_countrylist    =   CHtml::listData($student_data->studentPreferredCountries,'countryRef.country_name','countryRef.country_name');
        $mainDepart             =   CHtml::listData($student_data->studentPreferredDepartments,'mainDeptRef.department_name','mainDeptRef.department_name');

        $standardExam           =   self::getUserStandardExamDetail($student_id);
        $CompititiveExam        =   self::getUserCompetitiveExamDetail($student_id);
        ?>
    <div class="userFullDetail">
        <div class="clear">
            <table class="bordered float_left" style="width:300px; margin:15px 20px;">
				<?php if(isset($standardExam)): ?>
                <thead>
                <tr>
                    <th colspan="2">Student Scores</th>
                </tr>
                </thead>
                <tbody>
                    <?php if($standardExam): ?>
                <tr>
					<?php
					if(isset($standardExam->boardRef->boardRef->board_desc) && ($standardExam->boardRef->boardRef->board_desc!="")){
					$board_desc = $standardExam->boardRef->boardRef->board_desc." - ";
					} else{
					$board_desc = "";
					}
					?>
                    <td><?php echo $standardExam->class_level.' (' .$board_desc. (($standardExam->status == 'Pursuing') ? 'Expected' : $standardExam->status) . ') '; ?></td>
                    <td class="strong">
                        <?php
                        $overallType = $standardExam->boardRef->overall_type;
                        switch($overallType){
                            case 'Marks':{
                                echo ($standardExam->overall_marks=="") ? "" : round($standardExam->overall_marks).'%';
                                break;
                            }
                            case 'Points':{
                                echo round($standardExam->overall_marks);
                                break;
                            }
                            case 'Grades':{
                                $gradesString = StudentGradeCount::phraseStudentOverallGrades($standardExam->class_level, $standardExam->user_ref_id);
                                echo $gradesString;
                                break;
                            }
                        }

                        ?>
                    </td>
                </tr>
                    <?php endif; ?>

                    <?php if($CompititiveExam): ?>
                    <?php foreach($CompititiveExam as $key => $exams){ ?>
                    <tr>
                        <td><?php echo $key; ?></td>
                        <td><?php echo (int)$exams; ?></td>
                    </tr>
                        <?php } ?>
                    <?php endif; ?>

                </tbody>
			<?php endif; ?>	
            </table>
            <div class="float_left" style="width:361px">

                <?php if(isset($data->studentHotleadRef->status)): ?>
                <h4>Current Status:</h4>
                <p><?php
                    if($data->studentHotleadRef->status=="WillApply"){
                        echo 'Will Apply';
                    }else if($data->studentHotleadRef->status=="MightApply"){
                        echo 'Might Apply';
                    }else{
                        echo $data->studentHotleadRef->status;
                    }

                    ?></p>
                <?php
            endif;
                if(isset($student_countrylist)):
                    ?>
                    <h4>Countries of Interest:</h4>
                    <p><?php //echo DiHelper::DataFormating($student_countrylist,' | ');

					//Country Preferences
					$countryPrefArray = array();
					foreach($student_data->studentPreferredCountries as $prefCountry){
						if($prefCountry->not_sure){
						$countryPrefArray[0] = 'Not Decided';
						break;
						}else{
						$countryPrefArray[$prefCountry->preference_order] = $prefCountry->countryRef->attributes['country_name'];
						}
					}
					ksort($countryPrefArray);
					$string="";
					if(count($countryPrefArray) > 0){
						foreach($countryPrefArray as $countryPrefArray)
						{
							$string.=$countryPrefArray." | ";
						}
					}else{
						echo 'N/A';
					}
					echo rtrim($string," | ");
				//Country Preferences_END


					?></p>
                    <?php
                endif;
                if(isset($mainDepart)):
                    ?>
                    <h4>Majors of Interest:</h4>
                    <p><?php //echo DiHelper::DataFormating($mainDepart,' | ');
					echo DiHelper::majorFormating($student_id,true);
					?></p>
                    <?php
                endif;
                    ?>
            </div>
        </div>
        <p class="footer_strip">
		<?php echo DiHelper::userFullDetalFooterStrip($DiUserCriteriaMatch->user_ref_id); ?>
        </p>
    </div>
    <?php
    }

    public static function getDiScholarship($Di_Id = '0'){
        /*SELECT * FROM scholarship
INNER JOIN scholarship_host_institute ON scholarship.scholarship_id = scholarship_host_institute.scholarship_ref_id
WHERE scholarship_host_institute.uni_ref_id='1'*/
		/*
        $model                  =   new Scholarship();
        $criteria               =   new CDbCriteria();
        $criteria->select        =  't.scholarship_id,t.scholarship_name';
        $criteria->condition    =   'scholarship_host_institute.uni_ref_id='.$Di_Id.' AND t.is_active="1"';
        $criteria->join         =   'INNER JOIN scholarship_host_institute ON t.scholarship_id = scholarship_host_institute.scholarship_ref_id';
        $data                    =   $model->findAll($criteria);
		*/
		$scholarships = ScholarshipHostInstitute::getScholarshipCountByUniId($Di_Id, '2', '', 1, false);
		$data = array();
		foreach($scholarships as $scholarship){
			$data[] = array('scholarship_id'=>$scholarship['scholarship_ref_id'],'scholarship_name'=>$scholarship['scholarship_name']);
			//$data[$scholarship['scholarship_ref_id']] = $scholarship['scholarship_name'];
		}
		
        if($data===NULL){
            return false;
        }else{
            return $data;
        }
    }

    public static function getUniversityId($di_id = '0'){
        $data   =   Di::model()->findByPk($di_id);
        if($data===null)
            throw new CHttpException(404,'The requested page does not exist.');
        return $data->uni_ref_id;
    }

    /*
     *  addUserEoi function insert data into di_user_eoi table
     *
     */

    public static function addUserEoi($array    =   array()){

        $model      =   new DiUserEoi();
        $logModel   =   new DiUserEoiLog();
		
		/*
		EOI entery should only one for same university, same department, same student
		First find entery in di_user_eoi table if exist then open it to save updates
		*/
		$di_id = Yii::app()->user->di_id;
		$diUsers = DiHelper::getAllDiUsersOfSameUniversity($di_id);
		
		$criteria = new CDbCriteria();
		$criteria->condition = 'user_ref_id=:user_ref_id AND main_department_ref_id=:main_department_ref_id';
		$criteria->params = array(
		'user_ref_id'				=> $array['user_ref_id'],
		'main_department_ref_id'	=> $array['main_department_ref_id']
		);
		$criteria->addInCondition('di_user_ref_id', $diUsers);
		
		$DiUserEoi = DiUserEoi::model()->find($criteria);
		if(!empty($DiUserEoi)){
			$di_user_eoi_id = $DiUserEoi->di_user_eoi_id;
			$model = DiUserEoi::model()->findByPk($di_user_eoi_id);
		}
		
        $model->di_user_ref_id          =   $array['di_user_ref_id'];
        $model->user_ref_id             =   $array['user_ref_id'];
        $model->main_department_ref_id  =   $array['main_department_ref_id'];
        $model->intake                  =   $array['intake'];
        $model->admission_chance        =   $array['admission_chance'];
        $model->umail_message_ref_id    =   $array['umail_message_ref_id'];
        $model->user_acceptance_status  =   $array['user_acceptance_status'];
        $model->user_viewed_on          =   $array['user_viewed_on'];
        $model->eoi_status              =   $array['eoi_status'];
        $model->eoi_type                =   $array['eoi_type'];
        $model->added_on                =   new CDbExpression('NOW()');
        $model->added_by                =   $array['added_by'];

        if($model->save()){

            $logModel->di_user_ref_id           =   $array['di_user_ref_id'];
            $logModel->user_ref_id              =   $array['user_ref_id'];
            $logModel->main_department_ref_id   =   $array['main_department_ref_id'];
            $logModel->intake                   =   $array['intake'];
            $logModel->admission_chance         =   $array['admission_chance'];
            $logModel->umail_message_ref_id     =   $array['umail_message_ref_id'];
            $logModel->user_acceptance_status   =   $array['user_acceptance_status'];
            $logModel->user_viewed_on           =   $array['user_viewed_on'];
            $logModel->eoi_status               =   $array['eoi_status'];
            $logModel->added_on                 =   new CDbExpression('NOW()');
            $logModel->added_by                 =   $array['added_by'];

            if($logModel->save()):
                return $model->di_user_eoi_id;
            else:
               return false;
               print_r($logModel->getErrors());
            endif;
        }else{
            return false;
            print_r($model->getErrors());
        }
    }


    /*
     *  addUserScholarship function add scholarship data
     *
     */

    public static function addUserScholarship($array    =   array()){

        $model      =   new DiUserEoiScholarship();
        $logModel   =   new DiUserEoiScholarshipLog();

        $model->di_user_eoi_ref_id      =   $array['di_user_eoi_ref_id'];
        $model->scholarship_ref_id      =   $array['scholarship_ref_id'];
        $model->scholarship_chance      =   $array['scholarship_chance'];
        $model->scholarship_description =   $array['scholarship_description'];
        $model->scholarship_name        =   $array['scholarship_name'];
        $model->amount                  =   $array['amount'];
        $model->added_on                =   new CDbExpression('NOW()');
        $model->added_by                =   $array['added_by'];

        if($model->save()){

            $logModel->di_user_eoi_ref_id       =   $array['di_user_eoi_ref_id'];
            $logModel->scholarship_ref_id       =   $array['scholarship_ref_id'];
            $logModel->scholarship_chance       =   $array['scholarship_chance'];
            $logModel->scholarship_description  =   $array['scholarship_description'];
            $logModel->scholarship_name         =   $array['scholarship_name'];
            $logModel->amount                   =   $array['amount'];
            $logModel->added_on                 =   new CDbExpression('NOW()');
            $logModel->added_by                 =   $array['added_by'];

            if($logModel->save()):
                return $model->di_user_eoi_scholarship_id;
            else:
                return false;
                echo "<pre>";
                print_R($logModel->getErrors());
            endif;
        }else{
            return false;
            echo "<pre>";
            print_R($model->getErrors());
        }
    }

    public static function addDiUserCriteriaShortlist($array  = array()){

		/*
		$model = DiUserCriteriaShortlist::model()->findByAttributes(array(
			'di_user_ref_id'            => $array['di_user_ref_id'],
			'user_ref_id'               => $array['user_ref_id'],
			'main_department_ref_id'    => $array['main_department_ref_id']
		));
		*/

		$model = DiUserCriteriaShortlist::model()->findByAttributes(array(
			'di_user_eoi_ref_id'            => $array['di_user_eoi_ref_id'],
		));

        // if model not found then create new
        if($model === null){
            $model  = new DiUserCriteriaShortlist();
        }

        if($model->isNewRecord){

            $model->di_user_ref_id          =   $array['di_user_ref_id'];
            $model->di_user_eoi_ref_id      =   $array['di_user_eoi_ref_id'];
            $model->user_ref_id             =   $array['user_ref_id'];
            $model->main_department_ref_id  =   $array['main_department_ref_id'];
            $model->added_on             =   new CDbExpression('NOW()');
            $model->added_by                =   $array['added_by'];
        } else{
            $model->di_user_ref_id          =   $array['di_user_ref_id'];
            $model->user_ref_id             =   $array['user_ref_id'];
            $model->main_department_ref_id  =   $array['main_department_ref_id'];
            $model->modified_on             =   new CDbExpression('NOW()');
            $model->modified_by             =   $array['added_by'];
        }

       if($model->save()){
           return $model->di_user_criteria_shortlist_id;
       } else{
           return false;
       }
    }

    public static function SendMail($array = array()){
        $params = array();
        $params['EmailMessage']['subject']      =   $array['subject'];
        $params['EmailMessage']['body']         =   $array['msg'];
        $params['EmailMessage']['type']         =   $array['mailtype'];
        $params['EmailMessage']['siteUrl']      =   $array['siteUrl'];
        $params['EmailMessage']['cc']           =   $array['cc'];
        $params['EmailMessage']['toName']       =   $array['toname'];
        $params['EmailMessage']['toEmail']      =   $array['to'];
        $params['EmailMessage']['apiKey']       =   Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', Yii::app()->createUrl('sms/email/addMessage'));
        $status = Yii::app()->runController("sms/email/addMessage");
        return $status;
    }

    public static function getUserEmailAddress($login_id){
        $model  =   new LoginMaster();
        $data   =   $model->findByPk($login_id);
        if($data===NULL){
             return 'noemailidavailable@testing.com';
        }else{
            return $data->username;
        }

    }

    public static function addScholarship($array    =   array()){
        $model                              =   new Scholarship();
        $model->scholarship_name            =   $array['scholarship_name'];
        $model->scholarship_description     =   $array['scholarship_description'];
        $model->scholarship_provider_ref_id =   $array['scholarship_provider_ref_id'];
        $model->scholarship_provider_name   =   $array['scholarship_provider_name'];
        $model->currency_ref_id             =   $array['currency_ref_id'];
        $model->amount                      =   $array['amount'];
        $model->number_of_scholarships      =   $array['number_of_scholarships'];
        $model->gender                      =   $array['gender'];
        $model->added_on                    =   $array['added_on'];
        $model->added_by                    =   $array['added_by'];
        $model->is_active                   =   $array['is_active'];
        $model->save();
        if($model->save()){
            return $model->scholarship_id;
        }else{
                echo "<pre>";
                print_R($model->getErrors());
        }

    }

    public static function addScholarshipDepartment($array  =   array(),$departmentsList){
        foreach($departmentsList as $key => $value){
            $model                          =   new ScholarshipDepartment();
            $model->scholarship_ref_id      =   $array['scholarship_ref_id'];
            $model->main_dept_ref_id        =   $key;
            $model->added_on                =   $array['added_on'];
            $model->added_by                =   $array['added_by'];
            $model->save();
        }
    }

    public static function addScholarshipHostInstitute($array   =   array()){
        $model                          =   new ScholarshipHostInstitute();
        $model->scholarship_ref_id	    =   $array['scholarship_ref_id'];
        $model->continent_ref_id	    =	$array['continent_ref_id'];
        $model->country_ref_id		    =	$array['country_ref_id'];
        $model->university_type		    =	$array['university_type'];
        $model->uni_ref_id			    =   $array['uni_ref_id'];
        $model->added_on			    =   $array['added_on'];
        $model->added_by                =   $array['added_by'];
        if($model->save()){
            return $model->scholarship_host_institute_id;
        }else{
            print_R($model->getErrors());
        }
    }

    public static function addScholarshipPackage($array =   array()){

        $diDepartment   =   DiHelper::getDiUserDepartment($array['di_user_id']);
        $ScholarshipData        =   array(
            'scholarship_name'              =>  $array['scholarshipName'],
            'scholarship_description'       =>  $array['scholarshipDesc'],
            'scholarship_provider_ref_id'   =>  '2', #institute type
            'scholarship_provider_name'     =>  $array['scholarship_provider_name'],
            'currency_ref_id'               =>  $array['currency_ref_id'],
            'amount'                        =>  $array['scholarshipPrice'],
            'number_of_scholarships'        =>  '1',
            'gender'                        =>  'ALL',
            'added_on'                      =>  new CDbExpression('NOW()'),
            'added_by'                      =>  $array['login_id'],
            'is_active'                     =>  '1',
        );



        $Scholarship_id     =   self::addScholarship($ScholarshipData);

        $ScholarshipDepartmentData        =   array(
            'scholarship_ref_id'            =>  $Scholarship_id,
            'added_on'                      =>  new CDbExpression('NOW()'),
            'added_by'                      =>  $array['login_id'],
        );

        self::addScholarshipDepartment($ScholarshipDepartmentData,$diDepartment);


            $ScholarshipHostInstituteData   =   array(
            'scholarship_ref_id'            =>  $Scholarship_id,
            'continent_ref_id'              =>  '2', #asia
            'country_ref_id'                =>  $array['country_ref_id'],
            'university_type'               =>  'All',
            'uni_ref_id'                    =>  $array['university_id'],
            'added_on'                      =>  new CDbExpression('NOW()'),
            'added_by'                      =>  $array['login_id'],
        );

        self::addScholarshipHostInstitute($ScholarshipHostInstituteData);
        return $Scholarship_id;
    }

    /*
     *  function change the status of dihotlead user from null to view of viewed profile in diUserHotlead table
     *
     */

    public static function diHotLeadStatusToRead($diUserHotLeadId   =   '0'){
        $model  =   new DiUserHotlead();
        $update =   $model->updateByPk($diUserHotLeadId, array('status'=>'View'));
        return $update;
    }

    /*
     *  function fetch common department of logged di users and diuserhotlead user
     */

    public static function getDiAndStudentCommonDepartments($diHotLeadId = '0', $diUserID = '0'){
        $sql    =   "SELECT";
        $sql    .=   " DIHL.di_user_hotlead_id,STHL.student_hotlead_id,UM.user_id,PREFDEPT.main_dept_ref_id,DEPT.department_name";
        $sql    .=   " FROM di_user_hotlead `DIHL`";
        $sql    .=   " INNER JOIN student_hotlead `STHL` ON STHL.student_hotlead_id = DIHL.student_hotlead_ref_id";
        $sql    .=   " INNER JOIN tbl_user_master `UM` ON UM.user_id = STHL.user_ref_id";
        $sql    .=   " INNER JOIN student_preferred_department `PREFDEPT` ON PREFDEPT.user_ref_id = UM.user_id";
        $sql    .=   " INNER JOIN lookup_department DEPT ON PREFDEPT.main_dept_ref_id = DEPT.department_id";
        $sql    .=   " WHERE DIHL.di_user_hotlead_id= '$diHotLeadId' AND PREFDEPT.main_dept_ref_id IN (";
        $sql    .=   " SELECT main_department_ref_id FROM di_user_department WHERE di_user_ref_id = '$diUserID'";
        $sql    .=   " )";
        $sql    .=   " ORDER BY di_user_hotlead_id";
        $connection  = Yii::app()->db;
        $command     = $connection->createCommand($sql);
        $rowCount    = $command->execute(); // execute the non-query SQL

        if($rowCount>0){
            $data = $command->queryAll();
            return $data;
        } else{
            return array();
        }
    }

    /*
     * cron job for checking whether user has change his department and the current department is matching
     * with di user
     */

    public static function cronHotleadRefund(){
        $AllHotleads    =   DiUserHotlead::model()->findAll();
        $error          =   0;
        foreach($AllHotleads as $value){
            $response   =   self::getDiAndStudentCommonDepartments($value->di_user_hotlead_id,$value->di_user_ref_id);
            if(count($response)==0){
                $data   =   DiUserHotlead::model()->updateByPk($value->di_user_hotlead_id, array('status'=>'Refund'));
                if($data==0){
                    $error += 1;
                }
            }
        }
        if($error==0){
            return true;
        }else{
            return false;
        }
    }

    /*
     *  function retrieve list of board from lookup_board table
     */

    public static function getBoard(){
        $model  =   new LookupBoard();
        $boards =   CHtml::listData($model->findAll(),'board_id','board_desc');
        return $boards;
    }


	
    /*
     * function retrieve entrance exam data from entrance_exam table with join with two other table
     */

    public static function getEntranceExam(){
        $sub_id     =   Yii::app()->user->sub_id;
        $model      =   new EntranceExam();
		
		$di_id =  Yii::app()->user->di_id;
		$diDetail = self::GetDiDetails($di_id);
		$uni_country_id = $diDetail->uniRef->countryRef->country_id; // get country ID 
		
        $sql ="SELECT DISTINCT(entrance_id),exam.* ";
        $sql .="FROM entrance_exam `exam` ";
        $sql .="INNER JOIN entrance_exam_applicable_location `location` ON exam.entrance_id=location.entrance_exam_ref_id ";
        $sql .="INNER JOIN entrance_exam_applicable_department `department` ON exam.entrance_id=department.entrance_exam_ref_id ";
        $sql .="WHERE exam.is_active=1 ";
		$sql .=  " AND location.country_ref_id = '$uni_country_id' ";
		
		

       /* if(isset($_REQUEST['country_id']) && $_REQUEST['country_id']!=''){
            $country_id  =   $_REQUEST['country_id'];
            $sql        .=  " AND location.country_ref_id = '$country_id' ";
        }else{*/
		
		
		
		//}
		
        if(isset($_REQUEST['department_id']) && $_REQUEST['department_id']!=''){
            $department_id  =   $_REQUEST['department_id'];
            $sql            .=  " AND department.main_department_ref_id  = '$department_id' ";
        }
		
		if(isset($_REQUEST['country_id']) && isset($_REQUEST['department_id'])){
			if($_REQUEST['country_id']=="" && $_REQUEST['department_id']==''){
				$sql    .=  " AND department.main_department_ref_id IN
			(SELECT main_department_ref_id FROM di_user_department WHERE di_user_ref_id = '$sub_id') ";
			}
		}
		
		if(!isset($_REQUEST['country_id']) && !isset($_REQUEST['department_id'])){
				$sql    .=  " AND department.main_department_ref_id IN
			(SELECT main_department_ref_id FROM di_user_department WHERE di_user_ref_id = '$sub_id') ";
		}
		//echo $sql;
        return $data                   =   $model->findAllBySql($sql);
    }


    public static function getEntranceExamDropDown($selectedId = '0',$main=false,$returnCount=false){
        $data       =   self::getEntranceExam();
        $listData   =  CHtml::listData($data,'entrance_id','entrance_short_name');
		if($returnCount)
		return count($listData);
		
		if($main){
			if($selectedId==0){
			//$listData = array();// By default show empty dropdown, exam only filled if di user selected main department
			}
			return CHtml::dropDownList('entrance_exam[]',$selectedId,$listData,array('empty'=>'SELECT STANDARD EXAM','class'=>'examDropDown selects', 'id'=>'entrance_exam_main'));
		} else{
			return CHtml::dropDownList('entrance_exam[]',$selectedId,$listData,array('empty'=>'SELECT STANDARD EXAM','class'=>'examDropDown selects', 'id'=>'entrance_exam_main'));
		}
    }

    public static function getEntranceExamModule($examId){
		
		
		# OLD QUERY 
		
		/*$criteria=	new CDbCriteria();
		$criteria->condition	=	"entrance_exam_ref_id=:x";
		$criteria->params		=	array(':x'=>$examId);
		$model  =   new EntranceExamModuleEntranceExam();
        $data   =   $model->findAll($criteria);*/
		
		$model  =   new EntranceExamModuleEntranceExam();
		$criteria=	new CDbCriteria();
		$criteria->with = array('entranceExamRef');
		$criteria->condition	=	"entrance_exam_ref_id=:x AND entranceExamRef.is_active=1";
		$criteria->params		=	array(':x'=>$examId);
        $data   =   $model->findAll($criteria);
	
	
		
			/*echo $sql ="SELECT entrance_exam_module_entrance_exam.*,entrance_exam.* FROM 		
			entrance_exam_module_entrance_exam,entrance_exam
			WHERE (entrance_exam_module_entrance_exam.entrance_exam_ref_id='77' AND entrance_exam_module_entrance_exam.entrance_exam_ref_id = entrance_exam.entrance_id)";
			$connection=Yii::app()->db;
			$command=$connection->createCommand($sql);
			$data=$command->queryAll();*/
		
        return $data;
    }

    public static function getEntranceExamModuleHtml($examId = '0',$data    =   ''){

        $minVal = $data ? $data[0]->min : '';
        $maxVal = $data ? $data[0]->max : '';

        return "<div class='st-right-only'>
                    <div class='st-right'>
                        <div class='st-right-filedname'>Min Marks</div>
                        <div class='st-right-field'>
                            <div class='row select-form'>
                                <input type='text' name='examArray[$examId][0][min]' value='{$minVal}' id='examMaxMarks_0'/>
                                <span id='examMinMarks_0_Error' class='errorMessage'></span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class='st-right-only'>
                    <div class='st-right'>
                        <div class='st-right-filedname'>Max Marks</div>
                        <div class='st-right-field'>
                            <div class='row select-form'>
                                <input type='text' name='examArray[$examId][0][max]' value='{$maxVal}' id='examMaxMarks_0'/>
                                <span id='examMinMarks_0_Error' class='errorMessage'></span>

                            </div>
                        </div>
                    </div>
                </div>";

        $ExamModule  =   self::getEntranceExamModule($examId);
		if((count($ExamModule)>0) && (count($data)>0)){
        echo '<div class="clr h-20"></div>
		<div class="row">';
		echo "<table style='width:100%; margin-top:20px;' class='bordered float_left'>
                        <thead>
                          <tr>
                            <th>&nbsp;</th>
                            <th>Min Marks</th>
                            <th>Max Marks</th>
                           
                          </tr>
                        </thead>
                        <tbody>";
						
        if(count($data)>0){
            $i=0;
            foreach($ExamModule as $value){
			
				//if($value->is_active!="0"){
					echo "<tr>
						<th>{$value->entranceExamModuleRef->module_name}</th>
						<td>
							<input data=".intval($value->max_marks)." type='text' name='examArray[$examId][{$value->entrance_exam_module_ref_id}][min]' value='{$data[$i]->min}' id='examMinMarks_".$i."' class='input-name ui-autocomplete-input examMinMarks' autocomplete='off' role='' aria-autocomplete='' aria-haspopup='true'>
							<span id='examMinMarks_".$i."_Error' class='errorMessage'></span>
					</td>
						<td>
							<input data=".intval($value->max_marks)." type='text' name='examArray[$examId][{$value->entrance_exam_module_ref_id}][max]' value='{$data[$i]->max}' id='examMaxMarks_".$i."' class='input-name ui-autocomplete-input examMaxMarks' autocomplete='off' role='' aria-autocomplete='' aria-haspopup='true'>
							<span id='examMaxMarks_".$i."_Error' class='errorMessage'></span>
						</td>
						
					</tr>";
			   $i++;
				//}
            }

        }else{
            foreach($ExamModule as $value){
				//if($value->is_active!="0"){
					echo "<tr>
							<th>{$value->entranceExamModuleRef->module_name}</th>
							<td>
								<input data=".intval($value->max_marks)." type='text' name='examArray[$examId][{$value->entrance_exam_module_ref_id}][min]' value='' id='examMinMarks_".$i."' class='input-name ui-autocomplete-input examMinMarks' autocomplete='off' role='' aria-autocomplete='' aria-haspopup='true'>
								<span id='examMinMarks_".$i."_Error' class='errorMessage'></span>
							</td>
							<td>
								<input data=".intval($value->max_marks)." type='text' name='examArray[$examId][{$value->entrance_exam_module_ref_id}][max]' value='' id='examMaxMarks_".$i."' class='input-name ui-autocomplete-input examMaxMarks' autocomplete='off' role='' aria-autocomplete='' aria-haspopup='true'>
								<span id='examMaxMarks_".$i."_Error' class='errorMessage'></span>
							</td>
						</tr>";
				 //}
			 }
        }
			echo " </tbody>
                      </table>";

        echo "</div>";
		}
    }

    public static function getDiUserCriteriaDuration($id = 0){
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   'di_user_criteria_ref_id=:x';
        $criteria->params       =   array(':x'=>$id);
        $data                   =   DiUserCriteriaDuration::model()->findAll($criteria);
        return $data;
    }

    public static function getDiUserCriteriaLikelyPeriod($id = '0'){
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   'di_user_criteria_ref_id=:x';
        $criteria->params       =   array(':x'=>$id);
        $data                   =   DiUserCriteriaLikelyPeriod::model()->findAll($criteria);
        return $data;
    }
    public static function getDiUserCriteriaEntranceExamId($id = '0'){
        $criteria               =   new CDbCriteria();
        $criteria->select       =   'DISTINCT(entrance_exam_ref_id) as entrance_exam_ref_id';
        $criteria->condition    =   'di_user_criteria_ref_id=:x';
        $criteria->params       =   array(':x'=>$id);
        $data                   =   DiUserCriteriaEntranceExam::model()->findAll($criteria);
        return $data;
    }

    public static function getDiUserCriteriaEntranceExam($id = '0'){
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   'di_user_criteria_ref_id=:x';
        $criteria->params       =   array(':x'=>$id);
        $data                   =   DiUserCriteriaEntranceExam::model()->findAll($criteria);
        return $data;
    }

    public static function getDiUserCriteriaEntranceExamIdData($entrance_exam_ref_id = '0',$di_user_criteria_ref_id = '0'){
        $criteria               =   new CDbCriteria();
        //$criteria->select       =   'DISTINCT(entrance_exam_ref_id) as entrance_exam_ref_id,min,max';
        $criteria->select       =   'entrance_exam_ref_id as entrance_exam_ref_id,min,max';
        $criteria->condition    =   'di_user_criteria_ref_id=:x AND entrance_exam_ref_id=:y';
        $criteria->params       =   array(':x'=>$di_user_criteria_ref_id,':y'=>$entrance_exam_ref_id);
        $data                   =   DiUserCriteriaEntranceExam::model()->findAll($criteria);
        return $data;
    }

	/*
	*	disabled criteria on base of id
	*/
	
    public static function disabledCriteria($id,$name){
        $rand   =   rand(1111,9999);
        $disabled   =   DiUserCriteria::model()->updateByPk($id,array('criteria_name'=>$name.'-disabled-'.$rand,'is_active'=>'0'));
        if($disabled){
            return true;
        }else{
            return false;
        }
    }
    public static function criteriaCount($di_user_id = 0){
        $model                  =   new DiUserCriteria;
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   "t.is_active=:x";
        $criteria->params       =   array(':x'=>'1');
		if($di_user_id!=0){
			$criteria->addCondition("di_user_ref_id=$di_user_id");
		}
        $count                   =   $model->count($criteria);
        return $count;
    }

	/*
	*	get all criterias 
	*/
	
    public static function getCriteria($offset = '',$limit = '',$di_user_ref_id = 0){
        $model                  =   new DiUserCriteria;
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   "t.is_active=:x";
        if($di_user_ref_id!=0){
			$criteria->addCondition("di_user_ref_id=$di_user_ref_id");
		}
		$criteria->limit        =   $limit;
        $criteria->offset       =   $offset;
        $criteria->params       =   array(':x'=>'1');
        $data                   =   $model->findAll($criteria);
        return $data;
    }

	/*
	*	criteria cron query 
	*/
	
    public static function criteriaCronQuery($record=null, $durationQuery='', $periodQuery='',$examQuery=''){

        $boardMarksType = DiHelper::getBoardEquivalent($record->board_ref_id)->overall_type;

	    $sqlSelect  =   "SELECT ";
        $sqlField   =   " DISTINCT(user.user_id) user_ref_id, $record->di_user_criteria_id as di_user_criteria_id, $record->added_by as added_by ";
        $sqlFrom    =   "FROM tbl_user_master `user` ";
        $sqlJoin   =   "INNER JOIN login_master lm                          ON user.login_ref_id=lm.login_id ";
        $sqlJoin   .=   "INNER JOIN student_preferred_department dep		 ON user.user_id = dep.user_ref_id ";
		
		if($record->citizenship!=null){
			$sqlJoin   .=   "LEFT JOIN student_citizenship citizenship		 ON user.user_id = citizenship.user_ref_id ";
		}

        if($record->country_ref_id!=null){
            $sqlJoin   .=   "INNER JOIN student_preferred_country country		 ON user.user_id = country.user_ref_id ";
        }

        $sqlJoin   .=   "INNER JOIN student_preferred_study_level studyLevel ON user.user_id = studyLevel.user_ref_id ";
		$sqlJoin   .=   "INNER JOIN lookup_course_level lc 					 ON lc.level_id = studyLevel.`course_level_ref_id`";

        if($durationQuery!=''){
        $sqlJoin   .=   "LEFT JOIN student_preferred_duration duration		 ON user.user_id = duration.user_ref_id ";
        }

        if($periodQuery!=''){
        $sqlJoin   .=   "LEFT JOIN student_preferred_period period		     ON user.user_id = period.user_ref_id ";
        }

        if($record->board_ref_id!=null){
        $sqlJoin   .=   "LEFT JOIN student_education education 			     ON user.user_id = education.user_ref_id ";
        //$sqlJoin   .=   "INNER JOIN student_grade_count grade                ON education.student_education_id= grade.student_education_ref_id ";
        $sqlJoin   .=   "INNER JOIN lookup_board_equivalent board 		     ON education.board_ref_id= board.board_equivalent_id ";
		
		if($boardMarksType == 'Grades'){
			$sqlJoin   .=   "INNER JOIN student_grade_count grade 		     	ON education.student_education_id= grade.student_education_ref_id ";
		}
        }
		
        if($examQuery != ''){
        $sqlJoin   .=   "LEFT JOIN `user_entrance_exam` uee ON (uee.user_ref_id = user.user_id AND `exam_status` = 'Completed') ";
        //$sqlJoin   .=   "LEFT JOIN `user_entrance_exam_module` ueem ON ueem.`user_entrance_exam_ref_id` = uee.`user_entrance_exam_id` ";
        }


        $sqlWhere   =   " WHERE ";

        $sqlCondition   =   "dep.main_dept_ref_id = $record->main_department_ref_id ";

        if($record->sub_dept_ref_id)
            $sqlCondition  .=   " AND dep.sub_dept_ref_id = $record->sub_dept_ref_id ";

        if($record->dept_preference_order!=null){
            $sqlCondition  .=   "AND dep.preference_order = $record->dept_preference_order ";
        }

        //$sqlCondition  .=   "AND ( lc.parent_ref_id = '$record->course_level_ref_id' OR lc.level_id = '$record->course_level_ref_id' ) ";
        $sqlCondition  .=   "AND ( lc.level_id = '$record->course_level_ref_id' ) ";

        if($record->user_home_country_ref_id!=null){
            $sqlCondition  .=   " AND user.country_ref_id = $record->user_home_country_ref_id ";
        }

        if($record->citizenship!=null){
            $sqlCondition  .=   "AND citizenship.citizenship_ref_id = $record->citizenship ";
        }

        if($record->gender!=null){
            $sqlCondition  .=   "AND user.gender = '$record->gender' ";
        }

        if($record->country_ref_id!=null){
            $sqlCondition  .=   "AND country.country_ref_id = $record->country_ref_id ";

            if($record->country_preference_order!=null){
                $sqlCondition  .=   "AND country.preference_order = $record->country_preference_order ";
            }
        }



        if($record->board_ref_id!=null){
            $sqlCondition  .=   "AND board.board_ref_id = '$record->board_ref_id' AND education.class_level = '12'";

            switch($boardMarksType){
                case 'Marks':
                case 'Points':{
                    if($record->min_marks!=null && $record->max_marks!=null)
                        $sqlCondition  .=   "AND education.overall_marks >= $record->min_marks AND  education.overall_marks <= $record->max_marks "; #Between won't consider start and end marks
                    break;
                }
                case 'Grades':{
                    $modelGrade    	=   new DiUserCriteriaGrade();
                    $grade			=	$modelGrade->findAll(array('condition'=>"di_user_criteria_ref_id=$record->di_user_criteria_id"));
                    $gradecondition =   '';
                    if($grade){
                        $orCondition = '';
                        foreach($grade as $value){
							if(($value->min_grade_count > 0) && ($value->grade_ref_id != null)){
								$gradecondition .= $orCondition . "(grade.grade_ref_id=$value->grade_ref_id AND grade.grade_count >= $value->min_grade_count)";
								$orCondition = " OR ";
							}
                        }
						if($gradecondition!=""){
                            //$gradecondition	=	rtrim($gradecondition,'OR');
                            $gradecondition	=	"AND (".$gradecondition.") ";
						}
                        $sqlCondition  .=   " ".$gradecondition." ";
                    }
                    break;
                }
            }
        }
        /*if($record->board_ref_id!=null){
            $sqlCondition  .=   "AND board.board_ref_id = '$record->board_ref_id' ";
        }
//		if(($record->min_marks!=null && $record->max_marks!=null) && DiHelper::getBoardEquivalent($record->board_ref_id)->overall_type=="Marks"){
//            $sqlCondition  .=   "AND education.overall_marks BETWEEN $record->min_marks AND $record->max_marks ";
//        }
		
        if(($record->min_marks!=null && $record->max_marks!=null) && ($record->min_marks!=0 && $record->max_marks!=0) && ($record->min_marks!="" && $record->max_marks!="") && DiHelper::getBoardEquivalent($record->board_ref_id)->overall_type=="Marks"){	# to compair overall marks
            $sqlCondition  .=   "AND education.overall_marks BETWEEN $record->min_marks AND $record->max_marks ";
        }else if(($record->min_marks!=null && $record->max_marks!=null) && ($record->min_marks!=0 && $record->max_marks!=0) && ($record->min_marks!="" && $record->max_marks!="") && DiHelper::getBoardEquivalent($record->board_ref_id)->overall_type=="Points"){ # to compair overall points
            $sqlCondition  .=   "AND education.overall_marks BETWEEN $record->min_marks AND $record->max_marks ";
        }
		else if(DiHelper::getBoardEquivalent($record->board_ref_id)->overall_type=="Grades"){
            $modelGrade    	=   new DiUserCriteriaGrade();
			$grade			=	$modelGrade->findAll(array('condition'=>"di_user_criteria_ref_id=$record->di_user_criteria_id"));
			if($grade){
			
				foreach($grade as $value){
					$gradecondition .= " (grade.grade_ref_id=$value->grade_ref_id AND grade.grade_count BETWEEN $value->min_grade_count AND $value->max_grade_count ) OR";
				}
				
			$gradecondition	=	rtrim($gradecondition,'OR');
			$gradecondition	=	"AND (".$gradecondition.") ";
			$sqlCondition  .=   " ".$gradecondition." ";
			}
			
        }*/

        if($durationQuery!=''){
            $sqlCondition  .=   "AND duration.duration_ref_id IN($durationQuery) ";
        }

        if($periodQuery!=''){
            //$sqlCondition  .=   "AND period.period_ref_id IN($periodQuery) ";
            $sqlCondition  .=   "AND period.year IN($periodQuery) ";
        }else{
            $sqlCondition  .=   "AND user.passout_year > YEAR(CURDATE()) ";
        }
		
        if($examQuery!=''){
            $sqlCondition  .=   "AND ($examQuery) ";
        }
		
		/*
        $notInQuery     =   "SELECT user_ref_id FROM di_user_criteria_match ";
        $notInQuery    .=   "WHERE di_user_criteria_ref_id = $record->di_user_criteria_id AND (`status` IS NULL OR `status`='EOI')";
		*/

		/*
		* Exclude List of student ids which are already matched under this criteria and
		* Exclude List of student ids which already comes under hotlead for same university
        $data   =   DiHelper::alertMatchExcludeUserIds($record->di_user_criteria_id,$record->diUserRef->diRef->uni_ref_id); # required removed ids while running query
        if(count($data)>0){
            $notInUserIds   =  implode(',',$data);
            $sqlCondition  .=   " AND user.user_id NOT IN($notInUserIds)";
        }
		*/


        //Blocking students who are in Shortlist/Bought/Reject
        $notINCond = DiHelper::getBoughtIgnoredOfferedUserIDs($record->di_user_ref_id);
        if(count($notINCond))
            $sqlCondition .= " AND user_id NOT IN (".implode(',', $notINCond).")";

            $query      =   $sqlSelect.$sqlField.$sqlFrom.$sqlJoin.$sqlWhere.$sqlCondition;
        //echo '<pre>'.($query).'</pre>';
    
		/* 
			query execution for debugging
			echo "<br/>query : ".$query;
			echo "<br/>duration : ".$durationQuery;
			echo "<br/>period : ".$periodQuery;
			echo "<br/>----------------end-----------------";
		*/

		$alertMatch =   Yii::app()->db->createCommand($query)->queryAll();
		return $alertMatch;
    }
	
    public static function criteriaCron($di_user_ref_id	=	0){
        $offset                 =   0;
        $limit                  =   3;
		$StoreData				=	0;
        $criteriaCount          =   self::criteriaCount($di_user_ref_id);
        $loopLimit              =   ceil($criteriaCount/$limit);
        for($i=0; $i<$loopLimit; $i++){

            $record               =   self::getCriteria($offset,$limit,$di_user_ref_id);
            foreach($record as $data){
                #duration
				$duration  =   self::getDiUserCriteriaDuration($data->di_user_criteria_id);
				$durationData	=	'';
				$durationQuery	=	'';
				if($duration){
                    $durationData   =   CHtml::listData($duration,'di_user_criteria_duration_id','duration_ref_id');
                    $durationData = array_filter($durationData);
                    $durationQuery  =   (count($durationData) > 0) ? implode(',',$durationData) : '';
                }
                
				#period
				$Period     =   self::getDiUserCriteriaLikelyPeriod($data->di_user_criteria_id);
				$periodData	=	'';
                $periodQuery	=	'';	
				if($Period){
                    $periodData     =   CHtml::listData($Period,'di_user_criteria_likely_period_id','starting_year');
                    $periodData = array_filter($periodData);
                    $periodQuery    =   (count($periodData) > 0) ? implode(',',$periodData) : '';
                }
                
				#exam data
				$entranceExam	=      self::getDiUserCriteriaEntranceExam($data->di_user_criteria_id);
                $examQuery		=		'';
				
				if($entranceExam && count($entranceExam)>0){
					$sqlExamArr = array();
					foreach($entranceExam as $entranceExamDetail){
					
							if(isset($entranceExamDetail->min) && isset($entranceExamDetail->max))
							{
								$entranceExamDetail->min = ( $entranceExamDetail->min!='' ) ? $entranceExamDetail->min : '0';
								$entranceExamDetail->max = ( $entranceExamDetail->max!='' ) ? $entranceExamDetail->max : '0';
								
								$sqlExam     =   '';
								$sqlExam    .= " ( uee.entrance_exam_ref_id = $entranceExamDetail->entrance_exam_ref_id ";
								//$sqlExam    .= " AND ueem.`entrance_exam_module_entrance_exam_ref_id`=$entranceExamDetail->entrance_exam_module_ref_id";
								//$sqlExam    .= " AND marks BETWEEN $entranceExamDetail->min AND $entranceExamDetail->max ) ";
								$sqlExam    .= " AND uee.overall_marks BETWEEN $entranceExamDetail->min AND $entranceExamDetail->max ) ";
								$sqlExamArr[]  =   $sqlExam;
							}	
					}
					if(is_array($sqlExamArr) && count($sqlExamArr)>0){
						$examQuery  .= implode(' OR ',$sqlExamArr);
					}
                }
                $Query              =     self::criteriaCronQuery($data,$durationQuery,$periodQuery,$examQuery);
                $StoreData         +=     self::storeCriteriaMatch($Query);
				
            }
            $offset += $limit;
        }
		return $StoreData;
    }


	
	/*
	*	storeCriteriaMatch to store criteria cron result 
	*/
    public static function storeCriteriaMatch($records){
        $total  =   0;
        foreach($records as $data){
			/*
			find if criteria match record is in di_user_critera_shortlist table
			then ignore this match
			student id
			main_department_id
			di_id
			*/
			$DiUserCriteria = DiUserCriteria::model()->findByPk($data['di_user_criteria_id']);
			$user_ref_id		= $data['user_ref_id'];
			$main_department_id = $DiUserCriteria->main_department_ref_id;
			$di_user_ref_id 	= $DiUserCriteria->di_user_ref_id;
			
			/**
			 * Check if student is passed through Validation Flag system
			 * If passed then only need to insert in criteria match
			 * This securety check required because in criteria may be thousands of student
			 * We need students only with quality data who passed following 3 checks
			 * 1. is_email_confirmed	2. is_class_status_confirmed	3. is_preference_confirmed
			*/
			
			$EligibilityEngineObj = new StudentEligibilityUpdatesHandlerEngine();
			$EligibilityEngineObj->type 		= "alertmatch";
			$EligibilityEngineObj->studentId 	= $user_ref_id;
			$EligibilityEngineObj->universityId = $EligibilityEngineObj->getUniversityId($di_user_ref_id);
			
			
			// Save only if Eligible
			if($EligibilityEngineObj->isValidationFlagsEligible()) //&& $EligibilityEngineObj->isPereferenceEligible())
			{
                /*
				// Dont add entery if already exist
				$condition = "
				user_ref_id = ".$user_ref_id." AND 
				main_department_ref_id = ".$main_department_id." AND 
				di_user_ref_id = ".$di_user_ref_id."";
				
				$isExist = DiUserCriteriaShortlist::model()->exists($condition);
				
				if(!$isExist) { */

					$model                              =   new DiUserCriteriaMatch();
					$model->di_user_criteria_ref_id     =   $data['di_user_criteria_id'];
					$model->user_ref_id                 =   $data['user_ref_id'];
					$model->is_viewed                   =   0;
					$model->status                      =   null;
					$model->added_on                    =   new CDbExpression('NOW()');
					$model->added_by                    =   $data['added_by'];
					$model->save();
					$total  +=  1;
				// }
				
			}// Check through student validation system
        }
		return $total;
    }

	public static function getStudentInterestedCountries(){
        $criteria =   new CDbCriteria();
        $criteria->addCondition("t.is_stud_interested = 'Y' AND t.is_active = 'Y'", "AND");
        $criteria->order = 't.country_name ASC';
        return TblCountryMaster::model()->findAll($criteria);
    }

    public static function getDiUserCriteriaMatch($diCriteriaId =   0){ # for Criteria Alert cron
        $model                  =   new DiUserCriteriaMatch();
        $criteria               =   new CDbCriteria();
        $criteria->condition    =   "di_user_criteria_ref_id=:x";
        $criteria->params       =   array(':x'=>$diCriteriaId);
        $data                   =   $model->findAll($criteria);
        if($data===null){
            return array();
        }else{
            return $data;
        }
    }

    public static function getStudentHotLeads($universityID = 0){ # for Criteria Alert cron

        $users = Yii::app()->db->createCommand()
            ->select('DISTINCT(stuHotLD.user_ref_id) user_ref_id')
            ->from('student_hotlead stuHotLD')
            ->leftjoin('di_user_hotlead userHotLD', 'stuHotLD.student_hotlead_id=userHotLD.student_hotlead_ref_id')
            ->where('(userHotLD.status IS NULL OR userHotLD.status= "View" OR userHotLD.status= "Buy") AND stuHotLD.uni_ref_id=:x
AND stuHotLD.status NOT IN ("Reject")',array(':x'=>$universityID))
            ->queryAll();

            if(count($users)>0){
                $response   =   array_values($users);
                foreach($response as $data){
                    $arrayData[]  =   $data['user_ref_id'];
                }
                return $arrayData;
            }else{
                return array();
            }
    }

	/*
		This Function is part of criteria cron
		Criteria cron function run 3 times
		1. When Di create crieria
		2. When Di Update criteria
		3. Run in cron after some time interval
		When running criteria cron this Funnctions responsibility is to exclude those
		listings which are already exist in criteria
		or which exist in Hotlead
	*/	
    public static function alertMatchExcludeUserIds($criteria_ref_id=0,$uni_ref_id=0){
        $data   =   array();
        $hotLead=   array();
        $criteria   =   self::getDiUserCriteriaMatch($criteria_ref_id);
        if(count($criteria)>0){
			// get student ids from criteria_match that are already exist about this criteria
            $data   =   CHtml::listData($criteria,'di_user_criteria_match_id','user_ref_id');
        }
        $hotLead    =   self::getStudentHotLeads($uni_ref_id);
        $array   =   array_unique(array_merge($data,$hotLead));
        if(count($array)>0){
            return $array;
        }else{
            return array();
        }
    }

    public static function getTopCollege($offset = 0, $limit = 0, $deptId = 0, $countryId = 0, $gender = '') {
        
        // Do not show any result if no department and country selected 
        if($countryId == '' && $deptId == '') { return; }
        
        $criteria = new CDbCriteria();
        $criteria->select = 'DISTINCT(t.top_college_ref_id),t.country_ref_id,t.level_type';
        $criteria->condition = 't.top_college_ref_id IS NOT NULL ';
        $criteria->compare('t.department_ref_id', $deptId);
        $criteria->compare('t.country_ref_id', $countryId);
        $criteria->compare('t.is_active', 1);
        if ($gender != '') {
            if ($gender == 'M') {
                $gender_sql = " (coed IN ('Boys', 'Co-Education') OR coed IS NULL)";
            } elseif ($gender == 'F') {
                $gender_sql = " (coed IN ('Girls', 'Co-Education') OR coed IS NULL)";
            }
            $criteria->join .=" INNER JOIN tbl_university_master AS tum ON tum.uni_id = t.top_college_ref_id ";
            $criteria->addCondition($gender_sql, 'AND');
        }
        $criteria->order = "top_college_rank";
        $criteria->offset = $offset;
        if($limit)
            $criteria->limit = $limit;
        /*CVarDumper::dump($criteria,10,true);*/
        return TopPopularCollege::model()->findAll($criteria);
	}

	/*
    public static function getTopCollegeByCity($offset = 0, $limit = 0, $countryId = 0, $deptId = 0, $subDeptId = 0, $state = '', $city = '') {
		
        // Do not show any result if no department and country selected
        //print_r($city); exit;
        $level = 6;
        if($countryId == '' && $deptId == '') { return; }

        $condition = '';
        //$cond = '';
        if (!empty($city)) {
            $cities = implode(',',$city);
            $condition .= " AND tum.city_ref_id in ($cities)";
        }
        if (!empty($state)) {
            $states = implode(',',$state);
            $condition .= " AND tum.state_ref_id in ($states)";
        }

        if ($subDeptId && ($subDeptId != 'others')) {
            $condition .= " AND uc.department_ref_id =" .$subDeptId;
        }

        if($level){
            $condition .= " AND uc.course_level =" .$level;
        }

            $condition .= " AND uc.is_active = 'Y'";
            $condition .= " AND tum.is_active = 'Y'";

        $criteria = new CDbCriteria();
        $criteria->select = 'DISTINCT(top_college_ref_id),t.country_ref_id,level_type, t.department_ref_id';
        $criteria->condition = 'top_college_ref_id IS NOT NULL '.$condition ;
        $criteria->compare('t.department_ref_id', $deptId);
        $criteria->compare('t.country_ref_id', $countryId);
        $criteria->compare('t.is_active', 1);
        $criteria->join .=" inner join tbl_university_master as tum on tum.uni_id = t.top_college_ref_id ";
        $criteria->join .=" inner join lookup_department ld ON ld.department_id = t.department_ref_id";
        $criteria->join .=" left join lookup_department ld1 ON ld1.main_dept_id = ld.department_id";
        $criteria->join .=" JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.top_college_ref_id";
        $criteria->order = "top_college_rank";
        $criteria->offset = $offset;
        if($limit)
            $criteria->limit = $limit;
        return TopPopularCollege::model()->findAll($criteria);
    }

	
	*/
	
	
	public static function getTopCollegeByCity($offset = 0, $limit = 0, $countryId = 0, $deptId = 0, $subDeptId = 0, $state = '', $city = '') {

        // Do not show any result if no department and country selected
        //print_r($city); exit;
        $level = 6;
        if($countryId == '' && $deptId == '') { return; }

        $condition = '';
        //$cond = '';
        if (!empty($city)) {
            $cities = implode(',',$city);
            $condition .= " AND tum.city_ref_id in ($cities)";
        }
        if (!empty($state)) {
            $states = implode(',',$state);
            $condition .= " AND tum.state_ref_id in ($states)";
        }

        // if there is no subdepartment selection then considered all the subdepartments of that selected main department and paas o query

        if($deptId && (!$subDeptId) && $subDeptId != 'others'){
            $subdepartments = LookupDepartment::model()->findAll('main_dept_id= :Id',array(':Id'=>$deptId));
            $subdepartmentIds = CHtml::listData($subdepartments,'department_id','department_id');
            $subdepartmentIds = implode(',',$subdepartmentIds);
            $condition .= "AND uc.department_ref_id IN ($subdepartmentIds)";
        }

        if ($deptId && $subDeptId && ($subDeptId != 'others')) {
            $condition .= " AND uc.department_ref_id =" .$subDeptId;
        }

//        if ($subDeptId && ($subDeptId != 'others')) {
//            $condition .= " AND uc.department_ref_id =" .$subDeptId;
//        }

        if($level){
            $condition .= " AND uc.course_level =" .$level;
        }

            $condition .= " AND uc.is_active = 'Y'";
            $condition .= " AND tum.is_active = 'Y'";

        $criteria = new CDbCriteria();
        $criteria->select = 'DISTINCT(top_college_ref_id),t.country_ref_id,level_type, t.department_ref_id';
        $criteria->condition = 'top_college_ref_id IS NOT NULL '.$condition ;
        $criteria->compare('t.department_ref_id', $deptId);
        $criteria->compare('t.country_ref_id', $countryId);
        $criteria->compare('t.is_active', 1);
        $criteria->join .=" inner join tbl_university_master as tum on tum.uni_id = t.top_college_ref_id ";
        $criteria->join .=" inner join lookup_department ld ON ld.department_id = t.department_ref_id";
        $criteria->join .=" left join lookup_department ld1 ON ld1.main_dept_id = ld.department_id";
        $criteria->join .=" JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.top_college_ref_id";
        $criteria->order = "top_college_rank";


        $criteria->offset = $offset;
        if($limit)
            $criteria->limit = $limit;

      //  echo $criteria->getText();exit;

        return TopPopularCollege::model()->findAll($criteria);
    }
	
    public static function getTopCollegeBySubDept($offset = 0, $limit = 0, $deptId = 0, $countryId = 0, $sub_dept = 0, $gender = '') {

        // Do not show any result if no department and country selected
        if($countryId == '' && $deptId == '') { return; }

        $criteria = new CDbCriteria();
        $criteria->select = 'DISTINCT(t.top_college_ref_id),t.country_ref_id,t.level_type';
        $criteria->condition = 'top_college_ref_id IS NOT NULL';
        $criteria->compare('t.department_ref_id', $deptId);
        $criteria->compare('t.country_ref_id', $countryId);
        $criteria->join = " INNER JOIN tbl_uni_courses AS tuc ON tuc.uni_ref_id = t.top_college_ref_id AND tuc.department_ref_id = $sub_dept "." AND tuc.course_level in (6,7) ";
        $criteria->compare('t.is_active', 1);
        if ($gender != '') {
            if ($gender == 'M') {
                $gender_sql = " (coed IN ('Boys', 'Co-Education') OR coed IS NULL)";
            } elseif ($gender == 'F') {
                $gender_sql = " (coed IN ('Girls', 'Co-Education') OR coed IS NULL)";
            }
            $criteria->join .=" INNER JOIN tbl_university_master AS tum ON tum.uni_id = t.top_college_ref_id ";
            $criteria->addCondition($gender_sql, 'AND');
        }
        $criteria->order = "t.top_college_rank";
        $criteria->offset = $offset;
        if($limit)
            $criteria->limit = $limit;
        /*CVarDumper::dump($criteria,10,true);*/
        return TopPopularCollege::model()->findAll($criteria);
    }

    

    public static function getPopularCollege($offset = 0, $limit = 0, $deptId = 0, $countryId = 0) {
        $criteria = new CDbCriteria();
        $criteria->select = 'DISTINCT(top_college_ref_id),country_ref_id,level_type';
        $criteria->condition = 'popular_college_ref_id IS NOT NULL';
        $criteria->compare('department_ref_id', $deptId);
        $criteria->compare('country_ref_id', $countryId);
        $criteria->compare('is_active', 1);
        $criteria->order = "top_college_rank";
        $criteria->offset = $offset;
        if($limit)
            $criteria->limit = $limit;
        return TopPopularCollege::model()->findAll($criteria);
    }

	

	public static function createShortlistSearchCriteria($searchArr){
        $sqlObj 							= new stdClass;
        $sqlObj->select 					= array();
        $sqlObj->condition->mustTrue        = array();
        $sqlObj->condition->studyLevel      = array();
        $sqlObj->condition->country         = array();
        $sqlObj->condition->applyStatus     = array();
        $sqlObj->condition->department      = array();
        $sqlObj->condition->likelyPeriod    = array();
        $sqlObj->from   					= array();
        $sqlObj->order						= array();
        $sqlObj->unionAll					= array();

        // Start Building Sql Query Object
        $sqlObj->select = array(
            'DISTINCT SH.student_hotlead_id',
            'DUH.di_user_hotlead_id',
            'DUH.di_user_ref_id',
            'DUH.status',
            'TUM.user_id',
            'TUM.first_name',
            'TUM.last_name',
            "'hotlead' AS shortlist_type",
            '0 AS shortlist_id',
        );
        $sqlObj->from   = array(
            'di_user_hotlead AS DUH',
            'student_hotlead AS SH',
            'tbl_user_master AS TUM'
        );

        array_push($sqlObj->condition->mustTrue,"DUH.student_hotlead_ref_id = SH.student_hotlead_id");
        array_push($sqlObj->condition->mustTrue,"SH.user_ref_id = TUM.user_id");
        /*if(isset($_POST['search'])){
        array_push($sqlObj->condition->mustTrue,"DUH.status = 'Buy'");
        }else{
            array_push($sqlObj->condition->mustTrue,"(DUH.status = 'Buy' OR DUH.status = 'Refund')");
        }*/
        array_push($sqlObj->condition->mustTrue,"(DUH.status = 'Buy' OR DUH.status = 'Refund')");


        //array_push($sqlObj->condition->mustTrue,"DUH.status = 'Refund'");


        // Always Must True But Only ignore this When user want to notviewed hot deals
        if( isset($searchArr['leftFilterType'])){
             array_push($sqlObj->condition->applyStatus,"SH.status = '$searchArr[leftFilterType]'");
        }else{
             array_push($sqlObj->condition->applyStatus,"SH.status = 'Applied'");
			 //array_push($sqlObj->condition->applyStatus,"(SH.status = 'Applied' OR SH.status = 'Applied' OR SH.status = 'WillApply')");
		}

        foreach($searchArr as $filterKey=>$filterArr)
        {
            switch($filterKey)
            {
                case 'studyLevel':
                    array_push($sqlObj->from,"student_preferred_study_level AS SPSL");
                    array_push($sqlObj->condition->mustTrue,"TUM.user_id = SPSL.user_ref_id");
					
                    foreach($filterArr as $filterVal){
						$model = LookupCourseLevel::model()->findAllByAttributes(array('parent_ref_id'=>$filterVal));
						$subDepartments = CHtml::listData($model,'level_id','level_id');
						$mainDepartment	= $filterVal;
						$subDepartments = implode(',',$subDepartments);
						$subDepartments = $subDepartments.','.$mainDepartment;
                        array_push($sqlObj->condition->studyLevel,"SPSL.course_level_ref_id IN ($subDepartments)");
                    }
                break;

                case 'country':
                    foreach($filterArr as $filterVal){
                        if($filterVal=="other"){
                            array_push($sqlObj->condition->country,"TUM.country_ref_id is NULL");
                        } else{
                            array_push($sqlObj->condition->country,"TUM.country_ref_id = $filterVal");
                        }
                    }
                break;

                /* case 'applyStatus':
                    foreach($filterArr as $filterVal){
                        array_push($sqlObj->condition->applyStatus,"SH.status = '$filterVal'");
                    }
                break; */

                case 'department':
                    array_push($sqlObj->from,"student_preferred_department AS SPD");
                    array_push($sqlObj->condition->mustTrue,"TUM.user_id = SPD.user_ref_id");
                    foreach($filterArr as $filterVal){
                        array_push($sqlObj->condition->department,"SPD.main_dept_ref_id = $filterVal");
                    }
                break;

                case 'likelyPeriod':
                    array_push($sqlObj->from,"student_preferred_period AS SPP");
                    array_push($sqlObj->condition->mustTrue,"TUM.user_id = SPP.user_ref_id");
                    foreach($filterArr as $filterVal){
                        array_push($sqlObj->condition->likelyPeriod,"SPP.period_ref_id = $filterVal");
                    }
                break;

                case 'leftFilterType':
                    if($filterArr=="lastlogin"){
                        $loggedData   =   diHelper::loggedInUserDetails(Yii::app()->user->id);
                        // this simple last login match also working well, i tested it in alertmatch, so replaced this complex one
                        $condition    =   "DUH.added_on >= '$loggedData->last_login'";
                        array_push($sqlObj->condition->mustTrue,$condition);
                    }elseif($filterArr=="notviewed"){
                        array_push($sqlObj->condition->mustTrue,"DUH.status IS NULL");
                    }elseif($filterArr=="hmatching"){
                    //array_push($sqlObj->condition->order,"DUH.status DESC");
                    }elseif($filterArr=="first_name_asc"){
                        array_push($sqlObj->order,"TUM.first_name ASC");
                    }elseif($filterArr=="first_name_desc"){
                        array_push($sqlObj->order,"TUM.first_name DESC");
                    }
                break;

               case 'diUser':
                    if($filterArr!=""){
                        array_push($sqlObj->condition->mustTrue,"DUH.di_user_ref_id = $filterArr");
                    }
                break;

                case 'sortingType':
                    if($filterArr=="first_name_asc"){
                        array_push($sqlObj->order,"first_name ASC");
                    }elseif($filterArr=="first_name_desc"){
                        array_push($sqlObj->order,"first_name DESC");
                    }
                    break;

            }// switch


        }// foreach

        if($searchArr[leftFilterType] == 'mightapply'){
            $counselorShortlistBoughtProfiles = "SELECT DISTINCT 0,0,DUCS.di_user_ref_id, DUCS.status, TUM.user_id, TUM.first_name, TUM.last_name,'counselor_shortlist' AS shortlist_type, DUCS.di_user_counsellor_shortlist_id AS shortlist_id
FROM `di_user_counsellor_shortlist` DUCS , tbl_user_master AS TUM
WHERE DUCS.`user_ref_id` = TUM.user_id
AND DUCS.status IN ('Buy','Refund')
AND DUCS.di_user_ref_id = '".$searchArr['diUser']."'";
            array_push($sqlObj->unionAll, $counselorShortlistBoughtProfiles);

            $criteriaShortlistBoughtProfiles = "SELECT DISTINCT 0,0,DUCS.di_user_ref_id, DUCS.status, TUM.user_id, TUM.first_name, TUM.last_name,'counselor_suggested' AS shortlist_type, DUCS.di_user_criteria_shortlist_id AS shortlist_id
FROM `di_user_criteria_shortlist` DUCS , tbl_user_master AS TUM
WHERE DUCS.`user_ref_id` = TUM.user_id
AND DUCS.status IN ('Buy','Refund')
AND DUCS.di_user_ref_id = '".$searchArr['diUser']."'";
            array_push($sqlObj->unionAll, $criteriaShortlistBoughtProfiles);
        }

        if(empty($sqlObj->order)){
			array_push($sqlObj->order,"first_name ASC");
        }

        return $sqlObj;
    }
	


	//$result 0= admission change 1 = Scholarship Amount
	public static function shortlistOfferDetail($userId = 0, $diUserId = 0, $studentStatus = ''){
		$criteria				=	new CDbCriteria();
		$criteria->condition	=	"di_user_ref_id=:x AND user_ref_id=:y";
        $criteria->params		=	array(':x' => $diUserId,':y' => $userId,);
        if($studentStatus != ''){//for Hotlead
            $criteria->addCondition("eoi_type=:z", "AND");
            $criteria->params[':z'] = $studentStatus;
        }else{
            $criteria->addCondition("eoi_type=:z", "AND");
            $criteria->params[':z'] = 'Hotlead';
        }
		//$criteria->order		=	'eoi_type ASC, added_on DESC';
        $criteria->limit        =   1;
		$data					=	DiUserEoi::model()->findAll($criteria);
		return $data;
	}
		
    /*
     *  addUserEoi function insert data into di_user_eoi table
     *
     */

    public static function updateUserEoi($array    =   array()){

        $model      =   DiUserEoi::model()->findByPk($array['di_user_eoi_id']);
        $logModel   =   new DiUserEoiLog();

        $model->di_user_ref_id          =   $array['di_user_ref_id'];
        $model->user_ref_id             =   $array['user_ref_id'];
        $model->main_department_ref_id  =   $array['main_department_ref_id'];
        $model->intake                  =   $array['intake'];
        $model->admission_chance        =   $array['admission_chance'];
        $model->umail_message_ref_id    =   $array['umail_message_ref_id'];
        $model->user_acceptance_status  =   $array['user_acceptance_status'];
        $model->user_viewed_on          =   $array['user_viewed_on'];
        $model->eoi_status              =   $array['eoi_status'];
        $model->eoi_type                =   $array['eoi_type'];
        $model->added_on                =   new CDbExpression('NOW()');
        $model->added_by                =   $array['added_by'];

        if($model->save()){
            $logModel->di_user_ref_id           =   $array['di_user_ref_id'];
            $logModel->user_ref_id              =   $array['user_ref_id'];
            $logModel->main_department_ref_id   =   $array['main_department_ref_id'];
            $logModel->intake                   =   $array['intake'];
            $logModel->admission_chance         =   $array['admission_chance'];
            $logModel->umail_message_ref_id     =   $array['umail_message_ref_id'];
            $logModel->user_acceptance_status   =   $array['user_acceptance_status'];
            $logModel->user_viewed_on           =   $array['user_viewed_on'];
            $logModel->eoi_status               =   $array['eoi_status'];
            $logModel->added_on                 =   new CDbExpression('NOW()');
            $logModel->added_by                 =   $array['added_by'];

            if($logModel->save()):
                return $model->di_user_eoi_id;
            else:
                return false;
                print_r($logModel->getErrors());
            endif;
        }else{
            return false;
            print_r($model->getErrors());
		}
    }


    /*
     *  addUserScholarship function add scholarship data
     *
     */

    public static function updateUserScholarship($array    =   array()){

        $model      =   DiUserEoiScholarship::model()->findByPk($array['di_user_eoi_scholarship_id']);
        $logModel   =   new DiUserEoiScholarshipLog();

        $model->di_user_eoi_ref_id      =   $array['di_user_eoi_ref_id'];
        $model->scholarship_ref_id      =   $array['scholarship_ref_id'];
        $model->scholarship_chance      =   $array['scholarship_chance'];
        $model->scholarship_description =   $array['scholarship_description'];
        $model->scholarship_name        =   $array['scholarship_name'];
        $model->amount                  =   $array['amount'];
        $model->added_on                =   new CDbExpression('NOW()');
        $model->added_by                =   $array['added_by'];

        if($model->save()){

            $logModel->di_user_eoi_ref_id       =   $array['di_user_eoi_ref_id'];
            $logModel->scholarship_ref_id       =   $array['scholarship_ref_id'];
            $logModel->scholarship_chance       =   $array['scholarship_chance'];
            $logModel->scholarship_description  =   $array['scholarship_description'];
            $logModel->scholarship_name         =   $array['scholarship_name'];
            $logModel->amount                   =   $array['amount'];
            $logModel->added_on                 =   new CDbExpression('NOW()');
            $logModel->added_by                 =   $array['added_by'];

            if($logModel->save()):
                return $model->di_user_eoi_scholarship_id;
            else:
                return false;
                echo "<pre>";
                print_R($logModel->getErrors());
            endif;
        }else{
            return false;
            echo "<pre>";
            print_R($model->getErrors());
        }
    }
	
	//$result 0= admission change 1 = Scholarship Amount
	public static function getEoiDetail($id){
		$data					=	DiUserEoi::model()->findByPk($id);
		return $data;
	}	
	


    /*public static function getRefundAmount($user_id = 0){
        $model  =   new DiCashDebit();
        $model->find('user_ref_id=:x AND ')
    }*/

    public static function getLookUpProductId($product_name = ''){
        $data   =   LookupProduct::model()->find("product_shortcode=:x AND user_type_ref_id=:y",array(':x'=>$product_name,':y'=>3));
        if($data===null):
            return false;
        else:
            return $data->product_id;
        endif;
	}


    public static function getDiProductId($lookupProductId = 0, $di_id = 0){
        $data   =   DiProduct::model()->find("product_ref_id=:x AND di_ref_id=:y",array(':x'=>$lookupProductId,':y'=>$di_id));
        if($data===null):
            return false;
        else:
            return $data->di_product_id;
        endif;
    }

    public static function getDiUsedCashDebitAmount($di_id = 0, $di_product_id = 0, $user_id = 0){
        $data   =   DiCashDebit::model()->find('di_ref_id=:x AND di_product_ref_id=:y AND user_ref_id=:z',
                        array(':x'=>$di_id,':y'=>$di_product_id,':z'=>$user_id)
                    );
        if($data===null){
            return false;
        }else{
            return $data;
        }
    }

    public static function diHotLeadStatusToIgnore($diUserHotLeadId   =   '0'){
        $model  =   new DiUserHotlead();
        $update =   $model->updateByPk($diUserHotLeadId, array('status'=>'Ignore'));
        return $update;
    }

    public static function diCriteriaShortlistStatusToIgnore($diUserCriteriaShortlistId   =   '0'){
        $model  =   new DiUserCriteriaShortlist();
        $update =   $model->updateByPk($diUserCriteriaShortlistId, array('status'=>'Ignore'));
        return $update;
    }
	
	public static function getDIUserHotLeadIdDetails($HotleadUserID = '0'){
        $HotLeadData    =   DiUserHotlead::model()->findByPk($HotleadUserID);
        return $HotLeadData;
     }

    public static function  createPageTitle($page_title = ""){
        $data       =    self::GetDiDetails(Yii::app()->user->di_id);
        return $data->uniRef->uni_name ." - ".$page_title;
    }
	
	public static function getBoardEquivalent($board_id	=	0){
        $model  =   new LookupBoard();
        $boards =   $model->findByPk($board_id);
        if($boards->lookupBoardEquivalents){
			if(is_array($boards->lookupBoardEquivalents)){
				return $boards->lookupBoardEquivalents[0];
			}else{
				return $boards->lookupBoardEquivalents;
			}
		}else{
			return false;
		}
    }
	
	public static function showBoardEquivalentFields($board_id = 0, $min='', $max='', $criteriaId = 0){

		$data	=	DiHelper::getBoardEquivalent($board_id);
		switch($data->overall_type){
		case 'Marks' :
		$output	=	'
				<div class="st-right-only">
					<div class="st-right">
						<div class="st-right-filedname">Min '.$data->overall_type.'</div>
						<div class="st-right-field">
							<div class="row select-form">
								'.CHtml::textField("DiUserCriteria[min_marks]",$min).'
							</div>
						</div>
					</div>
				</div>
				
				<div class="st-right-only">
					<div class="st-right">
						<div class="st-right-filedname">Max '.$data->overall_type.'</div>
						<div class="st-right-field">
							<div class="row select-form">
								'.CHtml::textField("DiUserCriteria[max_marks]",$max).'
							</div>
						</div> 
						<span style="display:none;" rel="Marks" id="educationOverallType"></span>						
					</div>
				</div>';
		break;
		
		case 'Grades' :
            $gradesModel = DiUserCriteriaGrade::model()->findAll(array("condition" => "di_user_criteria_ref_id = ".$criteriaId));
            $i=0;
            $linkTYpe = '';
            $output	= '';
            foreach($gradesModel as $gradeDetails){
                if($i > 0){
                    $linkTYpe = 'remove';
                }
                $output	.= self::displayCriteriaGrades($linkTYpe, $gradeDetails->grade_ref_id, $gradeDetails->min_grade_count);
                $i++;
            }
            if($i==0){
                $output	= self::displayCriteriaGrades($linkTYpe, $gradeDetails->grade_ref_id, $gradeDetails->min_grade_count);
            }

            /**/
		/*$output	=	$criteriaId.'
				<div class="st-right-only">
					<div class="st-right">
						<div class="st-right-filedname">Min '.$data->overall_type.'</div>
						<div class="st-right-field">
							<div class="row select-form">
								'.CHtml::textField("DiUserCriteria[min_marks]",$min).'
							</div>
						</div>   
					</div>
				</div>
				
				<div class="st-right-only">
					<div class="st-right">
						<div class="st-right-filedname">Max '.$data->overall_type.'</div>
						<div class="st-right-field">
							<div class="row select-form">
								'.CHtml::textField("DiUserCriteria[max_marks]",$max).'
							</div>
						</div>   
					</div>
				</div>';*/
		break;
		case 'Points' :
			$array	=	array_combine(range(11,45), range(11,45));
				$output	='<div class="st-right-only">
					<div class="st-right">
						<div class="st-right-filedname">Min '.$data->overall_type.'</div>
						<div class="st-right-field">
							<div class="row select-form">
								'.CHtml::dropDownList('DiUserCriteria[min_marks]',$min,$array).'
							</div>
						</div>   
					</div>
				</div>
				
				<div class="st-right-only">
					<div class="st-right">
						<div class="st-right-filedname">Max '.$data->overall_type.'</div>
						<div class="st-right-field">
							<div class="row select-form">
								'.CHtml::dropDownList('DiUserCriteria[max_marks]',$max,$array).'
							</div>
						</div>   
					</div>
					<span style="display:none;" rel="Points" id="educationOverallType"></span>						

				</div>';
			break;
			default :
			break;
		
		}
		return $output;
	}
	
	public function dashboardAlertMatchTab($criteria_id=0){
		$criteria       =   new CDbCriteria();
		$loggedData     =   diHelper::loggedInUserDetails(Yii::app()->user->id);
		$criteria->condition = 'status Is Null';
		$criteria->with = array("diUserCriteriaRef"=>array("condition"=>"is_active=1"));
		//$criteria->addCondition('di_user_criteria_Ref_id ="'.$criteria_id.'"');
		/* $counts = DiUserCriteriaMatch::model()->count($criteria); */
		//$counts = DiUserCriteriaMatch::model()->findAll($criteria);
		//CVarDumper::dump($counts,10,true);
	}

    public function displayCriteriaGrades($linkType='', $gradeRefId='', $gradeMinCount=''){
        if($linkType == 'remove'){
            $link = "<a href='#' class='remove st-right-add'>- Remove</a></div";
        }else{
            $link = "&nbsp;" . CHtml::link(' + add more','#',array('class'=>'boardAddMore','title'=>'board'));
        }
        $gradesDropDown = CHtml::dropDownList("DiUserCriteria[grade_ref_id][]", $gradeRefId, LookupGrade::getGradesList(), array('empty'=> 'Select a grade', 'style' => 'width:128px;'));
        $gradeMarks     = CHtml::dropDownList("DiUserCriteria[min_grade][]", $gradeMinCount, array_combine(range(1,7), range(1,7)), array('empty'=> 'Min subjects', 'style' => 'width:128px;'));
        $output	=	'
				<div class="education_grades">
                    <div class="st-right-only">
                        <div class="st-right">
                            <div class="st-right-filedname">Grades</div>
                            <div class="st-right-field">
                                <div class="row select-form">
                                    '.$gradesDropDown.'&nbsp;'.$gradeMarks.'
                                </div>
                            </div>
                            ' . $link . '
                        </div>
                    </div>
				</div>
				<span id="educationOverallType" rel="Grades" style="display:none;"></span>';
        return $output;
    }
}
?>