<?php

class  ScholarshipsController extends Controller {
    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";
    }

    public function actionIndex() 	{
        $params = array();
        $_SESSION['scholarship'] = (!$_SESSION['scholarship'] || ($_SESSION['scholarship'] == 1)) ? 1 : 2;

        if (Yii::app()->session->itemAt('sUserUnivariety') == '') {
            $this->redirect('/app/student/createProfile');
        }
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        $selected_country = $selected_dept = '';
        $prefCountries = $user->getPreferredCountries();
        $prefCourses = $user->getPreferredCourses();

        if ($_POST) {
            $selected_country = $_POST['country'];
            $selected_dept = $_POST['dept'];
            $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
            if ($_POST['marks'] == 'marks') {
                if ($edu_det->student_education_id) {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
                    StudentGradeCount::model()->deleteAll($criteria);

                    $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
                } else {
                    $edu_obj = new StudentEducation();
                    $edu_obj->user_ref_id = $userId;
                    $edu_obj->class_level = 12;
                    $edu_obj->added_on = date('Y-m-d H:i:s');
                }
                $edu_obj->board_ref_id = $_POST['board'];

                switch($_POST['overall_type']) {
                    case 'grades':
                        $edu_obj->overall_marks = NULL;
                        break;
                    case 'marks':
                        $edu_obj->overall_marks = $_POST['overall_marks'];
                        break;
                    case 'points':
                        $edu_obj->overall_marks = $_POST['overall_points'];
                        break;
                    case 'marks-gpa':
                        $edu_obj->overall_marks = $_POST['overall_marks'];
                        break;
                }
                $edu_obj->save(false);

                if ($_POST['overall_type'] == 'grades') {
                    $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
                    if ($edu_det_new->student_education_id) {
                        if ($_POST['overall_aa']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 1;$grade_model->grade_count = $_POST['overall_aa'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                        if ($_POST['overall_a']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 2;$grade_model->grade_count = $_POST['overall_a'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_b']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 3;$grade_model->grade_count = $_POST['overall_b'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_c']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 4;$grade_model->grade_count = $_POST['overall_c'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_d']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 5;$grade_model->grade_count = $_POST['overall_d'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                    }
                }
                $criticalFields['board'] = 1;
                $criticalFields['overall_marks'] = 1;
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);
            }
        } else {
            foreach($prefCountries as $id=>$country) {
                $selected_country = $id;break;
            }

            foreach($prefCourses as $id=>$dept) {
                $selected_dept = $dept['main_dept_ref_id'];break;
            }
        }
        $selected_dept_det = LookupDepartment::model()->findByPk($selected_dept);
        $parent_dept = ($selected_dept_det->parent_dept_id == 0) ? $selected_dept : $selected_dept_det->parent_dept_id;
        $params['sub_dept'] = ($selected_dept_det->parent_dept_id == 0) ? 0 : $selected_dept;

        $citizenships = StudentCitizenship::getStudentCitizenship($userId);
        $citizenship_ids = array();
        foreach ($citizenships as $citizenship) {
            $citizenship_ids[] = $citizenship->citizenship_ref_id;
        }

        $params['main_dept'] = $parent_dept;
        $params['source_institute'] = implode(',', $citizenship_ids);
        $params['country'] = array($selected_country);
        $params['gender'] = ($user->gender == 'M') ? 'Male' : 'Female';
        $params['study_level'] = '5, 6';

        $scholarships = Scholarship::model()->getScholarshipSearchListOutplacement($params, false);
        $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));

        $this->render('index', array('selected_country'=>$selected_country, 'selected_dept'=>$selected_dept, 'scholarships'=>$scholarships, 'edu_det'=>$edu_det, 'prefCountries'=>$prefCountries, 'prefCourses'=>$prefCourses, 'scholarships'=>$scholarships, 'user'=>$user));
	}

    public function actionAddUserScholarship() {
        $scholarshipId  = $_GET['scholarshipId'];
        $userRefId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userRefId);

        UserScholarship::addUserScholarshipList($userRefId,$scholarshipId,$user->login_ref_id);
        $scholarship = Scholarship::model()->findByPk($scholarshipId);

        echo json_encode(array("flag" => true,"uni_name"=>"$scholarship->scholarship_name"));
    }

    public function actionRemoveUserScholarship() {
        $scholarshipId  = $_GET['scholarshipId'];
        $userRefId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userRefId);

        UserScholarship::deleteUserScholarshipList($userRefId,$scholarshipId,$user->login_ref_id);
        $scholarship = Scholarship::model()->findByPk($scholarshipId);

        echo json_encode(array("flag" => true,"uni_name"=>"$scholarship->scholarship_name"));
    }


}