<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorExpertCommunication is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_expert_communication".
 *
 * The followings are the available columns in table 'vendor_expert_communication':
 * @property string $vendor_expert_communication_id
 * @property integer $vendor_contact_ref_id
 * @property string $communication_type
 * @property string $address1
 * @property string $address2
 * @property integer $city_ref_id
 * @property integer $country_ref_id
 * @property string $zipcode
 * @property string $skype_id
 * @property string $google_hangout_id
 *
 * The followings are the available model relations:
 * @property VendorContact $vendorContactRef
 * @property TblCityMaster $cityRef
 * @property TblCountryMaster $countryRef
 */
class BaseVendorExpertCommunication extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorExpertCommunication the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_expert_communication';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_contact_ref_id, city_ref_id, country_ref_id', 'numerical', 'integerOnly'=>true),
			array('communication_type, zipcode', 'length', 'max'=>10),
			array('address1, address2', 'length', 'max'=>100),
			array('skype_id, google_hangout_id', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_expert_communication_id, vendor_contact_ref_id, communication_type, address1, address2, city_ref_id, country_ref_id, zipcode, skype_id, google_hangout_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorContactRef' => array(self::BELONGS_TO, 'VendorContact', 'vendor_contact_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_expert_communication_id' => 'Vendor Expert Communication',
			'vendor_contact_ref_id' => 'Vendor Contact Ref',
			'communication_type' => 'Communication Type',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city_ref_id' => 'City Ref',
			'country_ref_id' => 'Country Ref',
			'zipcode' => 'Zipcode',
			'skype_id' => 'Skype',
			'google_hangout_id' => 'Google Hangout',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_expert_communication_id',$this->vendor_expert_communication_id,true);
		$criteria->compare('vendor_contact_ref_id',$this->vendor_contact_ref_id);
		$criteria->compare('communication_type',$this->communication_type,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('zipcode',$this->zipcode,true);
		$criteria->compare('skype_id',$this->skype_id,true);
		$criteria->compare('google_hangout_id',$this->google_hangout_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}