<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityDeptRanking is autogenerate by UniModel generator
 *
 * This is the model class for table "university_dept_ranking".
 *
 * The followings are the available columns in table 'university_dept_ranking':
 * @property integer $university_dept_ranking_id
 * @property integer $uni_ref_id
 * @property integer $department_ref_id
 * @property integer $college_ref_id
 * @property integer $rank_source_ref_id
 * @property integer $rank
 * @property integer $rank_year
 * @property string $rank_desc
 * @property string $is_twining
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property LookupDepartmentInd $departmentRef
 * @property TblAdmin $modifiedBy
 * @property LookupRankSource $rankSourceRef
 * @property TblUniversityMaster $uniRef
 */
class BaseUniversityDeptRanking extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityDeptRanking the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_dept_ranking';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, department_ref_id, added_on', 'required'),
			array('uni_ref_id, department_ref_id, college_ref_id, rank_source_ref_id, rank, rank_year, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('rank_desc', 'length', 'max'=>255),
			array('is_twining', 'length', 'max'=>1),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_dept_ranking_id, uni_ref_id, department_ref_id, college_ref_id, rank_source_ref_id, rank, rank_year, rank_desc, is_twining, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartmentInd', 'department_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'rankSourceRef' => array(self::BELONGS_TO, 'LookupRankSource', 'rank_source_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_dept_ranking_id' => 'University Dept Ranking',
			'uni_ref_id' => 'Uni Ref',
			'department_ref_id' => 'Department Ref',
			'college_ref_id' => 'College Ref',
			'rank_source_ref_id' => 'Rank Source Ref',
			'rank' => 'Rank',
			'rank_year' => 'Rank Year',
			'rank_desc' => 'Rank Desc',
			'is_twining' => 'Is Twining',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_dept_ranking_id',$this->university_dept_ranking_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('college_ref_id',$this->college_ref_id);
		$criteria->compare('rank_source_ref_id',$this->rank_source_ref_id);
		$criteria->compare('rank',$this->rank);
		$criteria->compare('rank_year',$this->rank_year);
		$criteria->compare('rank_desc',$this->rank_desc,true);
		$criteria->compare('is_twining',$this->is_twining,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}