<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniCoursePlacement is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_course_placement".
 *
 * The followings are the available columns in table 'uni_course_placement':
 * @property string $uni_course_placement_id
 * @property integer $uni_ref_id
 * @property string $uni_course_ref_id
 * @property string $placement_company
 * @property string $placement_specialisation
 * @property string $placement_top_companies
 * @property integer $placement_campus_percent
 * @property integer $avg_salary
 * @property integer $median_salary
 * @property integer $highest_domestic_sal
 * @property integer $highest_international_sal
 * @property string $placement_comments
 * @property string $added_on
 * @property string $modified_on
 */
class BaseUniCoursePlacement extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniCoursePlacement the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_course_placement';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required'),
			array('uni_ref_id, placement_campus_percent, avg_salary, median_salary, highest_domestic_sal, highest_international_sal', 'numerical', 'integerOnly'=>true),
			array('uni_course_ref_id', 'length', 'max'=>11),
			array('placement_specialisation', 'length', 'max'=>255),
			array('placement_company, placement_top_companies, placement_comments, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uni_course_placement_id, uni_ref_id, uni_course_ref_id, placement_company, placement_specialisation, placement_top_companies, placement_campus_percent, avg_salary, median_salary, highest_domestic_sal, highest_international_sal, placement_comments, added_on, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uni_course_placement_id' => 'Uni Course Placement',
			'uni_ref_id' => 'Uni Ref',
			'uni_course_ref_id' => 'Uni Course Ref',
			'placement_company' => 'Placement Company',
			'placement_specialisation' => 'Placement Specialisation',
			'placement_top_companies' => 'Placement Top Companies',
			'placement_campus_percent' => 'Placement Campus Percent',
			'avg_salary' => 'Avg Salary',
			'median_salary' => 'Median Salary',
			'highest_domestic_sal' => 'Highest Domestic Sal',
			'highest_international_sal' => 'Highest International Sal',
			'placement_comments' => 'Placement Comments',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('uni_course_placement_id',$this->uni_course_placement_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id,true);
		$criteria->compare('placement_company',$this->placement_company,true);
		$criteria->compare('placement_specialisation',$this->placement_specialisation,true);
		$criteria->compare('placement_top_companies',$this->placement_top_companies,true);
		$criteria->compare('placement_campus_percent',$this->placement_campus_percent);
		$criteria->compare('avg_salary',$this->avg_salary);
		$criteria->compare('median_salary',$this->median_salary);
		$criteria->compare('highest_domestic_sal',$this->highest_domestic_sal);
		$criteria->compare('highest_international_sal',$this->highest_international_sal);
		$criteria->compare('placement_comments',$this->placement_comments,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}