<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblUniExtension is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_uni_extension".
 *
 * The followings are the available columns in table 'tbl_uni_extension':
 * @property string $tbl_uni_extension_id
 * @property integer $uni_ref_id
 * @property string $location_information
 * @property string $campus_infrastructure
 * @property string $faculty_commentary
 * @property string $others_attendance
 * @property string $others_crowd
 * @property string $others_hangout
 * @property string $facilities
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property TblAdmin $modifiedBy
 * @property TblAdmin $addedBy
 * @property TblUniversityMaster $uniRef
 */
class BaseTblUniExtension extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblUniExtension the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_uni_extension';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, added_on', 'required'),
			array('uni_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('location_information, campus_infrastructure, faculty_commentary, others_attendance, others_crowd, others_hangout, facilities, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_uni_extension_id, uni_ref_id, location_information, campus_infrastructure, faculty_commentary, others_attendance, others_crowd, others_hangout, facilities, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_uni_extension_id' => 'Tbl Uni Extension',
			'uni_ref_id' => 'Uni Ref',
			'location_information' => 'Location Information',
			'campus_infrastructure' => 'Campus Infrastructure',
			'faculty_commentary' => 'Faculty Commentary',
			'others_attendance' => 'Others Attendance',
			'others_crowd' => 'Others Crowd',
			'others_hangout' => 'Others Hangout',
			'facilities' => 'Facilities',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_uni_extension_id',$this->tbl_uni_extension_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('location_information',$this->location_information,true);
		$criteria->compare('campus_infrastructure',$this->campus_infrastructure,true);
		$criteria->compare('faculty_commentary',$this->faculty_commentary,true);
		$criteria->compare('others_attendance',$this->others_attendance,true);
		$criteria->compare('others_crowd',$this->others_crowd,true);
		$criteria->compare('others_hangout',$this->others_hangout,true);
		$criteria->compare('facilities',$this->facilities,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}