<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblEventEmail is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_event_email".
 *
 * The followings are the available columns in table 'tbl_event_email':
 * @property string $tbl_event_email_id
 * @property string $user_ref_id
 * @property string $send_on
 * @property string $opened_on
 *
 * The followings are the available model relations:
 * @property TblEmailEvents[] $tblEmailEvents
 * @property TblUserMaster $userRef
 */
class BaseTblEventEmail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblEventEmail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_event_email';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'length', 'max'=>10),
			array('send_on, opened_on, email_type', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_event_email_id, user_ref_id, send_on, opened_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblEmailEvents' => array(self::HAS_MANY, 'TblEmailEvents', 'tbl_event_email_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_event_email_id' => 'Tbl Event Email',
			'user_ref_id' => 'User Ref',
			'send_on' => 'Send On',
			'opened_on' => 'Opened On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_event_email_id',$this->tbl_event_email_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('send_on',$this->send_on,true);
		$criteria->compare('opened_on',$this->opened_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}