<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblCityMaster is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_city_master".
 *
 * The followings are the available columns in table 'tbl_city_master':
 * @property integer $city_id
 * @property integer $country_id
 * @property integer $state_ref_id
 * @property string $city_name
 * @property integer $citytype_ref_id
 * @property string $is_active
 * @property string $synonym_names
 * @property integer $cluster_ref_id
 *
 * The followings are the available model relations:
 * @property CriteriaLocation[] $criteriaLocations
 * @property CtpInfo[] $ctpInfos
 * @property DiBannerCampaignTargetCity[] $diBannerCampaignTargetCities
 * @property DiEmailCampaignTargetCity[] $diEmailCampaignTargetCities
 * @property Event[] $events
 * @property LookupLocality[] $lookupLocalities
 * @property ProspectPartners[] $prospectPartners
 * @property SeoCity[] $seoCities
 * @property StudentPreferredLocation[] $studentPreferredLocations
 * @property LookupCityCluster $clusterRef
 * @property LookupCityType $citytypeRef
 * @property TblState $stateRef
 * @property TblSiDi[] $tblSiDis
 * @property TblSiDiNewDelete[] $tblSiDiNewDeletes
 * @property TblUniversityMaster[] $tblUniversityMasters
 * @property TblUserMaster[] $tblUserMasters
 * @property VendorCenter[] $vendorCenters
 * @property VendorCentre[] $vendorCentres
 * @property VendorExpertCommunication[] $vendorExpertCommunications
 */
class BaseTblCityMaster extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblCityMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_city_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_id, state_ref_id, citytype_ref_id, cluster_ref_id', 'numerical', 'integerOnly'=>true),
			array('city_name', 'length', 'max'=>50),
			array('is_active', 'length', 'max'=>1),
			array('synonym_names', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('city_id, country_id, state_ref_id, city_name, citytype_ref_id, is_active, synonym_names, cluster_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'criteriaLocations' => array(self::HAS_MANY, 'CriteriaLocation', 'city_ref_id'),
			'ctpInfos' => array(self::HAS_MANY, 'CtpInfo', 'city_ref_id'),
			'diBannerCampaignTargetCities' => array(self::HAS_MANY, 'DiBannerCampaignTargetCity', 'city_ref_id'),
			'diEmailCampaignTargetCities' => array(self::HAS_MANY, 'DiEmailCampaignTargetCity', 'city_ref_id'),
			'events' => array(self::HAS_MANY, 'Event', 'city_ref_id'),
			'lookupLocalities' => array(self::HAS_MANY, 'LookupLocality', 'city_ref_id'),
			'prospectPartners' => array(self::HAS_MANY, 'ProspectPartners', 'city_ref_id'),
			'seoCities' => array(self::HAS_MANY, 'SeoCity', 'city_ref_id'),
			'studentPreferredLocations' => array(self::HAS_MANY, 'StudentPreferredLocation', 'city_ref_id'),
			'clusterRef' => array(self::BELONGS_TO, 'LookupCityCluster', 'cluster_ref_id'),
			'citytypeRef' => array(self::BELONGS_TO, 'LookupCityType', 'citytype_ref_id'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
			'tblSiDis' => array(self::HAS_MANY, 'TblSiDi', 'city_ref_id'),
			'tblSiDiNewDeletes' => array(self::HAS_MANY, 'TblSiDiNewDelete', 'city_ref_id'),
			'tblUniversityMasters' => array(self::HAS_MANY, 'TblUniversityMaster', 'city_ref_id'),
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'city_ref_id'),
			'vendorCenters' => array(self::HAS_MANY, 'VendorCenter', 'city_ref_id'),
			'vendorCentres' => array(self::HAS_MANY, 'VendorCentre', 'city_ref_id'),
			'vendorExpertCommunications' => array(self::HAS_MANY, 'VendorExpertCommunication', 'city_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'city_id' => 'City',
			'country_id' => 'Country',
			'state_ref_id' => 'State Ref',
			'city_name' => 'City Name',
			'citytype_ref_id' => 'Citytype Ref',
			'is_active' => 'Is Active',
			'synonym_names' => 'Synonym Names',
			'cluster_ref_id' => 'Cluster Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('city_id',$this->city_id);
		$criteria->compare('country_id',$this->country_id);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('city_name',$this->city_name,true);
		$criteria->compare('citytype_ref_id',$this->citytype_ref_id);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('synonym_names',$this->synonym_names,true);
		$criteria->compare('cluster_ref_id',$this->cluster_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}