<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblAdmin is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_admin".
 *
 * The followings are the available columns in table 'tbl_admin':
 * @property integer $admin_id
 * @property string $login_ref_id
 * @property integer $si_ref_id
 * @property string $admin_name
 * @property string $admin_email
 * @property string $admin_pwd
 * @property string $admin_full_name
 * @property string $dob
 * @property integer $records_per_page
 * @property string $roles
 * @property integer $role_type_id
 * @property string $admin_details
 * @property string $is_active
 * @property string $added_on
 * @property string $last_modified
 * @property string $new_password
 *
 * The followings are the available model relations:
 * @property CourseAffiliation[] $courseAffiliations
 * @property CourseAffiliation[] $courseAffiliations1
 * @property CourseApplicationDates[] $courseApplicationDates
 * @property CourseApplicationDates[] $courseApplicationDates1
 * @property CourseEligibility[] $courseEligibilities
 * @property CourseEligibility[] $courseEligibilities1
 * @property CourseFees[] $courseFees
 * @property CourseFees[] $courseFees1
 * @property CoursePlacementCompany[] $coursePlacementCompanies
 * @property CoursePlacementTopCompany[] $coursePlacementTopCompanies
 * @property CoursePlacementType[] $coursePlacementTypes
 * @property CourseStartDate[] $courseStartDates
 * @property CourseStartDate[] $courseStartDates1
 * @property CourseTwining[] $courseTwinings
 * @property CourseTwining[] $courseTwinings1
 * @property DiSignup[] $diSignups
 * @property EmailAlias[] $emailAliases
 * @property EmailAlias[] $emailAliases1
 * @property HostelInfo[] $hostelInfos
 * @property HostelInfo[] $hostelInfos1
 * @property LoginMaster[] $loginMasters
 * @property LoginMaster[] $loginMasters1
 * @property MdmCourseDump[] $mdmCourseDumps
 * @property MdmCourseDump[] $mdmCourseDumps1
 * @property MdmCourseLog[] $mdmCourseLogs
 * @property MdmCourseLog[] $mdmCourseLogs1
 * @property MdmNewCourseLog[] $mdmNewCourseLogs
 * @property MdmNewCourseLog[] $mdmNewCourseLogs1
 * @property MdmNewCourseLog[] $mdmNewCourseLogs2
 * @property Prospect[] $prospects
 * @property Prospect[] $prospects1
 * @property Prospect[] $prospects2
 * @property Prospect[] $prospects3
 * @property ProspectInteraction[] $prospectInteractions
 * @property ProspectInteraction[] $prospectInteractions1
 * @property Scholarship[] $scholarships
 * @property Scholarship[] $scholarships1
 * @property ScholarshipCountry[] $scholarshipCountries
 * @property ScholarshipCountry[] $scholarshipCountries1
 * @property ScholarshipDepartment[] $scholarshipDepartments
 * @property ScholarshipDepartment[] $scholarshipDepartments1
 * @property ScholarshipEligibilityClass[] $scholarshipEligibilityClasses
 * @property ScholarshipEligibilityClass[] $scholarshipEligibilityClasses1
 * @property ScholarshipEligibilityEntrance[] $scholarshipEligibilityEntrances
 * @property ScholarshipEligibilityEntrance[] $scholarshipEligibilityEntrances1
 * @property ScholarshipHostInstitute[] $scholarshipHostInstitutes
 * @property ScholarshipHostInstitute[] $scholarshipHostInstitutes1
 * @property ScholarshipStudyLevel[] $scholarshipStudyLevels
 * @property ScholarshipStudyLevel[] $scholarshipStudyLevels1
 * @property ScholarshipTarget[] $scholarshipTargets
 * @property ScholarshipTarget[] $scholarshipTargets1
 * @property SessionAdvisorDeptCountry[] $sessionAdvisorDeptCountries
 * @property SessionTimeslot[] $sessionTimeslots
 * @property SessionTimeslot[] $sessionTimeslots1
 * @property SiAdvisor[] $siAdvisors
 * @property StudentAssignedAdvisor[] $studentAssignedAdvisors
 * @property StudentAssignedAdvisor[] $studentAssignedAdvisors1
 * @property StudentUpgradeLog[] $studentUpgradeLogs
 * @property StudentWorkplan[] $studentWorkplans
 * @property StudentWorkplanAdditionalActivity[] $studentWorkplanAdditionalActivities
 * @property StudentWorkplanNotes[] $studentWorkplanNotes
 * @property StudentWorkplanNotes[] $studentWorkplanNotes1
 * @property Task[] $tasks
 * @property Task[] $tasks1
 * @property Task[] $tasks2
 * @property Task[] $tasks3
 * @property TaskComments[] $taskComments
 * @property TaskLog[] $taskLogs
 * @property TaskLog[] $taskLogs1
 * @property LoginMaster $loginRef
 * @property TblAdminRole $roleType
 * @property TblSiDi $siRef
 * @property TblAdminModuleAccess[] $tblAdminModuleAccesses
 * @property TblUniExtension[] $tblUniExtensions
 * @property TblUniExtension[] $tblUniExtensions1
 * @property UmailAttachmentLog[] $umailAttachmentLogs
 * @property UmailExtensionLog[] $umailExtensionLogs
 * @property UmailHelpLog[] $umailHelpLogs
 * @property UmailLog[] $umailLogs
 * @property UmailMessage[] $umailMessages
 * @property UmailMessageComment[] $umailMessageComments
 * @property UmailReviewMessageLog[] $umailReviewMessageLogs
 * @property UniCourseContact[] $uniCourseContacts
 * @property UniCourseReservation[] $uniCourseReservations
 * @property UniCourseReservation[] $uniCourseReservations1
 * @property UniCourseTest[] $uniCourseTests
 * @property UniCourseTest[] $uniCourseTests1
 * @property UniveristyContact[] $univeristyContacts
 * @property UniveristyContact[] $univeristyContacts1
 * @property UniveristyFinancials[] $univeristyFinancials
 * @property UniveristyFinancials[] $univeristyFinancials1
 * @property UniversityAdmissionDates[] $universityAdmissionDates
 * @property UniversityAdmissionDates[] $universityAdmissionDates1
 * @property UniversityDeptRanking[] $universityDeptRankings
 * @property UniversityDeptRanking[] $universityDeptRankings1
 * @property UniversitySocialMedia[] $universitySocialMedias
 * @property UniversitySocialMedia[] $universitySocialMedias1
 * @property UserDataPoint[] $userDataPoints
 * @property WorkshopDelete[] $workshopDeletes
 * @property WorkshopGroupDelete[] $workshopGroupDeletes
 * @property WorkshopGroupDelete[] $workshopGroupDeletes1
 * @property WorkshopSiGroup[] $workshopSiGroups
 * @property WorkshopSiGroup[] $workshopSiGroups1
 */
class BaseTblAdmin extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblAdmin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_admin';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login_ref_id', 'required'),
			array('si_ref_id, records_per_page, role_type_id', 'numerical', 'integerOnly'=>true),
			array('login_ref_id', 'length', 'max'=>10),
			array('admin_name', 'length', 'max'=>20),
			array('admin_email, admin_pwd, admin_full_name', 'length', 'max'=>255),
			array('roles', 'length', 'max'=>2),
			array('is_active, new_password', 'length', 'max'=>1),
			array('added_on', 'length', 'max'=>50),
			array('dob, admin_details, last_modified', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('admin_id, login_ref_id, si_ref_id, admin_name, admin_email, admin_pwd, admin_full_name, dob, records_per_page, roles, role_type_id, admin_details, is_active, added_on, last_modified, new_password', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseAffiliations' => array(self::HAS_MANY, 'CourseAffiliation', 'added_by'),
			'courseAffiliations1' => array(self::HAS_MANY, 'CourseAffiliation', 'modified_by'),
			'courseApplicationDates' => array(self::HAS_MANY, 'CourseApplicationDates', 'added_by'),
			'courseApplicationDates1' => array(self::HAS_MANY, 'CourseApplicationDates', 'modified_by'),
			'courseEligibilities' => array(self::HAS_MANY, 'CourseEligibility', 'added_by'),
			'courseEligibilities1' => array(self::HAS_MANY, 'CourseEligibility', 'modified_by'),
			'courseFees' => array(self::HAS_MANY, 'CourseFees', 'added_by'),
			'courseFees1' => array(self::HAS_MANY, 'CourseFees', 'modified_by'),
			'coursePlacementCompanies' => array(self::HAS_MANY, 'CoursePlacementCompany', 'modified_by'),
			'coursePlacementTopCompanies' => array(self::HAS_MANY, 'CoursePlacementTopCompany', 'modified_by'),
			'coursePlacementTypes' => array(self::HAS_MANY, 'CoursePlacementType', 'modified_by'),
			'courseStartDates' => array(self::HAS_MANY, 'CourseStartDate', 'added_by'),
			'courseStartDates1' => array(self::HAS_MANY, 'CourseStartDate', 'modified_by'),
			'courseTwinings' => array(self::HAS_MANY, 'CourseTwining', 'added_by'),
			'courseTwinings1' => array(self::HAS_MANY, 'CourseTwining', 'modified_by'),
			'diSignups' => array(self::HAS_MANY, 'DiSignup', 'added_by'),
			'emailAliases' => array(self::HAS_MANY, 'EmailAlias', 'added_by'),
			'emailAliases1' => array(self::HAS_MANY, 'EmailAlias', 'modified_by'),
			'hostelInfos' => array(self::HAS_MANY, 'HostelInfo', 'added_by'),
			'hostelInfos1' => array(self::HAS_MANY, 'HostelInfo', 'modified_by'),
			'loginMasters' => array(self::HAS_MANY, 'LoginMaster', 'added_by'),
			'loginMasters1' => array(self::HAS_MANY, 'LoginMaster', 'modified_by'),
			'mdmCourseDumps' => array(self::HAS_MANY, 'MdmCourseDump', 'added_by'),
			'mdmCourseDumps1' => array(self::HAS_MANY, 'MdmCourseDump', 'modified_by'),
			'mdmCourseLogs' => array(self::HAS_MANY, 'MdmCourseLog', 'approved_by'),
			'mdmCourseLogs1' => array(self::HAS_MANY, 'MdmCourseLog', 'request_by_id'),
			'mdmNewCourseLogs' => array(self::HAS_MANY, 'MdmNewCourseLog', 'approved_by'),
			'mdmNewCourseLogs1' => array(self::HAS_MANY, 'MdmNewCourseLog', 'modified_by'),
			'mdmNewCourseLogs2' => array(self::HAS_MANY, 'MdmNewCourseLog', 'request_by_id'),
			'prospects' => array(self::HAS_MANY, 'Prospect', 'added_by'),
			'prospects1' => array(self::HAS_MANY, 'Prospect', 'advisor_ref_id'),
			'prospects2' => array(self::HAS_MANY, 'Prospect', 'modified_by'),
			'prospects3' => array(self::HAS_MANY, 'Prospect', 'reassigned_from'),
			'prospectInteractions' => array(self::HAS_MANY, 'ProspectInteraction', 'advisor_ref_id'),
			'prospectInteractions1' => array(self::HAS_MANY, 'ProspectInteraction', 'assisted_by'),
			'scholarships' => array(self::HAS_MANY, 'Scholarship', 'added_by'),
			'scholarships1' => array(self::HAS_MANY, 'Scholarship', 'modified_by'),
			'scholarshipCountries' => array(self::HAS_MANY, 'ScholarshipCountry', 'added_by'),
			'scholarshipCountries1' => array(self::HAS_MANY, 'ScholarshipCountry', 'modified_by'),
			'scholarshipDepartments' => array(self::HAS_MANY, 'ScholarshipDepartment', 'added_by'),
			'scholarshipDepartments1' => array(self::HAS_MANY, 'ScholarshipDepartment', 'modified_by'),
			'scholarshipEligibilityClasses' => array(self::HAS_MANY, 'ScholarshipEligibilityClass', 'added_by'),
			'scholarshipEligibilityClasses1' => array(self::HAS_MANY, 'ScholarshipEligibilityClass', 'modified_by'),
			'scholarshipEligibilityEntrances' => array(self::HAS_MANY, 'ScholarshipEligibilityEntrance', 'added_by'),
			'scholarshipEligibilityEntrances1' => array(self::HAS_MANY, 'ScholarshipEligibilityEntrance', 'modified_by'),
			'scholarshipHostInstitutes' => array(self::HAS_MANY, 'ScholarshipHostInstitute', 'added_by'),
			'scholarshipHostInstitutes1' => array(self::HAS_MANY, 'ScholarshipHostInstitute', 'modified_by'),
			'scholarshipStudyLevels' => array(self::HAS_MANY, 'ScholarshipStudyLevel', 'added_by'),
			'scholarshipStudyLevels1' => array(self::HAS_MANY, 'ScholarshipStudyLevel', 'modified_by'),
			'scholarshipTargets' => array(self::HAS_MANY, 'ScholarshipTarget', 'added_by'),
			'scholarshipTargets1' => array(self::HAS_MANY, 'ScholarshipTarget', 'modified_by'),
			'sessionAdvisorDeptCountries' => array(self::HAS_MANY, 'SessionAdvisorDeptCountry', 'advisor_ref_id'),
			'sessionTimeslots' => array(self::HAS_MANY, 'SessionTimeslot', 'advisor_ref_id'),
			'sessionTimeslots1' => array(self::HAS_MANY, 'SessionTimeslot', 'reassigned_by'),
			'siAdvisors' => array(self::HAS_MANY, 'SiAdvisor', 'advisor_id'),
			'studentAssignedAdvisors' => array(self::HAS_MANY, 'StudentAssignedAdvisor', 'primary_advisor_ref_id'),
			'studentAssignedAdvisors1' => array(self::HAS_MANY, 'StudentAssignedAdvisor', 'secondary_advisor_ref_id'),
			'studentUpgradeLogs' => array(self::HAS_MANY, 'StudentUpgradeLog', 'added_by'),
			'studentWorkplans' => array(self::HAS_MANY, 'StudentWorkplan', 'modified_by'),
			'studentWorkplanAdditionalActivities' => array(self::HAS_MANY, 'StudentWorkplanAdditionalActivity', 'added_by'),
			'studentWorkplanNotes' => array(self::HAS_MANY, 'StudentWorkplanNotes', 'added_by'),
			'studentWorkplanNotes1' => array(self::HAS_MANY, 'StudentWorkplanNotes', 'modified_by'),
			'tasks' => array(self::HAS_MANY, 'Task', 'modified_by'),
			'tasks1' => array(self::HAS_MANY, 'Task', 'assigned_to'),
			'tasks2' => array(self::HAS_MANY, 'Task', 'creator'),
			'tasks3' => array(self::HAS_MANY, 'Task', 'reassigned_to'),
			'taskComments' => array(self::HAS_MANY, 'TaskComments', 'added_by'),
			'taskLogs' => array(self::HAS_MANY, 'TaskLog', 'assigned_to'),
			'taskLogs1' => array(self::HAS_MANY, 'TaskLog', 'reassigned_to'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'roleType' => array(self::BELONGS_TO, 'TblAdminRole', 'role_type_id'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
			'tblAdminModuleAccesses' => array(self::HAS_MANY, 'TblAdminModuleAccess', 'admin_ref_id'),
			'tblUniExtensions' => array(self::HAS_MANY, 'TblUniExtension', 'modified_by'),
			'tblUniExtensions1' => array(self::HAS_MANY, 'TblUniExtension', 'added_by'),
			'umailAttachmentLogs' => array(self::HAS_MANY, 'UmailAttachmentLog', 'added_by'),
			'umailExtensionLogs' => array(self::HAS_MANY, 'UmailExtensionLog', 'extension_by'),
			'umailHelpLogs' => array(self::HAS_MANY, 'UmailHelpLog', 'advisor_ref_id'),
			'umailLogs' => array(self::HAS_MANY, 'UmailLog', 'added_by'),
			'umailMessages' => array(self::HAS_MANY, 'UmailMessage', 'modified_by'),
			'umailMessageComments' => array(self::HAS_MANY, 'UmailMessageComment', 'added_by'),
			'umailReviewMessageLogs' => array(self::HAS_MANY, 'UmailReviewMessageLog', 'added_by'),
			'uniCourseContacts' => array(self::HAS_MANY, 'UniCourseContact', 'added_by'),
			'uniCourseReservations' => array(self::HAS_MANY, 'UniCourseReservation', 'added_by'),
			'uniCourseReservations1' => array(self::HAS_MANY, 'UniCourseReservation', 'modified_by'),
			'uniCourseTests' => array(self::HAS_MANY, 'UniCourseTest', 'added_by'),
			'uniCourseTests1' => array(self::HAS_MANY, 'UniCourseTest', 'modified_by'),
			'univeristyContacts' => array(self::HAS_MANY, 'UniveristyContact', 'added_by'),
			'univeristyContacts1' => array(self::HAS_MANY, 'UniveristyContact', 'modified_by'),
			'univeristyFinancials' => array(self::HAS_MANY, 'UniveristyFinancials', 'added_by'),
			'univeristyFinancials1' => array(self::HAS_MANY, 'UniveristyFinancials', 'modified_by'),
			'universityAdmissionDates' => array(self::HAS_MANY, 'UniversityAdmissionDates', 'added_by'),
			'universityAdmissionDates1' => array(self::HAS_MANY, 'UniversityAdmissionDates', 'modified_by'),
			'universityDeptRankings' => array(self::HAS_MANY, 'UniversityDeptRanking', 'added_by'),
			'universityDeptRankings1' => array(self::HAS_MANY, 'UniversityDeptRanking', 'modified_by'),
			'universitySocialMedias' => array(self::HAS_MANY, 'UniversitySocialMedia', 'modified_by'),
			'universitySocialMedias1' => array(self::HAS_MANY, 'UniversitySocialMedia', 'added_by'),
			'userDataPoints' => array(self::HAS_MANY, 'UserDataPoint', 'added_by'),
			'workshopDeletes' => array(self::HAS_MANY, 'WorkshopDelete', 'created_by_advisor'),
			'workshopGroupDeletes' => array(self::HAS_MANY, 'WorkshopGroupDelete', 'assigned_to_advisor'),
			'workshopGroupDeletes1' => array(self::HAS_MANY, 'WorkshopGroupDelete', 'created_by_advisor'),
			'workshopSiGroups' => array(self::HAS_MANY, 'WorkshopSiGroup', 'advisor_ref_id'),
			'workshopSiGroups1' => array(self::HAS_MANY, 'WorkshopSiGroup', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'admin_id' => 'Admin',
			'login_ref_id' => 'Login Ref',
			'si_ref_id' => 'Si Ref',
			'admin_name' => 'Admin Name',
			'admin_email' => 'Admin Email',
			'admin_pwd' => 'Admin Pwd',
			'admin_full_name' => 'Admin Full Name',
			'dob' => 'Dob',
			'records_per_page' => 'Records Per Page',
			'roles' => 'Roles',
			'role_type_id' => 'Role Type',
			'admin_details' => 'Admin Details',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'last_modified' => 'Last Modified',
			'new_password' => 'New Password',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('admin_id',$this->admin_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('admin_name',$this->admin_name,true);
		$criteria->compare('admin_email',$this->admin_email,true);
		$criteria->compare('admin_pwd',$this->admin_pwd,true);
		$criteria->compare('admin_full_name',$this->admin_full_name,true);
		$criteria->compare('dob',$this->dob,true);
		$criteria->compare('records_per_page',$this->records_per_page);
		$criteria->compare('roles',$this->roles,true);
		$criteria->compare('role_type_id',$this->role_type_id);
		$criteria->compare('admin_details',$this->admin_details,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('last_modified',$this->last_modified,true);
		$criteria->compare('new_password',$this->new_password,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}