<?php

/**
/*
 * @author  
 * @package application.models 
 * 
 * BaseStudentPreferredSubject is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_subject".
 *
 * The followings are the available columns in table 'student_preferred_subject':
 * @property string $student_preferred_subject_id
 * @property string $user_ref_id
 * @property integer $student_subject_ref_id
 * @property string $type
 * @property integer $not_sure
 * @property integer $preference
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupStudentSubject $studentSubjectRef
 */
class BaseStudentPreferredSubject extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredSubject the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_subject';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id','required'),
			array('student_subject_ref_id, not_sure, preference', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('type', 'length', 'max'=>7),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_preferred_subject_id, user_ref_id, student_subject_ref_id, type, not_sure, preference', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'studentSubjectRef' => array(self::BELONGS_TO, 'LookupStudentSubject', 'student_subject_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_preferred_subject_id' => 'Student Preferred Subject',
			'user_ref_id' => 'User Ref',
			'student_subject_ref_id' => 'Student Subject Ref',
			'type' => 'Type',
			'not_sure' => 'Not Sure',
			'preference' => 'Preference',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_preferred_subject_id',$this->student_preferred_subject_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('student_subject_ref_id',$this->student_subject_ref_id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('not_sure',$this->not_sure);
		$criteria->compare('preference',$this->preference);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}