<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentPreferredCareer is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_career".
 *
 * The followings are the available columns in table 'student_preferred_career':
 * @property string $student_preferred_career_id
 * @property string $user_ref_id
 * @property string $career_ref_id
 * @property integer $preference
 * @property integer $not_sure
 * @property string $added_on
 * @property string $parent_choice
 *
 * The followings are the available model relations:
 * @property LookupCareer $careerRef
 * @property TblUserMaster $userRef
 */
class BaseStudentPreferredCareer extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredCareer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_career';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('preference, not_sure', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, career_ref_id', 'length', 'max'=>10),
			array('parent_choice', 'length', 'max'=>1),
            array('career_name', 'length', 'max'=>50),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_preferred_career_id, user_ref_id, career_ref_id, preference, not_sure, added_on, career_name, parent_choice', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'careerRef' => array(self::BELONGS_TO, 'LookupCareer', 'career_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_preferred_career_id' => 'Student Preferred Career',
			'user_ref_id' => 'User Ref',
			'career_ref_id' => 'Career Ref',
			'preference' => 'Preference',
			'not_sure' => 'Not Sure',
			'added_on' => 'Added On',
			'parent_choice' => 'Parent Choice',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_preferred_career_id',$this->student_preferred_career_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('career_ref_id',$this->career_ref_id,true);
		$criteria->compare('preference',$this->preference);
		$criteria->compare('not_sure',$this->not_sure);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('parent_choice',$this->parent_choice,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}