<?php

/**
 /*
 * @author Asif Ali M
 * @package application.models
 *
 * BaseStudentOutplacementSubdepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_subdepartment".
 *
 * The followings are the available columns in table 'student_outplacement_subdepartment':
 * @property string $student_outplacement_subdepartment_id
 * @property string $user_ref_id
 * @property integer $sub_dept_ref_id
 * @property string $sub_dept_name
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupDepartment $subDeptRef
 */
class BaseStudentOutplacementSubdepartment extends CActiveRecord
{
    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return StudentOutplacementSubdepartment the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'student_outplacement_subdepartment';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
        array('user_ref_id, added_on, added_by', 'required'),
        array('sub_dept_ref_id', 'numerical', 'integerOnly'=>true),
        array('user_ref_id, added_by', 'length', 'max'=>10),
        array('sub_dept_name', 'length', 'max'=>255),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array('student_outplacement_subdepartment_id, user_ref_id, sub_dept_ref_id, sub_dept_name, added_on, added_by', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'subDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_dept_ref_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
			'student_outplacement_subdepartment_id' => 'Student Outplacement Subdepartment',
			'user_ref_id' => 'User Ref',
			'sub_dept_ref_id' => 'Sub Dept Ref',
			'sub_dept_name' => 'Sub Dept Name',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('student_outplacement_subdepartment_id',$this->student_outplacement_subdepartment_id,true);
        $criteria->compare('user_ref_id',$this->user_ref_id,true);
        $criteria->compare('sub_dept_ref_id',$this->sub_dept_ref_id);
        $criteria->compare('sub_dept_name',$this->sub_dept_name,true);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('added_by',$this->added_by,true);

        return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
        ));
    }
}