<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentOutplacementColleges is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_colleges".
 *
 * The followings are the available columns in table 'student_outplacement_colleges':
 * @property string $student_outplacement_colleges_id
 * @property integer $uni_ref_id
 * @property string $status
 * @property string $added_on
 * @property integer $dept_ref_id
 * @property string $scholarship_received
 * @property integer $amount
 * @property integer $currency_ref_id
 * @property string $uni_name
 * @property string $user_ref_id
 * @property string $others
 *
 * The followings are the available model relations:
 * @property LookupCurrency $currencyRef
 * @property LookupDepartment $deptRef
 * @property TblUniversityMaster $uniRef
 * @property TblUserMaster $userRef
 */
class BaseStudentOutplacementColleges extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentOutplacementColleges the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_outplacement_colleges';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on, user_ref_id', 'required'),
			array('uni_ref_id, dept_ref_id, amount, currency_ref_id', 'numerical', 'integerOnly'=>true),
			array('status', 'length', 'max'=>18),
			array('scholarship_received', 'length', 'max'=>1),
			array('uni_name', 'length', 'max'=>300),
			array('user_ref_id', 'length', 'max'=>10),
			array('others', 'length', 'max'=>30),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_outplacement_colleges_id, uni_ref_id, status, added_on, dept_ref_id, scholarship_received, amount, currency_ref_id, uni_name, user_ref_id, others', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'deptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'dept_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_outplacement_colleges_id' => 'Student Outplacement Colleges',
			'uni_ref_id' => 'Uni Ref',
			'status' => 'Status',
			'added_on' => 'Added On',
			'dept_ref_id' => 'Dept Ref',
			'scholarship_received' => 'Scholarship Received',
			'amount' => 'Amount',
			'currency_ref_id' => 'Currency Ref',
			'uni_name' => 'Uni Name',
			'user_ref_id' => 'User Ref',
			'others' => 'Others',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_outplacement_colleges_id',$this->student_outplacement_colleges_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('dept_ref_id',$this->dept_ref_id);
		$criteria->compare('scholarship_received',$this->scholarship_received,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('uni_name',$this->uni_name,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('others',$this->others,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}