<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentMilestoneComment is autogenerate by UniModel generator
 *
 * This is the model class for table "student_milestone_comment".
 *
 * The followings are the available columns in table 'student_milestone_comment':
 * @property string $student_milestone_comment_id
 * @property string $user_ref_id
 * @property integer $milestone_id
 * @property string $parent_ref_id
 * @property string $comments
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LoginMaster $addedBy
 * @property StudentMilestoneComment $parentRef
 * @property StudentMilestoneComment[] $studentMilestoneComments
 */
class BaseStudentMilestoneComment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentMilestoneComment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_milestone_comment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, milestone_id, comments, added_by, added_on', 'required'),
			array('milestone_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, parent_ref_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_milestone_comment_id, user_ref_id, milestone_id, parent_ref_id, comments, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'parentRef' => array(self::BELONGS_TO, 'StudentMilestoneComment', 'parent_ref_id'),
			'studentMilestoneComments' => array(self::HAS_MANY, 'StudentMilestoneComment', 'parent_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_milestone_comment_id' => 'Student Milestone Comment',
			'user_ref_id' => 'User Ref',
			'milestone_id' => 'Milestone',
			'parent_ref_id' => 'Parent Ref',
			'comments' => 'Comments',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_milestone_comment_id',$this->student_milestone_comment_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('milestone_id',$this->milestone_id);
		$criteria->compare('parent_ref_id',$this->parent_ref_id,true);
		$criteria->compare('comments',$this->comments,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}