<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentContactNumber is autogenerate by UniModel generator
 *
 * This is the model class for table "student_contact_number".
 *
 * The followings are the available columns in table 'student_contact_number':
 * @property string $student_contact_number_id
 * @property string $user_ref_id
 * @property string $phone_type
 * @property integer $contact_type_ref_id
 * @property string $country_code
 * @property integer $country_ref_id
 * @property string $number
 * @property integer $extension
 * @property integer $is_primary
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property string $is_verified
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupContactType $contactTypeRef
 * @property TblCountryMaster $countryRef
 * @property LoginMaster $modifiedBy
 * @property TblUserMaster $userRef
 */
class BaseStudentContactNumber extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentContactNumber the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_contact_number';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, contact_type_ref_id, number, added_on, added_by', 'required'),
			array('contact_type_ref_id, country_ref_id, extension, is_primary', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, country_code, added_by, modified_by', 'length', 'max'=>10),
			array('phone_type', 'length', 'max'=>6),
			array('number', 'length', 'max'=>20),
			array('is_verified', 'length', 'max'=>1),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_contact_number_id, user_ref_id, phone_type, contact_type_ref_id, country_code, country_ref_id, number, extension, is_primary, added_on, added_by, modified_on, modified_by, is_verified', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'contactTypeRef' => array(self::BELONGS_TO, 'LookupContactType', 'contact_type_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_contact_number_id' => 'Student Contact Number',
			'user_ref_id' => 'User Ref',
			'phone_type' => 'Phone Type',
			'contact_type_ref_id' => 'Contact Type Ref',
			'country_code' => 'Country Code',
			'country_ref_id' => 'Country Ref',
			'number' => 'Number',
			'extension' => 'Extension',
			'is_primary' => 'Is Primary',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'is_verified' => 'Is Verified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_contact_number_id',$this->student_contact_number_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('phone_type',$this->phone_type,true);
		$criteria->compare('contact_type_ref_id',$this->contact_type_ref_id);
		$criteria->compare('country_code',$this->country_code,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('number',$this->number,true);
		$criteria->compare('extension',$this->extension);
		$criteria->compare('is_primary',$this->is_primary);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('is_verified',$this->is_verified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}