<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudent is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_user_master".
 *
 * The followings are the available columns in table 'tbl_user_master':
 * @property string $user_id
 * @property string $login_ref_id
 * @property string $user_type
 * @property integer $membership_ref_id
 * @property string $uno
 * @property string $institute_logo
 * @property string $user_photo
 * @property string $email_id
 * @property string $passwd
 * @property string $first_name
 * @property string $middle_name
 * @property string $last_name
 * @property string $father_first_name
 * @property string $father_last_name
 * @property string $mother_first_name
 * @property string $mother_last_name
 * @property string $address1
 * @property string $address2
 * @property string $city
 * @property string $state
 * @property integer $country_ref_id
 * @property string $post_code
 * @property string $present_class
 * @property string $class_status
 * @property integer $present_board_ref_id
 * @property string $present_school
 * @property integer $school_ref_id
 * @property integer $passout_year
 * @property integer $passout_month
 * @property string $citizenship
 * @property string $counselling_contact
 * @property string $primary_phone_country_code
 * @property string $primary_phone
 * @property string $primary_phone_type
 * @property string $secondary_phone_country_code
 * @property string $secondary_phone
 * @property string $secondary_phone_type
 * @property string $mother_phone_country_code
 * @property string $father_phone_country_code
 * @property string $mother_phone_number
 * @property string $father_phone_number
 * @property string $mother_email
 * @property string $father_email
 * @property string $dob
 * @property string $gender
 * @property integer $ethnicity
 * @property string $languages
 * @property string $subject_ref_id
 * @property string $subject_option
 * @property string $course_subject_ref_ids
 * @property string $choice_countries
 * @property string $choice_cities
 * @property string $study_level
 * @property string $potential_start_dt
 * @property string $study_duration
 * @property string $university_size
 * @property string $university_location
 * @property string $university_courses
 * @property string $international_stud_per
 * @property string $international_stud_per_rating
 * @property string $size_of_stud_body
 * @property string $size_of_stud_body_rating
 * @property string $annual_fees
 * @property string $annual_fees_rating
 * @property string $institute_rank
 * @property string $institute_rank_rating
 * @property string $scholarship
 * @property string $scholarship_rating
 * @property string $admission_rate
 * @property string $admission_rate_rating
 * @property string $course_type
 * @property string $course_level_ids
 * @property string $male_female_ratio
 * @property string $fd_fees
 * @property string $fd_family_income
 * @property string $fd_primary_financing
 * @property string $fd_scholarship_imp
 * @property string $countries_travelled
 * @property string $reason_studying_abroad
 * @property string $ec_leadership
 * @property string $ps_aim
 * @property string $ps_why_this_subject
 * @property string $ps_leadership
 * @property string $ps_key_achievement
 * @property string $visa_required
 * @property integer $profile_status
 * @property string $introduce_yourself
 * @property integer $redirect_url_ref_id
 * @property integer $profile_status_ref_id
 * @property integer $payment_status_ref_id
 * @property string $is_active
 * @property string $is_confirm
 * @property string $is_newsletter_subscribe
 * @property string $added_on
 * @property string $modified_on
 * @property string $new_password
 * @property integer $profile_percent
 * @property integer $book_session_count
 * @property string $is_valid_email
 * @property string $acceptance_date
 * @property string $profile_complete_date
 * @property integer $critical_percent
 * @property integer $recommended_percent
 *
 * The followings are the available model relations:
 * @property DiSearchResult[] $diSearchResults
 * @property EventStudent[] $eventStudents
 * @property Prospect[] $prospects
 * @property StudentKnownLanguage[] $studentKnownLanguages
 * @property StudentPreferredCountry[] $studentPreferredCountries
 * @property StudentPreferredDepartment[] $studentPreferredDepartments
 * @property StudentPreferredDuration[] $studentPreferredDurations
 * @property StudentPreferredPeriod[] $studentPreferredPeriods
 * @property StudentPreferredStudyLevel[] $studentPreferredStudyLevels
 * @property StudentPreferredUniversity[] $studentPreferredUniversities
 * @property StudentQuestion[] $studentQuestions
 * @property LookupPaymentStatus $paymentStatusRef
 * @property LookupProfileStatus $profileStatusRef
 * @property LookupSchool $schoolRef
 * @property LookupUrl $redirectUrlRef
 * @property LookupBoard $presentBoardRef
 */
class BaseStudent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Student the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_user_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('passout_year, passout_month', 'required'),
			array('membership_ref_id, country_ref_id, present_board_ref_id, school_ref_id, passout_year, passout_month, ethnicity, profile_status, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, profile_percent, book_session_count, critical_percent, recommended_percent', 'numerical', 'integerOnly'=>true),
			array('login_ref_id, institute_rank, reason_studying_abroad', 'length', 'max'=>10),
			array('user_type, passwd, first_name, middle_name, last_name, post_code, international_stud_per_rating, size_of_stud_body_rating, annual_fees_rating, institute_rank_rating, scholarship_rating, admission_rate_rating', 'length', 'max'=>100),
			array('uno', 'length', 'max'=>11),
			array('institute_logo', 'length', 'max'=>250),
			array('user_photo, email_id, citizenship, choice_countries, study_level, university_size, university_location, international_stud_per, male_female_ratio, fd_fees, fd_family_income, fd_primary_financing, fd_scholarship_imp, countries_travelled', 'length', 'max'=>255),
			array('father_first_name, father_last_name, mother_first_name, mother_last_name, present_school', 'length', 'max'=>75),
			array('address1, address2, city, state', 'length', 'max'=>200),
			array('present_class', 'length', 'max'=>2),
			array('class_status', 'length', 'max'=>8),
			array('counselling_contact, gender, subject_option, visa_required, is_active, is_confirm, is_newsletter_subscribe, new_password, is_valid_email', 'length', 'max'=>1),
			array('primary_phone_country_code, secondary_phone_country_code, mother_phone_country_code, father_phone_country_code', 'length', 'max'=>4),
			array('primary_phone, secondary_phone, mother_email, father_email', 'length', 'max'=>50),
			array('primary_phone_type, secondary_phone_type', 'length', 'max'=>6),
			array('mother_phone_number, father_phone_number', 'length', 'max'=>20),
			array('size_of_stud_body, annual_fees, scholarship, admission_rate, course_type, course_level_ids', 'length', 'max'=>30),
			array('dob, languages, subject_ref_id, course_subject_ref_ids, choice_cities, potential_start_dt, study_duration, university_courses, ec_leadership, ps_why_this_subject, ps_leadership, ps_key_achievement, introduce_yourself, added_on, modified_on, acceptance_date, profile_complete_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_id, login_ref_id, user_type, membership_ref_id, uno, institute_logo, user_photo, email_id, passwd, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, address1, address2, city, state, country_ref_id, post_code, present_class, class_status, present_board_ref_id, present_school, school_ref_id, passout_year, passout_month, citizenship, counselling_contact, primary_phone_country_code, primary_phone, primary_phone_type, secondary_phone_country_code, secondary_phone, secondary_phone_type, mother_phone_country_code, father_phone_country_code, mother_phone_number, father_phone_number, mother_email, father_email, dob, gender, ethnicity, languages, subject_ref_id, subject_option, course_subject_ref_ids, choice_countries, choice_cities, study_level, potential_start_dt, study_duration, university_size, university_location, university_courses, international_stud_per, international_stud_per_rating, size_of_stud_body, size_of_stud_body_rating, annual_fees, annual_fees_rating, institute_rank, institute_rank_rating, scholarship, scholarship_rating, admission_rate, admission_rate_rating, course_type, course_level_ids, male_female_ratio, fd_fees, fd_family_income, fd_primary_financing, fd_scholarship_imp, countries_travelled, reason_studying_abroad, ec_leadership, ps_why_this_subject, ps_leadership, ps_key_achievement, visa_required, profile_status, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_active, is_confirm, is_newsletter_subscribe, added_on, modified_on, new_password, profile_percent, book_session_count, is_valid_email, acceptance_date, profile_complete_date, critical_percent, recommended_percent', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diSearchResults' => array(self::HAS_MANY, 'DiSearchResult', 'user_ref_id'),
			'eventStudents' => array(self::HAS_MANY, 'EventStudent', 'user_ref_id'),
			'prospects' => array(self::HAS_MANY, 'Prospect', 'user_ref_id'),
			'studentKnownLanguages' => array(self::HAS_MANY, 'StudentKnownLanguage', 'user_ref_id'),
			'studentPreferredCountries' => array(self::HAS_MANY, 'StudentPreferredCountry', 'user_ref_id'),
			'studentPreferredDepartments' => array(self::HAS_MANY, 'StudentPreferredDepartment', 'user_ref_id'),
			'studentPreferredDurations' => array(self::HAS_MANY, 'StudentPreferredDuration', 'user_ref_id'),
			'studentPreferredPeriods' => array(self::HAS_MANY, 'StudentPreferredPeriod', 'user_ref_id'),
			'studentPreferredStudyLevels' => array(self::HAS_MANY, 'StudentPreferredStudyLevel', 'user_ref_id'),
			'studentPreferredUniversities' => array(self::HAS_MANY, 'StudentPreferredUniversity', 'user_ref_id'),
			'studentQuestions' => array(self::HAS_MANY, 'StudentQuestion', 'user_ref_id'),
			'paymentStatusRef' => array(self::BELONGS_TO, 'LookupPaymentStatus', 'payment_status_ref_id'),
			'profileStatusRef' => array(self::BELONGS_TO, 'LookupProfileStatus', 'profile_status_ref_id'),
			'schoolRef' => array(self::BELONGS_TO, 'LookupSchool', 'school_ref_id'),
			'redirectUrlRef' => array(self::BELONGS_TO, 'LookupUrl', 'redirect_url_ref_id'),
			'presentBoardRef' => array(self::BELONGS_TO, 'LookupBoard', 'present_board_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_id' => 'User',
			'login_ref_id' => 'Login Ref',
			'user_type' => 'User Type',
			'membership_ref_id' => 'Membership Ref',
			'uno' => 'Uno',
			'institute_logo' => 'Institute Logo',
			'user_photo' => 'User Photo',
			'email_id' => 'Email',
			'passwd' => 'Passwd',
			'first_name' => 'First Name',
			'middle_name' => 'Middle Name',
			'last_name' => 'Last Name',
			'father_first_name' => 'Father First Name',
			'father_last_name' => 'Father Last Name',
			'mother_first_name' => 'Mother First Name',
			'mother_last_name' => 'Mother Last Name',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city' => 'City',
			'state' => 'State',
			'country_ref_id' => 'Country Ref',
			'post_code' => 'Post Code',
			'present_class' => 'Present Class',
			'class_status' => 'Class Status',
			'present_board_ref_id' => 'Present Board Ref',
			'present_school' => 'Present School',
			'school_ref_id' => 'School Ref',
			'passout_year' => 'Passout Year',
			'passout_month' => 'Passout Month',
			'citizenship' => 'Citizenship',
			'counselling_contact' => 'Counselling Contact',
			'primary_phone_country_code' => 'Primary Phone Country Code',
			'primary_phone' => 'Primary Phone',
			'primary_phone_type' => 'Primary Phone Type',
			'secondary_phone_country_code' => 'Secondary Phone Country Code',
			'secondary_phone' => 'Secondary Phone',
			'secondary_phone_type' => 'Secondary Phone Type',
			'mother_phone_country_code' => 'Mother Phone Country Code',
			'father_phone_country_code' => 'Father Phone Country Code',
			'mother_phone_number' => 'Mother Phone Number',
			'father_phone_number' => 'Father Phone Number',
			'mother_email' => 'Mother Email',
			'father_email' => 'Father Email',
			'dob' => 'Dob',
			'gender' => 'Gender',
			'ethnicity' => 'Ethnicity',
			'languages' => 'Languages',
			'subject_ref_id' => 'Subject Ref',
			'subject_option' => 'Subject Option',
			'course_subject_ref_ids' => 'Course Subject Ref Ids',
			'choice_countries' => 'Choice Countries',
			'choice_cities' => 'Choice Cities',
			'study_level' => 'Study Level',
			'potential_start_dt' => 'Potential Start Dt',
			'study_duration' => 'Study Duration',
			'university_size' => 'University Size',
			'university_location' => 'University Location',
			'university_courses' => 'University Courses',
			'international_stud_per' => 'International Stud Per',
			'international_stud_per_rating' => 'International Stud Per Rating',
			'size_of_stud_body' => 'Size Of Stud Body',
			'size_of_stud_body_rating' => 'Size Of Stud Body Rating',
			'annual_fees' => 'Annual Fees',
			'annual_fees_rating' => 'Annual Fees Rating',
			'institute_rank' => 'Institute Rank',
			'institute_rank_rating' => 'Institute Rank Rating',
			'scholarship' => 'Scholarship',
			'scholarship_rating' => 'Scholarship Rating',
			'admission_rate' => 'Admission Rate',
			'admission_rate_rating' => 'Admission Rate Rating',
			'course_type' => 'Course Type',
			'course_level_ids' => 'Course Level Ids',
			'male_female_ratio' => 'Male Female Ratio',
			'fd_fees' => 'Fd Fees',
			'fd_family_income' => 'Fd Family Income',
			'fd_primary_financing' => 'Fd Primary Financing',
			'fd_scholarship_imp' => 'Fd Scholarship Imp',
			'countries_travelled' => 'Countries Travelled',
			'reason_studying_abroad' => 'Reason Studying Abroad',
			'ec_leadership' => 'Ec Leadership',
			//'ps_aim' => 'Ps Aim',
			'ps_why_this_subject' => 'Ps Why This Subject',
			'ps_leadership' => 'Ps Leadership',
			'ps_key_achievement' => 'Ps Key Achievement',
			'visa_required' => 'Visa Required',
			'profile_status' => 'Profile Status',
			'introduce_yourself' => 'Introduce Yourself',
			'redirect_url_ref_id' => 'Redirect Url Ref',
			'profile_status_ref_id' => 'Profile Status Ref',
			'payment_status_ref_id' => 'Payment Status Ref',
			'is_active' => 'Is Active',
			'is_confirm' => 'Is Confirm',
			'is_newsletter_subscribe' => 'Is Newsletter Subscribe',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'new_password' => 'New Password',
			'profile_percent' => 'Profile Percent',
			'book_session_count' => 'Book Session Count',
			'is_valid_email' => 'Is Valid Email',
			'acceptance_date' => 'Acceptance Date',
			'profile_complete_date' => 'Profile Complete Date',
			'critical_percent' => 'Critical Percent',
			'recommended_percent' => 'Recommended Percent',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('user_type',$this->user_type,true);
		$criteria->compare('membership_ref_id',$this->membership_ref_id);
		$criteria->compare('uno',$this->uno,true);
		$criteria->compare('institute_logo',$this->institute_logo,true);
		$criteria->compare('user_photo',$this->user_photo,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('passwd',$this->passwd,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('middle_name',$this->middle_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('father_first_name',$this->father_first_name,true);
		$criteria->compare('father_last_name',$this->father_last_name,true);
		$criteria->compare('mother_first_name',$this->mother_first_name,true);
		$criteria->compare('mother_last_name',$this->mother_last_name,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('post_code',$this->post_code,true);
		$criteria->compare('present_class',$this->present_class,true);
		$criteria->compare('class_status',$this->class_status,true);
		$criteria->compare('present_board_ref_id',$this->present_board_ref_id);
		$criteria->compare('present_school',$this->present_school,true);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('passout_year',$this->passout_year);
		$criteria->compare('passout_month',$this->passout_month);
		$criteria->compare('citizenship',$this->citizenship,true);
		$criteria->compare('counselling_contact',$this->counselling_contact,true);
		$criteria->compare('primary_phone_country_code',$this->primary_phone_country_code,true);
		$criteria->compare('primary_phone',$this->primary_phone,true);
		$criteria->compare('primary_phone_type',$this->primary_phone_type,true);
		$criteria->compare('secondary_phone_country_code',$this->secondary_phone_country_code,true);
		$criteria->compare('secondary_phone',$this->secondary_phone,true);
		$criteria->compare('secondary_phone_type',$this->secondary_phone_type,true);
		$criteria->compare('mother_phone_country_code',$this->mother_phone_country_code,true);
		$criteria->compare('father_phone_country_code',$this->father_phone_country_code,true);
		$criteria->compare('mother_phone_number',$this->mother_phone_number,true);
		$criteria->compare('father_phone_number',$this->father_phone_number,true);
		$criteria->compare('mother_email',$this->mother_email,true);
		$criteria->compare('father_email',$this->father_email,true);
		$criteria->compare('dob',$this->dob,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('ethnicity',$this->ethnicity);
		$criteria->compare('languages',$this->languages,true);
		$criteria->compare('subject_ref_id',$this->subject_ref_id,true);
		$criteria->compare('subject_option',$this->subject_option,true);
		$criteria->compare('course_subject_ref_ids',$this->course_subject_ref_ids,true);
		$criteria->compare('choice_countries',$this->choice_countries,true);
		$criteria->compare('choice_cities',$this->choice_cities,true);
		$criteria->compare('study_level',$this->study_level,true);
		$criteria->compare('potential_start_dt',$this->potential_start_dt,true);
		$criteria->compare('study_duration',$this->study_duration,true);
		$criteria->compare('university_size',$this->university_size,true);
		$criteria->compare('university_location',$this->university_location,true);
		$criteria->compare('university_courses',$this->university_courses,true);
		$criteria->compare('international_stud_per',$this->international_stud_per,true);
		$criteria->compare('international_stud_per_rating',$this->international_stud_per_rating,true);
		$criteria->compare('size_of_stud_body',$this->size_of_stud_body,true);
		$criteria->compare('size_of_stud_body_rating',$this->size_of_stud_body_rating,true);
		$criteria->compare('annual_fees',$this->annual_fees,true);
		$criteria->compare('annual_fees_rating',$this->annual_fees_rating,true);
		$criteria->compare('institute_rank',$this->institute_rank,true);
		$criteria->compare('institute_rank_rating',$this->institute_rank_rating,true);
		$criteria->compare('scholarship',$this->scholarship,true);
		$criteria->compare('scholarship_rating',$this->scholarship_rating,true);
		$criteria->compare('admission_rate',$this->admission_rate,true);
		$criteria->compare('admission_rate_rating',$this->admission_rate_rating,true);
		$criteria->compare('course_type',$this->course_type,true);
		$criteria->compare('course_level_ids',$this->course_level_ids,true);
		$criteria->compare('male_female_ratio',$this->male_female_ratio,true);
		$criteria->compare('fd_fees',$this->fd_fees,true);
		$criteria->compare('fd_family_income',$this->fd_family_income,true);
		$criteria->compare('fd_primary_financing',$this->fd_primary_financing,true);
		$criteria->compare('fd_scholarship_imp',$this->fd_scholarship_imp,true);
		$criteria->compare('countries_travelled',$this->countries_travelled,true);
		$criteria->compare('reason_studying_abroad',$this->reason_studying_abroad,true);
		$criteria->compare('ec_leadership',$this->ec_leadership,true);
		//$criteria->compare('ps_aim',$this->ps_aim,true);
		$criteria->compare('ps_why_this_subject',$this->ps_why_this_subject,true);
		$criteria->compare('ps_leadership',$this->ps_leadership,true);
		$criteria->compare('ps_key_achievement',$this->ps_key_achievement,true);
		$criteria->compare('visa_required',$this->visa_required,true);
		$criteria->compare('profile_status',$this->profile_status);
		$criteria->compare('introduce_yourself',$this->introduce_yourself,true);
		$criteria->compare('redirect_url_ref_id',$this->redirect_url_ref_id);
		$criteria->compare('profile_status_ref_id',$this->profile_status_ref_id);
		$criteria->compare('payment_status_ref_id',$this->payment_status_ref_id);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('is_confirm',$this->is_confirm,true);
		$criteria->compare('is_newsletter_subscribe',$this->is_newsletter_subscribe,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('new_password',$this->new_password,true);
		$criteria->compare('profile_percent',$this->profile_percent);
		$criteria->compare('book_session_count',$this->book_session_count);
		$criteria->compare('is_valid_email',$this->is_valid_email,true);
		$criteria->compare('acceptance_date',$this->acceptance_date,true);
		$criteria->compare('profile_complete_date',$this->profile_complete_date,true);
		$criteria->compare('critical_percent',$this->critical_percent);
		$criteria->compare('recommended_percent',$this->recommended_percent);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}