<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipShortName is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_short_name".
 *
 * The followings are the available columns in table 'scholarship_short_name':
 * @property string $scholarship_short_name_id
 * @property string $scholarship_ref_id
 * @property string $scholarship_short_name
 * @property string $is_primary
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Scholarship $scholarshipRef
 * @property LoginMaster $addedBy
 */
class BaseScholarshipShortName extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipShortName the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	
	public function tableName()
	{
		return 'scholarship_short_name';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, added_by', 'length', 'max'=>10),
			array('scholarship_short_name', 'length', 'max'=>150),
			array('is_primary', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_short_name_id, scholarship_ref_id, scholarship_short_name, is_primary, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_short_name_id' => 'Scholarship Short Name',
			'scholarship_ref_id' => 'Scholarship Ref',
			'scholarship_short_name' => 'Scholarship Short Name',
			'is_primary' => 'Is Primary',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_short_name_id',$this->scholarship_short_name_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('scholarship_short_name',$this->scholarship_short_name,true);
		$criteria->compare('is_primary',$this->is_primary,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}