<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BasePsychometricTest is autogenerate by UniModel generator
 *
 * This is the model class for table "psychometric_test".
 *
 * The followings are the available columns in table 'psychometric_test':
 * @property string $psychometric_test_id
 * @property string $user_ref_id
 * @property string $start_date
 * @property string $end_date
 * @property string $payment_status
 * @property string $report_unlocked
 * @property string $test_type
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BasePsychometricTest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PsychometricTest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'psychometric_test';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('start_date', 'required'),
			array('user_ref_id, payment_status', 'length', 'max'=>10),
			array('report_unlocked', 'length', 'max'=>1),
			array('test_type', 'length', 'max'=>2),
			array('end_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('psychometric_test_id, user_ref_id, start_date, end_date, payment_status, report_unlocked, test_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'psychometric_test_id' => 'Psychometric Test',
			'user_ref_id' => 'User Ref',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'payment_status' => 'Payment Status',
			'report_unlocked' => 'Report Unlocked',
			'test_type' => 'Test Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('psychometric_test_id',$this->psychometric_test_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('payment_status',$this->payment_status,true);
		$criteria->compare('report_unlocked',$this->report_unlocked,true);
		$criteria->compare('test_type',$this->test_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}