<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BasePopularCollege is autogenerate by UniModel generator
 *
 * This is the model class for table "popular_college".
 *
 * The followings are the available columns in table 'popular_college':
 * @property string $popular_college_id
 * @property integer $uni_ref_id
 * @property integer $shortlisted_count
 * @property integer $offers_made
 * @property double $score
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 */
class BasePopularCollege extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PopularCollege the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'popular_college';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required'),
			array('uni_ref_id, shortlisted_count, offers_made', 'numerical', 'integerOnly'=>true),
			array('score', 'numerical'),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('popular_college_id, uni_ref_id, shortlisted_count, offers_made, score, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'popular_college_id' => 'Popular College',
			'uni_ref_id' => 'Uni Ref',
			'shortlisted_count' => 'Shortlisted Count',
			'offers_made' => 'Offers Made',
			'score' => 'Score',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('popular_college_id',$this->popular_college_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('shortlisted_count',$this->shortlisted_count);
		$criteria->compare('offers_made',$this->offers_made);
		$criteria->compare('score',$this->score);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}