<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BasePlacementType is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_placement_type".
 *
 * The followings are the available columns in table 'lookup_placement_type':
 * @property integer $placement_type_id
 * @property string $placement_type
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property CoursePlacementType[] $coursePlacementTypes
 * @property MdmNewCoursePlacementType[] $mdmNewCoursePlacementTypes
 */
class BasePlacementType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PlacementType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_placement_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('placement_type, added_on', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('placement_type', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('placement_type_id, placement_type, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'coursePlacementTypes' => array(self::HAS_MANY, 'CoursePlacementType', 'placement_type_ref_id'),
			'mdmNewCoursePlacementTypes' => array(self::HAS_MANY, 'MdmNewCoursePlacementType', 'placement_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'placement_type_id' => 'Placement Type',
			'placement_type' => 'Placement Type',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('placement_type_id',$this->placement_type_id);
		$criteria->compare('placement_type',$this->placement_type,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}