<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BasePaymentCheque is autogenerate by UniModel generator
 *
 * This is the model class for table "payment_cheque".
 *
 * The followings are the available columns in table 'payment_cheque':
 * @property string $payment_cheque_id
 * @property string $order_payment_ref_id
 * @property string $cheque_number
 * @property string $cheque_date
 * @property double $amount
 * @property string $bank_name
 * @property string $added_on
 * @property string $account_number
 * @property string $bearer_text
 * @property string $instrument_type
 *
 * The followings are the available model relations:
 * @property OrderPayment $orderPaymentRef
 */
class BasePaymentCheque extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PaymentCheque the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'payment_cheque';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_payment_ref_id', 'required'),
			array('amount', 'numerical'),
			array('order_payment_ref_id', 'length', 'max'=>10),
			array('cheque_number, bank_name, account_number', 'length', 'max'=>45),
			array('bearer_text', 'length', 'max'=>75),
			array('instrument_type', 'length', 'max'=>6),
			array('cheque_date, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('payment_cheque_id, order_payment_ref_id, cheque_number, cheque_date, amount, bank_name, added_on, account_number, bearer_text, instrument_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'orderPaymentRef' => array(self::BELONGS_TO, 'OrderPayment', 'order_payment_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'payment_cheque_id' => 'Payment Cheque',
			'order_payment_ref_id' => 'Order Payment Ref',
			'cheque_number' => 'Cheque Number',
			'cheque_date' => 'Cheque Date',
			'amount' => 'Amount',
			'bank_name' => 'Bank Name',
			'added_on' => 'Added On',
			'account_number' => 'Account Number',
			'bearer_text' => 'Bearer Text',
			'instrument_type' => 'Instrument Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('payment_cheque_id',$this->payment_cheque_id,true);
		$criteria->compare('order_payment_ref_id',$this->order_payment_ref_id,true);
		$criteria->compare('cheque_number',$this->cheque_number,true);
		$criteria->compare('cheque_date',$this->cheque_date,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('bank_name',$this->bank_name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('account_number',$this->account_number,true);
		$criteria->compare('bearer_text',$this->bearer_text,true);
		$criteria->compare('instrument_type',$this->instrument_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}