<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseOrderItem is autogenerate by UniModel generator
 *
 * This is the model class for table "order_item".
 *
 * The followings are the available columns in table 'order_item':
 * @property string $order_item_id
 * @property string $order_master_ref_id
 * @property integer $product_ref_id
 * @property string $invoice_customer_product_ref_id
 * @property double $quantity
 * @property double $order_item_subtotal
 * @property double $order_item_tax
 * @property double $order_item_discount
 * @property double $order_item_grand_total
 * @property string $added_on
 * @property string $added_by
 * @property string $comments
 *
 * The followings are the available model relations:
 * @property InvoiceCustomerProduct $invoiceCustomerProductRef
 * @property OrderMaster $orderMasterRef
 * @property LookupProduct $productRef
 */
class BaseOrderItem extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrderItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'order_item';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_master_ref_id', 'required'),
			array('product_ref_id', 'numerical', 'integerOnly'=>true),
			array('quantity, order_item_subtotal, order_item_tax, order_item_discount, order_item_grand_total', 'numerical'),
			array('order_master_ref_id, invoice_customer_product_ref_id, added_by', 'length', 'max'=>10),
			array('comments', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('order_item_id, order_master_ref_id, product_ref_id, invoice_customer_product_ref_id, quantity, order_item_subtotal, order_item_tax, order_item_discount, order_item_grand_total, added_on, added_by, comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'invoiceCustomerProductRef' => array(self::BELONGS_TO, 'InvoiceCustomerProduct', 'invoice_customer_product_ref_id'),
			'orderMasterRef' => array(self::BELONGS_TO, 'OrderMaster', 'order_master_ref_id'),
			'productRef' => array(self::BELONGS_TO, 'LookupProduct', 'product_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'order_item_id' => 'Order Item',
			'order_master_ref_id' => 'Order Master Ref',
			'product_ref_id' => 'Product Ref',
			'invoice_customer_product_ref_id' => 'Invoice Customer Product Ref',
			'quantity' => 'Quantity',
			'order_item_subtotal' => 'Order Item Subtotal',
			'order_item_tax' => 'Order Item Tax',
			'order_item_discount' => 'Order Item Discount',
			'order_item_grand_total' => 'Order Item Grand Total',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'comments' => 'Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('order_item_id',$this->order_item_id,true);
		$criteria->compare('order_master_ref_id',$this->order_master_ref_id,true);
		$criteria->compare('product_ref_id',$this->product_ref_id);
		$criteria->compare('invoice_customer_product_ref_id',$this->invoice_customer_product_ref_id,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('order_item_subtotal',$this->order_item_subtotal);
		$criteria->compare('order_item_tax',$this->order_item_tax);
		$criteria->compare('order_item_discount',$this->order_item_discount);
		$criteria->compare('order_item_grand_total',$this->order_item_grand_total);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('comments',$this->comments,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}