<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMockTestEntranceExam is autogenerate by UniModel generator
 *
 * This is the model class for table "mock_test_entrance_exam".
 *
 * The followings are the available columns in table 'mock_test_entrance_exam':
 * @property string $mock_test_entrance_exam_id
 * @property string $mock_test_ref_id
 * @property integer $entrance_ref_id
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property TblMockTest $mockTestRef
 * @property EntranceExam $entranceRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseMockTestEntranceExam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MockTestEntranceExam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mock_test_entrance_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_ref_id', 'numerical', 'integerOnly'=>true),
			array('mock_test_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mock_test_entrance_exam_id, mock_test_ref_id, entrance_ref_id, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mockTestRef' => array(self::BELONGS_TO, 'TblMockTest', 'mock_test_ref_id'),
			'entranceRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mock_test_entrance_exam_id' => 'Mock Test Entrance Exam',
			'mock_test_ref_id' => 'Mock Test Ref',
			'entrance_ref_id' => 'Entrance Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mock_test_entrance_exam_id',$this->mock_test_entrance_exam_id,true);
		$criteria->compare('mock_test_ref_id',$this->mock_test_ref_id,true);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}