<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupProspectCategory is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_prospect_category".
 *
 * The followings are the available columns in table 'lookup_prospect_category':
 * @property integer $prospect_category_id
 * @property string $value
 * @property string $category
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Prospect[] $prospects
 */
class BaseLookupProspectCategory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupProspectCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_prospect_category';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('value', 'required'),
			array('value', 'length', 'max'=>255),
			array('category', 'length', 'max'=>45),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('prospect_category_id, value, category, parent_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'prospects' => array(self::HAS_MANY, 'Prospect', 'prospect_category_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'prospect_category_id' => 'Prospect Category',
		    'parent_id' => 'Main Category',
			'value' => 'Value',
			'category' => 'Category',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('prospect_category_id',$this->prospect_category_id);
		$criteria->compare('value',$this->value,true);
		$criteria->compare('category',$this->category,true);
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}