<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupPopularDegree is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_popular_degree".
 *
 * The followings are the available columns in table 'lookup_popular_degree':
 * @property integer $popular_degree_id
 * @property string $degree_name
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupDegreeGranted[] $lookupDegreeGranteds
 * @property MdmNewCourseLog[] $mdmNewCourseLogs
 * @property TblUniCourses[] $tblUniCourses
 */
class BaseLookupPopularDegree extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupPopularDegree the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_popular_degree';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('degree_name, added_on', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('degree_name', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('popular_degree_id, degree_name, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupDegreeGranteds' => array(self::HAS_MANY, 'LookupDegreeGranted', 'popular_degree_ref_id'),
			'mdmNewCourseLogs' => array(self::HAS_MANY, 'MdmNewCourseLog', 'popular_degree_ref_id'),
			'tblUniCourses' => array(self::HAS_MANY, 'TblUniCourses', 'popular_degree_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'popular_degree_id' => 'Popular Degree',
			'degree_name' => 'Degree Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('popular_degree_id',$this->popular_degree_id);
		$criteria->compare('degree_name',$this->degree_name,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}