<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupCityCluster is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_city_cluster".
 *
 * The followings are the available columns in table 'lookup_city_cluster':
 * @property integer $city_cluster_id
 * @property string $cluster_name
 * @property string $is_active
 * @property string $added_on
 * @property string $synonym_names
 *
 * The followings are the available model relations:
 * @property StudentPreferredLocation[] $studentPreferredLocations
 * @property TblCityMaster[] $tblCityMasters
 */
class BaseLookupCityCluster extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCityCluster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_city_cluster';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('cluster_name', 'length', 'max'=>150),
			array('is_active', 'length', 'max'=>1),
			array('synonym_names', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('city_cluster_id, cluster_name, is_active, added_on, synonym_names', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentPreferredLocations' => array(self::HAS_MANY, 'StudentPreferredLocation', 'cluster_ref_id'),
			'tblCityMasters' => array(self::HAS_MANY, 'TblCityMaster', 'cluster_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'city_cluster_id' => 'City Cluster',
			'cluster_name' => 'Cluster Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'synonym_names' => 'Synonym Names',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('city_cluster_id',$this->city_cluster_id);
		$criteria->compare('cluster_name',$this->cluster_name,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('synonym_names',$this->synonym_names,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}