<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupCareerInterestMapping is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_career_interest_mapping".
 *
 * The followings are the available columns in table 'lookup_career_interest_mapping':
 * @property integer $career_interest_mapping_id
 * @property integer $primary_interest_ref_id
 * @property integer $secondary_interest_ref_id
 * @property string $career_ref_id
 * @property integer $preference_order
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupCareer $careerRef
 * @property LookupInterest $primaryInterestRef
 * @property LookupInterest $secondaryInterestRef
 */
class BaseLookupCareerInterestMapping extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCareerInterestMapping the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_career_interest_mapping';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('primary_interest_ref_id, secondary_interest_ref_id, career_ref_id, added_on', 'required'),
			array('primary_interest_ref_id, secondary_interest_ref_id, preference_order, is_active', 'numerical', 'integerOnly'=>true),
			array('career_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('career_interest_mapping_id, primary_interest_ref_id, secondary_interest_ref_id, career_ref_id, preference_order, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
        return array(
            'primaryInterest' => array(self::BELONGS_TO, 'LookupInterest', 'primary_interest_ref_id'),
            'secondaryInterest' => array(self::BELONGS_TO, 'LookupInterest', 'secondary_interest_ref_id'),
            'career' => array(self::BELONGS_TO, 'LookupCareer', 'career_ref_id'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'career_interest_mapping_id' => 'Career Interest Mapping',
			'primary_interest_ref_id' => 'Primary Interest Ref',
			'secondary_interest_ref_id' => 'Secondary Interest Ref',
			'career_ref_id' => 'Career Ref',
			'preference_order' => 'Preference Order',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('career_interest_mapping_id',$this->career_interest_mapping_id);
		$criteria->compare('primary_interest_ref_id',$this->primary_interest_ref_id);
		$criteria->compare('secondary_interest_ref_id',$this->secondary_interest_ref_id);
		$criteria->compare('career_ref_id',$this->career_ref_id,true);
		$criteria->compare('preference_order',$this->preference_order);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}