<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupBudget is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_budget".
 *
 * The followings are the available columns in table 'lookup_budget':
 * @property integer $budget_id
 * @property integer $currency_ref_id
 * @property string $budget
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupCurrency $currencyRef
 */
class BaseLookupBudget extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupBudget the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_budget';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('currency_ref_id, budget, added_on', 'required'),
			array('currency_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('budget', 'length', 'max'=>25),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('budget_id, currency_ref_id, budget, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'budget_id' => 'Budget',
			'currency_ref_id' => 'Currency Ref',
			'budget' => 'Budget',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('budget_id',$this->budget_id);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('budget',$this->budget,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}