<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEventEmailDeptOrder is autogenerate by UniModel generator
 *
 * This is the model class for table "event_email_dept_order".
 *
 * The followings are the available columns in table 'event_email_dept_order':
 * @property integer $event_email_dept_order_id
 * @property integer $event_email_ref_id
 * @property integer $dept_pref_order
 *
 * The followings are the available model relations:
 * @property EventEmail $eventEmailRef
 */
class BaseEventEmailDeptOrder extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventEmailDeptOrder the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_email_dept_order';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_email_ref_id', 'required'),
			array('event_email_ref_id, dept_pref_order', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_email_dept_order_id, event_email_ref_id, dept_pref_order', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventEmailRef' => array(self::BELONGS_TO, 'EventEmail', 'event_email_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_email_dept_order_id' => 'Event Email Dept Order',
			'event_email_ref_id' => 'Event Email Ref',
			'dept_pref_order' => 'Dept Pref Order',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_email_dept_order_id',$this->event_email_dept_order_id);
		$criteria->compare('event_email_ref_id',$this->event_email_ref_id);
		$criteria->compare('dept_pref_order',$this->dept_pref_order);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}