<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseErrorReportVendor is autogenerate by UniModel generator
 *
 * This is the model class for table "error_report_vendor".
 *
 * The followings are the available columns in table 'error_report_vendor':
 * @property integer $error_report_vendor_id
 * @property string $vendor_centre_ref_id
 * @property string $about_institute
 * @property string $course_offered
 * @property string $other_info
 * @property string $email_id
 * @property string $suggestion
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property VendorCentre $vendorCentreRef
 * @property LoginMaster $addedBy
 */
class BaseErrorReportVendor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ErrorReportVendor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'error_report_vendor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_centre_ref_id, added_on', 'required'),
			array('vendor_centre_ref_id, added_by', 'length', 'max'=>10),
			array('about_institute, course_offered, other_info', 'length', 'max'=>1),
			array('email_id', 'length', 'max'=>100),
			array('suggestion', 'length', 'max'=>1000),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('error_report_vendor_id, vendor_centre_ref_id, about_institute, course_offered, other_info, email_id, suggestion, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'error_report_vendor_id' => 'Error Report Vendor',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'about_institute' => 'About Institute',
			'course_offered' => 'Course Offered',
			'other_info' => 'Other Info',
			'email_id' => 'Email',
			'suggestion' => 'Suggestion',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('error_report_vendor_id',$this->error_report_vendor_id);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('about_institute',$this->about_institute,true);
		$criteria->compare('course_offered',$this->course_offered,true);
		$criteria->compare('other_info',$this->other_info,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('suggestion',$this->suggestion,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}