<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseErrorReportTest is autogenerate by UniModel generator
 *
 * This is the model class for table "error_report_test".
 *
 * The followings are the available columns in table 'error_report_test':
 * @property integer $error_report_test_id
 * @property integer $entrace_exam_ref_id
 * @property string $about_test
 * @property string $dates_deadline
 * @property string $requirements
 * @property string $application_process
 * @property string $other_info
 * @property string $email_id
 * @property string $suggestion
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property EntranceExam $entraceExamRef
 * @property LoginMaster $addedBy
 */
class BaseErrorReportTest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ErrorReportTest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'error_report_test';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrace_exam_ref_id, added_on', 'required'),
			array('entrace_exam_ref_id', 'numerical', 'integerOnly'=>true),
			array('about_test, dates_deadline, requirements, application_process, other_info', 'length', 'max'=>1),
			array('email_id', 'length', 'max'=>100),
			array('suggestion', 'length', 'max'=>1000),
			array('added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('error_report_test_id, entrace_exam_ref_id, about_test, dates_deadline, requirements, application_process, other_info, email_id, suggestion, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entraceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrace_exam_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'error_report_test_id' => 'Error Report Test',
			'entrace_exam_ref_id' => 'Entrace Exam Ref',
			'about_test' => 'About Test',
			'dates_deadline' => 'Dates Deadlines',
			'requirements' => 'Requirements',
			'application_process' => 'Application Process',
			'other_info' => 'Other Info',
			'email_id' => 'Email',
			'suggestion' => 'Suggestion',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('error_report_test_id',$this->error_report_test_id);
		$criteria->compare('entrace_exam_ref_id',$this->entrace_exam_ref_id);
		$criteria->compare('about_test',$this->about_test,true);
		$criteria->compare('dates_deadline',$this->dates_deadline,true);
		$criteria->compare('requirements',$this->requirements,true);
		$criteria->compare('application_process',$this->application_process,true);
		$criteria->compare('other_info',$this->other_info,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('suggestion',$this->suggestion,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}