<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEoiRequestCollege is autogenerate by UniModel generator
 *
 * This is the model class for table "eoi_request_college".
 *
 * The followings are the available columns in table 'eoi_request_college':
 * @property string $eoi_request_college_id
 * @property string $di_user_eoi_log_ref_id
 * @property integer $uni_ref_id
 * @property string $added_on
 * @property string $user_ref_id
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property DiUserEoiLog $diUserEoiLogRef
 * @property TblUniversityMaster $uniRef
 */
class BaseEoiRequestCollege extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EoiRequestCollege the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'eoi_request_college';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_eoi_log_ref_id, uni_ref_id', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('di_user_eoi_log_ref_id, user_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('eoi_request_college_id, di_user_eoi_log_ref_id, uni_ref_id, added_on, user_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'diUserEoiLogRef' => array(self::BELONGS_TO, 'DiUserEoiLog', 'di_user_eoi_log_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'eoi_request_college_id' => 'Eoi Request College',
			'di_user_eoi_log_ref_id' => 'Di User Eoi Log Ref',
			'uni_ref_id' => 'Uni Ref',
			'added_on' => 'Added On',
			'user_ref_id' => 'User Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('eoi_request_college_id',$this->eoi_request_college_id,true);
		$criteria->compare('di_user_eoi_log_ref_id',$this->di_user_eoi_log_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}