<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailerKnowledgeTemplateMap is autogenerate by UniModel generator
 *
 * This is the model class for table "emailer_knowledge_template_map".
 *
 * The followings are the available columns in table 'emailer_knowledge_template_map':
 * @property integer $emailer_knowledge_template_map_id
 * @property integer $emailer_knowledge_template_ref_id
 * @property integer $country_ref_id
 * @property integer $department_ref_id
 * @property integer $week_number
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EmailerKnowledgeTemplate $emailerKnowledgeTemplateRef
 * @property TblCountryMaster $countryRef
 * @property LookupDepartment $departmentRef
 * @property EmailerKnowledgeTracker[] $emailerKnowledgeTrackers
 */
class BaseEmailerKnowledgeTemplateMap extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailerKnowledgeTemplateMap the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'emailer_knowledge_template_map';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('emailer_knowledge_template_ref_id, country_ref_id, department_ref_id, week_number, added_on', 'required'),
			array('emailer_knowledge_template_ref_id, country_ref_id, department_ref_id, week_number', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('emailer_knowledge_template_map_id, emailer_knowledge_template_ref_id, country_ref_id, department_ref_id, week_number, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailerKnowledgeTemplateRef' => array(self::BELONGS_TO, 'EmailerKnowledgeTemplate', 'emailer_knowledge_template_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'emailerKnowledgeTrackers' => array(self::HAS_MANY, 'EmailerKnowledgeTracker', 'emailer_knowledge_template_map_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'emailer_knowledge_template_map_id' => 'Emailer Knowledge Template Map',
			'emailer_knowledge_template_ref_id' => 'Emailer Knowledge Template Ref',
			'country_ref_id' => 'Country Ref',
			'department_ref_id' => 'Department Ref',
			'week_number' => 'Week Number',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('emailer_knowledge_template_map_id',$this->emailer_knowledge_template_map_id);
		$criteria->compare('emailer_knowledge_template_ref_id',$this->emailer_knowledge_template_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('week_number',$this->week_number);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}