<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailRecipient is autogenerate by UniModel generator
 *
 * This is the model class for table "email_recipient".
 *
 * The followings are the available columns in table 'email_recipient':
 * @property string $email_recipient_id
 * @property string $email_message_ref_id
 * @property string $email_type_response_ref_id
 * @property string $to_name
 * @property string $to_email
 * @property string $cc_email
 * @property string $user_id
 * @property string $status
 * @property string $unique_key
 * @property string $opened_on
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 * @property integer $is_helpful
 * @property string $feedback_comment
 *
 * The followings are the available model relations:
 * @property EmailMessage $emailMessageRef
 * @property EmailTypeResponse $emailTypeResponseRef
 */
class BaseEmailRecipient extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailRecipient the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_recipient';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_message_ref_id', 'required'),
			array('added_by, modified_by, is_helpful', 'numerical', 'integerOnly'=>true),
			array('email_message_ref_id, email_type_response_ref_id, user_id, status', 'length', 'max'=>10),
			array('to_name, to_email, cc_email', 'length', 'max'=>100),
			array('unique_key', 'length', 'max'=>60),
			array('opened_on, added_on, modified_on, feedback_comment', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_recipient_id, email_message_ref_id, email_type_response_ref_id, to_name, to_email, cc_email, user_id, status, unique_key, opened_on, added_by, added_on, modified_by, modified_on, is_helpful, feedback_comment', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailMessageRef' => array(self::BELONGS_TO, 'EmailMessage', 'email_message_ref_id'),
			'emailTypeResponseRef' => array(self::BELONGS_TO, 'EmailTypeResponse', 'email_type_response_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_recipient_id' => 'Email Recipient',
			'email_message_ref_id' => 'Email Message Ref',
			'email_type_response_ref_id' => 'Email Type Response Ref',
			'to_name' => 'To Name',
			'to_email' => 'To Email',
			'cc_email' => 'Cc Email',
			'user_id' => 'User',
			'status' => 'Status',
			'unique_key' => 'Unique Key',
			'opened_on' => 'Opened On',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
			'is_helpful' => 'Is Helpful',
			'feedback_comment' => 'Feedback Comment',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_recipient_id',$this->email_recipient_id,true);
		$criteria->compare('email_message_ref_id',$this->email_message_ref_id,true);
		$criteria->compare('email_type_response_ref_id',$this->email_type_response_ref_id,true);
		$criteria->compare('to_name',$this->to_name,true);
		$criteria->compare('to_email',$this->to_email,true);
		$criteria->compare('cc_email',$this->cc_email,true);
		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('unique_key',$this->unique_key,true);
		$criteria->compare('opened_on',$this->opened_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('is_helpful',$this->is_helpful);
		$criteria->compare('feedback_comment',$this->feedback_comment,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}