<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserEoiScholarshipLog is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_eoi_scholarship_log".
 *
 * The followings are the available columns in table 'di_user_eoi_scholarship_log':
 * @property string $di_user_eoi_scholarship_log_id
 * @property string $di_user_eoi_log_ref_id
 * @property string $scholarship_ref_id
 * @property string $scholarship_chance
 * @property string $scholarship_description
 * @property string $scholarship_name
 * @property string $amount
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property DiUserEoiLog $diUserEoiLogRef
 * @property Scholarship $scholarshipRef
 */
class BaseDiUserEoiScholarshipLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserEoiScholarshipLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_eoi_scholarship_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on, added_by', 'required'),
			array('di_user_eoi_log_ref_id, scholarship_ref_id, amount, added_by', 'length', 'max'=>10),
			array('scholarship_chance', 'length', 'max'=>14),
			array('scholarship_name', 'length', 'max'=>255),
			array('scholarship_description', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_eoi_scholarship_log_id, di_user_eoi_log_ref_id, scholarship_ref_id, scholarship_chance, scholarship_description, scholarship_name, amount, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'diUserEoiLogRef' => array(self::BELONGS_TO, 'DiUserEoiLog', 'di_user_eoi_log_ref_id'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_eoi_scholarship_log_id' => 'Di User Eoi Scholarship Log',
			'di_user_eoi_log_ref_id' => 'Di User Eoi Log Ref',
			'scholarship_ref_id' => 'Scholarship Ref',
			'scholarship_chance' => 'Scholarship Chance',
			'scholarship_description' => 'Scholarship Description',
			'scholarship_name' => 'Scholarship Name',
			'amount' => 'Amount',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_eoi_scholarship_log_id',$this->di_user_eoi_scholarship_log_id,true);
		$criteria->compare('di_user_eoi_log_ref_id',$this->di_user_eoi_log_ref_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('scholarship_chance',$this->scholarship_chance,true);
		$criteria->compare('scholarship_description',$this->scholarship_description,true);
		$criteria->compare('scholarship_name',$this->scholarship_name,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}