<?php

/**
 * This is the model class for table "student_preferred_study_level".
 *
 * The followings are the available columns in table 'student_preferred_study_level':
 * @property string $preferred_study_level_id
 * @property string $user_ref_id
 * @property integer $course_level_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupCourseLevel $courseLevelRef
 */
class StudentPreferredStudyLevel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredStudyLevel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_study_level';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('course_level_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_study_level_id, user_ref_id, course_level_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'courseLevelRef' => array(self::BELONGS_TO, 'LookupCourseLevel', 'course_level_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_study_level_id' => 'Preferred Study Level',
			'user_ref_id' => 'User Ref',
			'course_level_ref_id' => 'Course Level Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_study_level_id',$this->preferred_study_level_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('course_level_ref_id',$this->course_level_ref_id);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    public static function deleteStudentPreferences($userId=0){
        $model = self::model()->deleteAll(array("condition" => "user_ref_id = '$userId'"));
    }

    public static function addStudentPreferences($userId=0, $courseLevelId = array()){

        for($i=0; $i<count($courseLevelId); $i++){
            if($courseLevelId[$i] != ''){
                $model = new StudentPreferredStudyLevel();
                $model->user_ref_id = $userId;
                $model->course_level_ref_id = $courseLevelId[$i];
                $model->added_on = date('Y-m-d H:i:s');
                $model->save(false);
            }
        }
    }
    
    public static function getStudentPreferredStudyLevel(){
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
        $studentPreferredStudyLevel = StudentPreferredStudyLevel::model()->find($criteria);
        return $studentPreferredStudyLevel;
    }
    
    public static function getStudentPreferredStudyLevelByUserId($userId){
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$userId."'";
        $studentPreferredStudyLevel = StudentPreferredStudyLevel::model()->find($criteria);
        return $studentPreferredStudyLevel;
    }     
    
    public function deletePreferredStudyLevelUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        self::model()->deleteAll($criteria);
    }
    
    public function insertPreferredStudyLevelByUserId($userId, $studyLevel) {
        $obj = new StudentPreferredStudyLevel();
        $obj->{user_ref_id} = $userId;
        $obj->{course_level_ref_id} = $studyLevel;
        $obj->save();
    }
     public static function getStudyLevelsByUserId($userId){
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$userId."'";
        $criteria->limit = 2;
        $studentPreferredStudyLevel = StudentPreferredStudyLevel::model()->findAll($criteria);
        return $studentPreferredStudyLevel;
    }  
}