<?php

/**
 * This is the model class for table "student_overall_percent".
 *
 * The followings are the available columns in table 'student_overall_percent':
 * @property string $student_overall_percent_id
 * @property string $student_ref_id
 * @property double $overall_12
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $studentRef
 */
class StudentOverallPercent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentOverallPercent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_overall_percent';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_ref_id, overall_12, added_on', 'required'),
			array('overall_12', 'numerical'),
			array('student_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_overall_percent_id, student_ref_id, overall_12, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_overall_percent_id' => 'Student Overall Percent',
			'student_ref_id' => 'Student Ref',
			'overall_12' => 'Overall 12',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_overall_percent_id',$this->student_overall_percent_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('overall_12',$this->overall_12);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}