<?php


/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentAlternateEmail');

class StudentAlternateEmail extends BaseStudentAlternateEmail
{
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return
            array(
                array('login_ref_id', 'required'),
                array('contact_type_ref_id, is_active, is_primary', 'numerical', 'integerOnly' => true),
                array('login_ref_id, added_by, modified_by', 'length', 'max' => 10),
                array('email_id', 'length', 'max' => 100),
                array('modified_on', 'safe'),
                // The following rule is used by search().
                // Please remove those attributes that should not be searched.
                array('student_alternate_email_id, login_ref_id, contact_type_ref_id, email_id, added_on, added_by, modified_on, modified_by, is_active, is_primary', 'safe', 'on' => 'search'),

                array('email_id', 'required', 'message' => '<div class="holder"><p>Please enter email address</p></div>', 'on' => 'Settings'),
                array('email_id', 'email', 'message' => '<div class="holder"><p>Please enter valid email</p></div>', 'on' => 'Settings'),
                array('email_id', 'length', 'max' => 100, 'on' => 'Settings'),
                array('email_id', 'validateIfExists', 'message' => '<div class="holder"><p>You have already added this email</p></div>', 'on' => 'Settings'),
            );
    }


    public function validateIfExists()
    {

        $criteria = new CDbCriteria;
        $criteria->addCondition("login_ref_id = '" . Yii::app()->user->id . "'", "AND");
        $criteria->addCondition("email_id = '" . $this->email_id . "'", "AND");
        $criteria->addCondition("is_active = 1 ", "AND");
        $res = self::model()->find($criteria);
        if ($res) {
            $this->addError('email_id', '<div class="holder"><p>You have already added this email.</p></div>');
        }

        $sql = "select * from login_master where login_id ='".Yii::app()->user->id."' and username like '".$this->email_id."'";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        if($result){
            $this->addError('email_id', '<div class="holder"><p>You have already added this email.</p></div>');
        }
    }
    

    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'email_id' => 'personal_information',
        );
    }
    
    
    public static function storeUserContactInfo($attributes = array())
    {
        $model = new StudentAlternateEmail();
        $model->attributes = $attributes;
        $model->save(false);
        /*$model = self::model()->findByAttributes(array('login_ref_id' => $loginRefId, 'email_id' => $email));
        $emailInfo = array('login_ref_id' => $loginRefId, 'contact_type_ref_id' => $contactType, 'email_id' => $email,
            'is_active' => 1);
        if (!$model) {
            $model = new StudentAlternateEmail();
            $emailInfo['added_by'] = $loginId;
            $emailInfo['added_on'] = date('Y-m-d H:i:s');
        } else {
            $emailInfo['modified_by'] = $loginId;
            $emailInfo['modified_on'] = date('Y-m-d H:i:s');
        }
        $model->attributes = $emailInfo;
        $model->save();*/
        /*$model = new StudentAlternateEmail;
        $model->login_ref_id = $loginRefId;
        $model->contact_type_ref_id = $contactType;
        $model->email_id = $email;
        $model->added_by = $loginId;
        $model->added_on = date('Y-m-d H:i:s');*/
    }

    //TODO: #994 removed mother_email' field
    public static function getMotherEmail($LoginId = false)
    {
        $criteria = new CDbCriteria;
        $criteria->select = "email_id";
        $criteria->condition = "login_ref_id = '" . $LoginId . "'";
        $criteria->addCondition("contact_type_ref_id = 3");
        $res = self::model()->find($criteria);
        return $res->attributes['email_id'];
    }

    public static function getGuardEmail($LoginId = false)
    {
        $criteria = new CDbCriteria;
        $criteria->select = "email_id";
        $criteria->condition = "login_ref_id = '" . $LoginId . "'";
        $criteria->addCondition("contact_type_ref_id = 4");
        $res = self::model()->find($criteria);
        return $res->attributes['email_id'];
    }

    public static function getFatherEmail($LoginId = false)
    {
        $criteria = new CDbCriteria;
        $criteria->select = "email_id";
        $criteria->condition = "login_ref_id = '" . $LoginId . "'";
        $criteria->addCondition("contact_type_ref_id = 2");
        $res = self::model()->find($criteria);
        return $res->attributes['email_id'];
    }

    //TODO: #994 removed mother_email' field
    public static function getcontactEmailId($LoginId, $ContactType = false)
    {
        $criteria = new CDbCriteria;
        $criteria->select = "email_id";
        //$criteria->condition = "login_ref_id = '" . $LoginId . "'";
        //$criteria->addCondition = "contact_type_ref_id = 1";
        $criteria->condition = "login_ref_id = '" . $LoginId . "'";
        $criteria->addCondition("contact_type_ref_id = 1");        
        $res = self::model()->find($criteria);
        return $res->attributes['email_id'];
        //return $res[0]['email_id'];
    }

    public static function deleteAlternateEmail($loginRefId = 0, $contactTypeRefId = 0, $otherFields = array())
    {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("login_ref_id = '" . $loginRefId . "'", "AND");
        if ($contactTypeRefId > 0) {
            $cdbCriteria->addCondition("contact_type_ref_id = '" . $contactTypeRefId . "'", "AND");
        }
        if (count($otherFields) > 0) {
            foreach ($otherFields as $fieldAttributes) {
                $cdbCriteria->addCondition($fieldAttributes['field'], $fieldAttributes['condition']);
            }
        }
        //self::model()->deleteAll(array("condition" => "login_ref_id = '".$loginRefId."' AND contact_type_ref_id = '".$contactTypeRefId."' AND is_primary IS ".$isPrimary));
        self::model()->deleteAll($cdbCriteria);
    }

    public static function addAlternameEmail($loginRefId = 0, $contactTypeRefId = 0, $email = '', $addedBy = 0, $isPrimary = false, $isActive = false)
    {
        $studentAlternateEmail = new StudentAlternateEmail();
        $studentAlternateEmail->login_ref_id = $loginRefId;
        $studentAlternateEmail->contact_type_ref_id = $contactTypeRefId;
        $studentAlternateEmail->email_id = $email;
        $studentAlternateEmail->is_active = $isActive;
        $studentAlternateEmail->is_primary = $isPrimary;
        $studentAlternateEmail->added_on = date('Y-m-d H:i:s');
        $studentAlternateEmail->addedBy = $addedBy;
        $studentAlternateEmail->save(false);
    }

    public function getStudentAlternateEmail($login_id)
    {
        $return = array();
        if ($login_id) {
            $criteria = new CDbCriteria;
            $criteria->select = 'student_alternate_email_id, email_id, is_active, is_confirmed';
            $criteria->condition = "login_ref_id = " . $login_id . " and contact_type_ref_id = 1 and is_active = 1 ";
            $return = self::model()->find($criteria);
        }
        return $return;
    }

    public function getIdForEmail($email, $id = false)
    {
        if ($email) {
            $criteria = new CDbCriteria;
            $criteria->select = "student_alternate_email_id";
            $criteria->addCondition("email_id = '" . $email . "'", "AND");
            if ($id) {
                $criteria->addCondition("login_ref_id = '" . $id . "'", "AND");
            }
            $res = self::model()->find($criteria);
            return $res->student_alternate_email_id;
        }
    }

    protected function beforeSave()
    {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->added_on = date('Y-m-d H:i:s');
            } else {
                $this->modified_on = date('Y-m-d H:i:s');
            }
            return true;

        }
        return false;
    }
    
    public static function getEmailsOfParent($LoginId,$ContactType = false) {
        $criteria = new CDbCriteria;
        $criteria->select = 'email_id,contact_type_ref_id';
        $criteria->with = 'contactTypeRef';
        $criteria->addCondition("login_ref_id = '".$LoginId."'");
        $criteria->addCondition("contact_type_ref_id = '".$ContactType."'");
        $criteria->limit = 2;
        $res = self::model()->findAll($criteria);
        return $res;
    }

     public static function validateDuplicateEmail($loginId, $emailId, $parentId)
    {
        $criteria = new CDbCriteria;
        $criteria->addCondition("login_ref_id = '" . $loginId . "'", "AND");
        $criteria->addCondition("email_id = '" . $emailId . "'", "AND");
        $criteria->addCondition("contact_type_ref_id != '" . $parentId . "'", "AND");
        //$criteria->addCondition("is_active = 1 ", "AND");
        $res = self::model()->find($criteria);
        return $res;
    }

    public function findByEmail($email=false)
    {
        $result = self::model()->find('email_id=:key', array(':key' => $email));

        if($result)
        {
            return $result;
        }
        else
        {
            return false;
        }

    }

    public static function getAllParentEmails($loginRefId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.contact_type_ref_id != 1", "AND");
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->addCondition("t.login_ref_id = '$loginRefId'", "AND");
        $result = self::model()->with('contactTypeRef')->findAll($cdbCriteria);
        return $result;
    }

    public static function getAllEmailsByType($loginRefId=0, $contactType=1){
        $sql = "SELECT GROUP_CONCAT(email_id) AS email_id FROM student_alternate_email WHERE login_ref_id = '".$loginRefId."' AND contact_type_ref_id = ".$contactType."";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        return @$result[0]['email_id'];
    }

    public static function getFatherEmails($loginRefId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.contact_type_ref_id = 2", "AND");
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->addCondition("t.login_ref_id = '$loginRefId'", "AND");
        $result = self::model()->with('contactTypeRef')->findAll($cdbCriteria);
        return $result;
    }

    public static function getMotherEmails($loginRefId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.contact_type_ref_id = 3", "AND");
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->addCondition("t.login_ref_id = '$loginRefId'", "AND");
        $result = self::model()->with('contactTypeRef')->findAll($cdbCriteria);
        return $result;
    }

    public static function getGuardianEmails($loginRefId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.contact_type_ref_id = 4", "AND");
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->addCondition("t.login_ref_id = '$loginRefId'", "AND");
        $result = self::model()->with('contactTypeRef')->findAll($cdbCriteria);
        return $result;
    }


}