<?php

/*
 * @author Shastry Chamarthi
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupUrl');

class LookupUrl extends BaseLookupUrl
{
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    /*
     * This function will get the url based on the given class_level and model in asc order
     */
    public static function getUrlByModel($params = array(), $limit = 0){
        //$model='', $class_level=0, $label='', $limit = 0
        $urlDetails = array();
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = "url_id, url";
        if(isset($params)){
            foreach($params as $field => $fieldValue){
                //$cdbCriteria->compare($field, $fieldValue);
                $cdbCriteria->addCondition("$field = '$fieldValue'", "AND");
            }
        }
        $cdbCriteria->order = "redirect_order";

        if($limit > 0){
            $cdbCriteria->limit = $limit;
        }

        $result = self::model()->findAll($cdbCriteria);

        foreach($result as $value){
            //print_r($value->attributes);
            $urlDetails[] = array('url_id' => $value->attributes['url_id'], 'url' => $value->attributes['url']);
        }
        return $urlDetails;
    }
    
    // For 12c,12p and 11p students consider 'class_level as 12' 
    public static function getRedirectUrlId($membershipId) {
        
        $criteria = new CDbCriteria;
        if($membershipId == 2) {
            $criteria->addCondition("class_level = 12", "AND");
            $criteria->addCondition("model_name = 'profile'", "AND");
        }
        elseif($membershipId != 2) {
            $criteria->addCondition("class_level = 0", "AND");
            $criteria->addCondition("model_name = 'signup'", "AND");
        }        
        $criteria->addCondition("type_of_field = 'critical'", "AND");
        $criteria->order = "redirect_order";
        $criteria->limit = 1;
        
        $res = self::model()->find($criteria);
        return $res->attributes['url_id'];;
    }
    
    public static function getRedirectAllUrls($class=9, $fieldType='recommended') {
        $criteria = new CDbCriteria;
        $criteria->select = 'url_id, label';
        $criteria->addCondition("type_of_field = '".$fieldType."'", "AND");
        $criteria->addCondition("class_level = '".$class."'", "AND");
        $criteria->order = "redirect_order desc";
        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getUrl($urlId=0){
        $result = self::model()->findByPk($urlId);
        return $result->attributes['url'];
    }
    
    public static function getB2CTabUrl() {
        $criteria = new CDbCriteria;
        $criteria->select = 'url_id, label, url, redirect_order';
        $criteria->addInCondition("url_id", array(29,30,31,105));
        $criteria->order = "redirect_order desc";
        $res = self::model()->findAll($criteria);
        return $res;
    }
    
    public static function getB2BTabUrl() {
        $criteria = new CDbCriteria;
        $criteria->select = 'url_id, label, url, redirect_order';
        $criteria->addInCondition("url_id", array(100,101,102,103,104,105));
        $criteria->order = "redirect_order desc";
        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getB2B10TabUrl() {
        $criteria = new CDbCriteria;
        $criteria->select = 'url_id, label, url, redirect_order';
        $criteria->addInCondition("url_id", array(106,107,108,109,110));
        $criteria->addCondition("class_level = 9", "AND");
        $criteria->order = "redirect_order desc";
        $res = self::model()->findAll($criteria);
        return $res;
    }
    
}