<?php

/**
 * This is the model class for table "lookup_courselevel_class".
 *
 * The followings are the available columns in table 'lookup_courselevel_class':
 * @property string $class
 * @property integer $course_level_ref_id
 *
 * The followings are the available model relations:
 * @property LookupCourseLevel $courseLevelRef
 */
class LookupCourselevelClass extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCourselevelClass the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_courselevel_class';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('class, course_level_ref_id', 'required'),
			array('course_level_ref_id', 'numerical', 'integerOnly'=>true),
			array('class', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('class, course_level_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseLevelRef' => array(self::BELONGS_TO, 'LookupCourseLevel', 'course_level_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'class' => 'Class',
			'course_level_ref_id' => 'Course Level Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('class',$this->class,true);
		$criteria->compare('course_level_ref_id',$this->course_level_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}