<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseEmailMessage');

class EmailMessage extends BaseEmailMessage
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  /*
   *  This method take an array of parameters
   *  Madatory params are $subject, $body, $toName,  $toEmail, $type
   *  Optional params are $cc, $type, $siteUrl, $campaignName.
   *  $siteUrl is used to generate the absolute urllinks in emails. 
   */
//   public function addEmailMessage($subject, $body, $to, $cc=null, $siteUrl='http://www.univariety.com/apps/index.php', $type='rsvp' )
  public function addEmailMessage($params)
  {
  	extract($params);
 	if(!isset($siteUrl))
  	{
  	  //$siteUrl='http://www.univariety.com/apps/index.php';
	  //$siteUrl='https://www.univariety.com/demo/app/index.php';
	  $siteURL =  CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');
  	}
	
	
  	if(!isset($type) && empty($type))
  	{
  	  $type = 'rsvp';
  	}	
  	
  	$emailType     = EmailType::model()->getEmailTypeByKey($type);
  	

  	try
  	{	 
  	  if(isset($campaignName))
  	  {	
  	    $campaign       = new EmailCampaign;
  	    $campaign->name = $campaignName;
  	    $campaign->email_type_ref_id = $emailType->email_type_id;
  	    $campaign->save(false);
  	    
  	    // set the campaign on EmailMessage object
  	    $this->email_campaign_ref_id = $campaign->email_campaign_id;
   	  }
	  $emailmessage = new EmailMessage;
  	  $emailmessage->subject = $subject;
  	  $emailmessage->body    = $body;
      $emailmessage->email_type_ref_id = $emailType->email_type_id; 
 	  $emailmessage->save(false);
	  
 	  $receipient = new EmailRecipient;
  	  $receipient->to_email = $toEmail;
  	  $receipient->to_name = $toName;
	  $receipient->added_on = date('Y-m-d h:i:s');
  	  if($cc)
  	  {	
  	    $receipient->cc_email = $cc;
  	  }
  	  if($status){
          $receipient->status = 'success';
      }
  	  $receipient->email_message_ref_id = $emailmessage->email_message_id;
  	  $receipient->save(false);
  	  
  	  // Generate the unique email key based on the PK and save it
  	  $uniqueKey = sha1($receipient->email_recipient_id.strtotime('now'));
  	  $receipient->unique_key = $uniqueKey;
  	 
  	  $receipient->update();
  	  
  	  // add attachments to email if attchments array presents in the params array
  	  if(!empty($attachments))
	  {
  	    foreach($attachments as $attachment)
  	    {
  	  	  $emailAttachment            = new EmailAttachment;
  	  	  $emailAttachment->file_name = $attachment['name'];
  	  	  $emailAttachment->file_path = $attachment['path'];
          if(@$_SERVER['HTTP_HOST'] != ''){
              if(isset(Yii::app()->user->id) && (Yii::app()->user->id>0)){
                  $emailAttachment->added_by = Yii::app()->user->id;
              }
          }else{
              $emailAttachment->added_by = null;
          }
          $emailAttachment->email_message_ref_id = $emailmessage->email_message_id;
          $emailAttachment->save(false);
		}  	  	
  	  }	
  	  
  	  if(!empty($params['csiteUrl']))
        $siteUrl = $params['csiteUrl'].'/app';
		
  	  // generate the links and replace them in the body
  	  $browserLink   = '<a href="'.$siteUrl.'/sms/email/browser?k='.$uniqueKey.'"> Open this in browser</a>';
  	  //$beaconLink    = '<img alt="" title="" src="'.$siteUrl.'/sms/email/imageview?k='.$uniqueKey.'">';
	  $beaconLink    = '';
  	  $unsubscribeLink   = '<a id="unsubscribe-link" href="'.$siteUrl.'/sms/email/unsubscribe?email='.$receipient->to_email.'">Unsubscribe</a>';
  	  $unsubscribeLink  = 'If you don\'t want to receive these emails from Univariety in the future, please click: '.$unsubscribeLink;
  	  $rsvpLink     = $siteUrl.'/sms/email/response?k='.$uniqueKey;
  	   
  	  $feedbackLinks = 'Is this helpful? <a class="feedback-link" href="'.$siteUrl.'/sms/email/helpful?k='.$uniqueKey.'&res=1">Yes</a> | ';
  	  $feedbackLinks .= '<a class="feedback-link" href="'.$siteUrl.'/sms/email/helpful?k='.$uniqueKey.'&res=0">No</a> ';
  	  
  	  if('Rsvp' == $type)
  	  {
  	  	$rsvpLinks = $this->generateResponseLinks($emailType, $rsvpLink);
  	  	$body = str_replace('{{response-links}}', $rsvpLinks, $body);
  	  }
  	  	  
  	  // replace the place holders with the right links in the mail body
  	  
  	  $body = str_replace('{{browser-link}}', $browserLink, $body);
  	  $body = str_replace('{{beacon}}', $beaconLink, $body);
  	  $body = str_replace('{{feedback-links}}', $feedbackLinks, $body);
  	  
  	  if('system' != strtolower($emailType->category))
  	  {	
  	    $body = str_replace('{{unsubscribe-link}}', $unsubscribeLink, $body);
  	  }
  	  else
  	  {
  	  	//$body = str_replace('{{unsubscribe-link}}', '&nbsp', $body);
		$body = str_replace('{{unsubscribe-link}}', '', $body);
  	  }
  	  
  	  $emailmessage->body = $body;
  	  $emailmessage->update();
  	  
  	}
  	catch(Exception $e)
  	{
  	  echo $e->getMessage();	
  	}
  	
  	return $receipient->email_recipient_id;
  }

  
    /*
     * Generated the rsvp response links based on the rsvp responses
     */
  	public function generateResponseLinks($emailType, $responseUrl)
  	{
  	  $links ='';

  	  foreach($emailType->emailTypeResponses as $response)
  	  {
  		$links .= '<a class="response-link" href="'. $responseUrl.'&res='.$response->value.'">'.$response->value.'</a><br>';
  	  }

  	  return $links;
  	}
  	
  
  
  
}