<?php

/**
 * UniversityHelper class file.
 * @author Gaurav Porwal <gaurav.porwal@tekritisoftware.com>
 *
 */
class UniversityHelper {

    static $ObjUserManager, $siteURL, $subDomainSlugName;

    public static function getUniversityUrl($uni_id, $byUniHash = 0) {
//        if ($byUniHash) {
//            $uniUrldata = TblUniversityMaster::getUniIdFromHash($uni_id);
//            if ($uniUrldata['uni_id'] != '') {
//                $uni_id = $uniUrldata['uni_id'];
//            } else {
//                return false;
//            }
//        }

        $data = TblUniversityMaster::getUniversityUrlData($uni_id, $byUniHash);

        if ($data['keyword'] != '') {
            $keyword = $data['keyword'];
        } else { // if seo_keword is missing in database give some static value
            $keyword = 'keyword';
        }

        if ($data['department_name'] != '') {
            $topDept = self::removeUrlJunkChar(html_entity_decode($data['department_name'])); // replace special character
        } else { // if department is missing in database give some static value
            $topDept = "department";
        }

        $seoText = self::removeUrlJunkChar(html_entity_decode($data['uni_name'])); // replace special character
        $url = Yii::app()->urlManager->createUrl('university/profile/index', array(
            //'keyword' => $data['keyword'],
            //'countryName' => $data['country_code'],
            //'deptName' => $topDept,
            'seoText' => $seoText,
            'universityId' => $data['url_primary_key']
                ));
	$url = preg_replace('/\/app/', '', $url);

        return $url;
    }
	
	public static function getUniversityDiscussionUrl($uni_id, $byUniHash = 0) {
        $data = TblUniversityMaster::getUniversityUrlData($uni_id, $byUniHash);  

        $seoText = self::removeUrlJunkChar(html_entity_decode($data['uni_name'])); // replace special character
        $url = Yii::app()->urlManager->createUrl('university/profile/discussion', array(
            //'keyword' => $data['keyword'],
            //'countryName' => $data['country_code'],
            //'deptName' => $topDept,
            'seoText' => $seoText,
            'universityId' => $data['url_primary_key']
                ));
			$url = preg_replace('/\/app/', '', $url);

        return $url;
    }
	
	
    public static function getCourseUrl($course_id, $byCourseHash = 0) {
        //'course/<keyword:[\w\-]+>/<countryName:[\w\-]+>/<uniName:[\w\-]+>/<deptName:[\w\-]+>/<seoText:[\w\-]+>/<courseId:[\w\-]+>' => 'university/course/index',

        $data = TblUniCourses::getCourseUrlData($course_id, $byCourseHash);

        if ($data['keyword'] != '') {
            $keyword = $data['keyword'];
        } else { // if seo_keword is missing in database give some static value
            $keyword = 'keyword';
        }

        if ($data['department_name'] != '') {
            $topDept = self::removeUrlJunkChar(html_entity_decode($data['department_name'])); // replace special character
        } else { // if department is missing in database give some static value
            $topDept = "department";
        }

        $seoTextUni = self::removeUrlJunkChar(html_entity_decode($data['uni_name'])); // replace special character

        $seoTextCourse = self::removeUrlJunkChar(html_entity_decode($data['course_name'])); // replace special character

        $url = Yii::app()->urlManager->createUrl('university/course/index', array(
            'keyword' => $data['keyword'],
            'countryName' => $data['country_code'],
            'uniName' => $seoTextUni,
            'deptName' => $topDept,
            'seoText' => $seoTextCourse,
            'courseId' => $data['course_id']
                ));

        return $url;
    }

    public static function getTestUrl($entrance_id, $byTestHash = 0) {

        $data = EntranceExam::getTestUrlData($entrance_id, $byTestHash);

        if ($data['keyword'] != '') {
            $keyword = $data['keyword'];
        } else { // if seo_keword is missing in database give some static value
            $keyword = 'keyword';
        }

        $seoText = self::removeUrlJunkChar(html_entity_decode($data['entrance_full_name'])); // replace special character

        $url = Yii::app()->urlManager->createUrl('test/index/index', array(
            //  'keyword' => $data['keyword'],
            'seoText' => $seoText,
            'testId' => $data['url_primary_key']
        ));

        $url = preg_replace('/\/app/', '', $url);

        return $url;
    }


    public static function removeUrlJunkChar($str) {
        $junkChar = array("'", "&", ",", "$", "+", ",", "/", ":", "=", "?", "@", ".", "(", ")", "[", "]", "*", "&nbsp;", "&amp;", "%A0", "\r\n", "\n", "%");
        //$str = str_replace($junkChar, "", $str); // replace special character
        $str = str_replace($junkChar, "", html_entity_decode($str)); // replace special character
        $str = str_replace(" ", "-", $str); // replace space with hyphen
        $str = str_replace("--", "-", $str); // replace double hyphen with single hyphen      
        $str = str_replace("–", "-", $str); // replace special hyphen with single hyphen
        return $str;
    }

    public static function getNumberSuffix($num) {
        if (!in_array(($num % 100), array(11, 12, 13))) {
            switch ($num % 10) {
                // Handle 1st, 2nd, 3rd
                case 1: return 'st';
                case 2: return 'nd';
                case 3: return 'rd';
            }
        }
        return 'th';
    }
    
    public static function InsertMessagedata($params) {       
        $url = EmailMessage::addEmailMessage($params);         
    }    
    

   
    public static function getScholarshipUrl($scholarship_id, $byScholarshipHash = 0) {
//        if ($byScholarshipHash) {
//            $scholarshipUrldata = Scholarship::getScholarshipIdFromHash($scholarship_id);
//            if ($scholarshipUrldata['scholarship_id'] != '') {
//                $scholarship_id = $scholarshipUrldata['scholarship_id'];
//            } else {
//                return false;
//            }
//        }

        $data = Scholarship::getScholarshipUrlData($scholarship_id, $byScholarshipHash);

        if ($data['seo_keyword'] != '') {
            $keyword = $data['seo_keyword'];
        } else { // if seo_keword is missing in database give some static value
            $keyword = 'keyword';
        }

        $seoText = self::removeUrlJunkChar(html_entity_decode($data['scholarship_name'])); // replace special character

        $url = Yii::app()->urlManager->createUrl('scholarshipprofile/scholarshipsearch/index', array(
          //  'keyword' => $keyword,
            'seoText' => $seoText,
            'scholarshipId' => $data['url_primary_key']
                ));
        $url = preg_replace('/\/app/', '', $url);
     
        return $url;
    }
    
    public static function getCareerPageUrl($career_id, $byCareerHash = 0) {

        $data = LookupCareer::getCareerUrlData($career_id, $byCareerHash);
        $seoText = self::removeUrlJunkChar(html_entity_decode($data['career_name'])); // replace special character

        $url = Yii::app()->urlManager->createUrl('studentcareer/careerpage/index', array(
            'seoText' => $seoText,
            'careerId' => $data['url_primary_key'],
                ));
	$url = preg_replace('/\/app/', '', $url);
        return $url;
    }

    public static function getFaqUrl($question_id) {

	Yii::import('application.questions.models.*');
        $data = TblQuestions::model()->findByPk($question_id);
	$que = strip_tags($data['question']);
	$que = preg_replace('/[^A-Za-z0-9 ]/','',$que);
        $seoText = str_replace(" ", "-", $que); // replace space with hyphen

        $url = Yii::app()->urlManager->createUrl('questions/faq/viewQuestion', array(
            'seoText' => $seoText,
            'questionId' => $data['question_id'],
            ));
	$url = preg_replace('/\/app/', '', $url);
        return $url;
    }

    public static function contentCleaner($str) {
        // espacially created to remove &nbsp special charcter
        $junkCharContent = array("&nbsp;");
        $str = html_entity_decode(str_replace($junkCharContent, " ", $str));
        return $str;
    }
    

    //gets the data from a URL  
    public static function get_tiny_url($url)  {  
	$ch = curl_init();  
	$timeout = 5;  
	curl_setopt($ch,CURLOPT_URL,'http://tinyurl.com/api-create.php?url='.$url);  
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);  
	curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);  
	$data = curl_exec($ch);  
	curl_close($ch);  
	return $data;  
}

    public static function format_currency($num){

        $pos = strpos((string)$num, ".");
        if ($pos === false)
            $decimalpart="00";

        if (!($pos === false)){
            $decimalpart= substr($num, $pos+1, 2);
            $num = substr($num,0,$pos);
        }

        if(strlen($num)>3 & strlen($num) <= 12){
            $last3digits = substr($num, -3 );
            $numexceptlastdigits = substr($num, 0, -3 );
            $formatted = self::makeComma($numexceptlastdigits);
            $stringtoreturn = $formatted.",".$last3digits ;
        }elseif(strlen($num)<=3)
            $stringtoreturn = $num ;
        elseif(strlen($num)>12)
            $stringtoreturn = number_format($num, 2);

        if(substr($stringtoreturn,0,2)=="-,")
            $stringtoreturn = "-".substr($stringtoreturn,2 );

        return $stringtoreturn;
    }

    public function makeComma($input){

        if(strlen($input)<=2)
            return $input;

        $length=substr($input,0,strlen($input)-2);
        $formatted_input = self::makeComma($length).",".substr($input,-2);

        return $formatted_input;
    }
    public function displayAdmissionChance($score,$onlyPercentage=false) {

        if($onlyPercentage)
            $notAvailable = '0%';
        else
            $notAvailable = 'Not available';

        if($score === 'N/A')
            return 'N/A';

        $score = (int) $score;

		if ($score > 110) {
            $displayArr = array('lr' => '>95%', 'hr' => '', 'text' => ' Very High', 'class' => 'green color-green');
        } elseif ($score >= 99 && $score <= 110) {
            $displayArr = array('lr' => '75% - ', 'hr' => '95% ', 'text' => 'High', 'class' => 'green color-green');
        } elseif ($score >= 95 && $score < 99) {
            $displayArr = array('lr' => '50% - ', 'hr' => '75% ', 'text' => 'Medium-High', 'class' => 'orange color-orange');
        } elseif ($score >= 81 && $score < 95) {
            $displayArr = array('lr' => '20% - ', 'hr' => '50% ', 'text' => 'Low-Medium', 'class' => 'orange color-orange');
        }  elseif ($score >= 1 && $score <= 80) {
            $displayArr = array('lr' => '<20%', 'hr' => '', 'text' => ' Low', 'class' => 'red color-pink');
        } else{
            $displayArr = array('lr' => $notAvailable, 'hr' => '', 'text' => '', 'class' => '');
        }
		if($onlyPercentage) return  $displayArr['lr']; // return only percentage if required
		
        return "<strong class='{$displayArr['class']}'> {$displayArr['lr']} {$displayArr['hr']}</strong><span>{$displayArr['text']}</span>";
    }

    public function displayAdmissionChances($score,$onlyPercentage=false) {

        if($onlyPercentage)
            $notAvailable = '0%';
        else
            $notAvailable = 'Not available';

        if($score === 'N/A')
            return 'N/A';

        $score = (int) $score;

        if ($score > 110) {
            $displayArr = array('lr' => '>95%', 'hr' => '', 'text' => ' HIGH', 'class' => 'color-green');
        } elseif ($score >= 99 && $score <= 110) {
            $displayArr = array('lr' => '75% - ', 'hr' => '95% ', 'text' => 'HIGH', 'class' => 'color-green');
        } elseif ($score >= 95 && $score < 99) {
            $displayArr = array('lr' => '50% - ', 'hr' => '75% ', 'text' => 'MEDIUM', 'class' => 'color-orange');
        } elseif ($score >= 81 && $score < 95) {
            $displayArr = array('lr' => '20% - ', 'hr' => '50% ', 'text' => 'LESS', 'class' => 'color-orange');
        }  elseif ($score >= 1 && $score <= 80) {
            $displayArr = array('lr' => '<20%', 'hr' => '', 'text' => ' LESS', 'class' => 'color-pink');
        } else{
            $displayArr = array('lr' => $notAvailable, 'hr' => '', 'text' => '', 'class' => '');
        }
        if($onlyPercentage) return  $displayArr['lr']; // return only percentage if required

        return "<strong class='{$displayArr['class']}'> {$displayArr['lr']} {$displayArr['hr']}</strong><div class='color-gray'><span>{$displayArr['text']}</span></div>";
    }




    public function chopString($str, $length = 45) {
        if(strlen($str) <= $length || strlen($str) <= $length + 3 ){
            return $str;
        } else {
            return substr($str, 0, $length)."...";
        }
    }

    public function isDisplayTitle($str, $length = 45) {
        if(strlen($str) <= $length || strlen($str) <= $length + 3 ){
            return false;
        } else {
            return true;
        }
    }
 
    public function displayAdmissionChanceShortList($score) {
        if ($score > 110) {
            $displayArr = array('lr' => '>95%', 'hr' => '', 'text' => 'Best admission chances', 'class' => 'green color-green');
        } elseif ($score >= 99 && $score <= 110) {
            $displayArr = array('lr' => '75% - ', 'hr' => '95%', 'text' => 'Best admission chances', 'class' => 'green color-green');
        } elseif ($score >= 95 && $score < 99) {
            $displayArr = array('lr' => '50% - ', 'hr' => '75%', 'text' => 'Best admission chances', 'class' => 'orange color-orange');
        } elseif ($score >= 81 && $score < 95) {
            $displayArr = array('lr' => '20% - ', 'hr' => '50%', 'text' => 'Best admission chances', 'class' => 'orange color-orange');
        }  elseif ($score >= 1 && $score <= 80) {
            $displayArr = array('lr' => '<20%', 'hr' => '', 'text' => 'Best admission chances', 'class' => 'red color-pink');
        } else{
            $displayArr = array('lr' => 'Not available', 'hr' => '', 'text' => 'Best admission chances', 'class' => '');
        }
        return "<strong class='{$displayArr['class']}'> {$displayArr['lr']} {$displayArr['hr']}</strong><span>{$displayArr['text']}</span>";
    }
    
    public function getYTid($ytURL) {
        $ytvIDlen = 11; // This is the length of YouTube's video IDs
        // The ID string starts after "v=", which is usually right after 
        // "youtube.com/watch?" in the URL
        $idStarts = strpos($ytURL, "?v=");

        // In case the "v=" is NOT right after the "?" (not likely, but I like to keep my 
        // bases covered), it will be after an "&":
        if ($idStarts === FALSE)
            $idStarts = strpos($ytURL, "&v=");
        // If still FALSE, URL doesn't have a vid ID
        if ($idStarts === FALSE) {
            return false;
            //die("YouTube video ID not found. Please double-check your URL.");
        }

        // Offset the start location to match the beginning of the ID string
        $idStarts +=3;

        // Get the ID string and return it
        $ytvID = substr($ytURL, $idStarts, $ytvIDlen);

        return $ytvID;
    }
    
    public function completeYear($class, $withSameKey = '')
    {
        $classNumeric = substr($class, 0, $class == '9p' ? 1 : 2);
        switch ($class) {
            case '9p':
            case '9Pursuing':                
            case '10p':
            case '10Pursuing':
            case '11p':
            case '11Pursuing':
            case '12p':
            case '12Pursuing':
                $startLimit = date("Y") + (12 - $classNumeric);
                $endLimit = $startLimit + 4;
                $arr = range($startLimit, $endLimit);
                break;
            case '12c':
            case '12Completed':
                $startLimit = date("Y");
                $endLimit = $startLimit - 4;
                $arr = range($startLimit, $endLimit);
                $arr = array_reverse($arr);
                break;
            default:
                $startLimit = date("Y");
                $endLimit = $startLimit - 4;
                $arr = range($startLimit, $endLimit);
                break;
        }
        if($withSameKey){
            return array_combine($arr, $arr);
        } else {
           return $arr; 
        }
        
    }
    
    
    public function usPhoneFormat($contactNumber)
    {
        $cNumber = preg_replace("/[^0-9]/", "", $contactNumber);
        switch(strlen($cNumber)){
            case "11" :
                $cString = preg_replace("/([0-9]{5})([0-9]{6})/", "$1-$2", $cNumber);
                break;
            case "10" :
                $cString = preg_replace("/([0-9]{5})([0-9]{5})/", "$1-$2", $cNumber);
                break;
            case "9" :
                $cString = preg_replace("/([0-9]{4})([0-9]{5})/", "$1-$2", $cNumber);
                break;
            case "8" :
                $cString = preg_replace("/([0-9]{4})([0-9]{4})/", "$1-$2", $cNumber);
                break;
            case "7" :
                $cString = preg_replace("/([0-9]{3})([0-9]{4})/", "$1-$2", $cNumber);
                break;
            case "6" :
                $cString = preg_replace("/([0-9]{3})([0-9]{3})/", "$1-$2", $cNumber);
                break;
            default  : $cString = $cNumber;
        }
            return $cString;
    }
 
    public function complitionYearList($class, $year = '', $range = 4) {
        $year = $year == '' ? date("Y") : $year;

        switch ($class) {
            case '10':
                $startLimit = $year - 1;
                $endLimit = $startLimit - $range;
                $arr = range($startLimit, $endLimit);
                $arr = array_reverse($arr);
                break;
            case '12':
                $startLimit = $year;
                $endLimit = $startLimit + $range;
                $arr = range($startLimit, $endLimit);
                break;
            default:
                $startLimit = $year;
                $endLimit = $startLimit + $range;
                $arr = range($startLimit, $endLimit);
                break;
        }
        return array_combine($arr, $arr);
    }
    
    // input - 12th completed year
    // output - likely start period year list
    public function LikelyStartYearList($year, $range = 3) {
        if (!$year) {
            $year = date("Y");
        }

        $year = $year >= date("Y") ? $year : date("Y");

        $startLimit = $year;
        $endLimit = $startLimit + $range;
        $arr = range($startLimit, $endLimit);
        return array_combine($arr, $arr);
    }
    
    public static function testYearList($testStatus) {
        $testYearList = array();
        if($testStatus == "Planned") {
            $testYearList = range(date("Y"), (date("Y") + 4));
            $testYearList = array_combine($testYearList, $testYearList);
        } elseif($testStatus == "Completed") {
            $testYearList = range(date("Y"), (date("Y") - 4));
            array_reverse($testYearList);
            $testYearList = array_combine($testYearList, $testYearList);
        }
        return $testYearList;
    }

    // return appropriate text for diff in date1 and date2
    // format of date1 and date2 must be date("Y-m-d H:i:s")
    public static function convertDateDiffText($date1, $date2) {
        $currentTime = strtotime($date1);
        $yourDate = strtotime($date2);
        $datediff = $currentTime - $yourDate;
        $days = floor($datediff / (60 * 60 * 24));
        if ($days == 0) {
            $text = "just now";
        } elseif ($days <= 30) {
            $text = $days . " days ago";
        } elseif ($days < 365) {
            $month = (int) ($days / 30);
            $text = $month == 1 ? "1 month ago" : $month . " months ago";
        } else {
            $year = (int) ($days / 365);
            $text = $year == 1 ? "1 year ago" : $year . " years ago";
        }
        return $text;
    }

    public static function encryptUniID($uniID = 0){
        $encryptionSalt = 'univariety1@#';
        return MD5($encryptionSalt . $uniID . $encryptionSalt);
    }

    public static function getAcademicYears() {
        if (date('n') <= 6) {
            $academic_year_start = date('Y') - 1;
        } else {
            $academic_year_start = date('Y');
     }
        $academic_year_end = $academic_year_start + 1;
        return array($academic_year_start, $academic_year_end);
    }


    public static function getAcademicYearsIrrespectiveOfMonth() {

        $academic_year_start = date('Y');
        $academic_year_end = $academic_year_start + 1;
        return array($academic_year_start, $academic_year_end);
    }

    public static function getArticlePageUrl($article_id, $byCareerHash = 0) {
        $data = Article::getArticleUrlData($article_id, $byCareerHash);
        $seoText = self::removeUrlJunkChar(html_entity_decode($data['title'])); // replace special character

        $url = Yii::app()->urlManager->createUrl('articles/article/articlesDetails', array(
            'seoText' => $seoText,
            'id' => base64_encode($data['article_id']),
        ));
        $url = preg_replace('/\/app/', '', urldecode($url) );
        return $url;
    }

    public static function getXmlFormatArticleUrls() {

        if(ACTUALHOST == 'univarit.com' || ACTUALHOST == 'univariety.com'){
            $PROTOCOL = 'https://';
        }else{
            $PROTOCOL = 'http://';
        }
        $BASEURL = $PROTOCOL.ACTUALHOST;

       $criteria = new CDbCriteria();
        $criteria->select = "article_id, title";
        $criteria->condition = "is_active ='Y'";
        $result = Article::model()->findAll($criteria);

        foreach($result as $res){
            echo htmlentities("<url>");
            echo htmlentities("<loc>");
            echo $BASEURL.self::getArticlePageUrl($res->article_id);
            echo htmlentities("</loc>");
            echo htmlentities("</url>");
            echo "<br>";
        }

    }


}
