<?php
$countryData = Yii::app()->db->createCommand()
    ->from('tbl_country_master as tcm')
    ->select('phone_code, country_name')
    ->where('is_active= "Y" AND country_code <> "" ')
    ->order('country_name ASC')
    ->queryAll();
$country_list = array();

foreach ($countryData as $country) {
    $phone_code = $country['phone_code'];
    $country_list[$phone_code] = $country['country_name']." (+$phone_code)";
}
asort($country_list);
?>
<div class="gutter_vertical visible clearfix DivCount" id="otherInfo_<?php echo $i; ?>">
    <div class="clearfix gutter_vertical visible">
        <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">Parent (optional)</div>
        <div class="grid_2 pull small_gutter_r styledSelect2 relative">
            <select class="full-width" name="ProfileData[contact_type_ref_id][<?php echo $i;?>]" id="ProfileData_contact_type_ref_id_<?php echo $i;?>">
                <option value="">Choose Relationship</option>
                <option value="2">Father</option>
                <option value="3">Mother</option>
                <option value="4">Guardian</option>
            </select>
            <div class="popup errorMessage" id="ProfileData_contact_type_ref_id_<?php echo $i;?>_em_" style="display:none"></div>
        </div>
        <div class="grid_2 pull small_gutter_r relative">
            <input maxlength="50" placeholder="Parent Name" class="full-width" name="ProfileData[pfname][<?php echo $i; ?>]" id="ProfileData_pfname_<?php echo $i; ?>" type="text">
            <div class="popup errorMessage" id="ProfileData_pfname_<?php echo $i; ?>_em_" style="display:none"></div>
        </div>
        <div class="grid_2 pull small_gutter_r relative">
            <input maxlength="50" placeholder="Email Address" class="full-width" name="ProfileData[emails][<?php echo $i;?>]" id="ProfileData_emails_<?php echo $i;?>" type="text">
            <div class="popup errorMessage" id="ProfileData_emails_<?php echo $i;?>_em_" style="display:none"></div>
        </div>
    </div>

    <div class="clearfix gutter_vertical visible">
        <div class="grid_2 pull small_gutter_r text-right small_gutter_t small">&nbsp;</div>
        <div class="grid_2 pull small_gutter_r styledSelect2 relative">
            <?php echo CHtml::dropDownList("ProfileData[country_codes][$i]", '', $country_list, array( 'class' => 'full-width', 'id' => 'ProfileData_country_codes_'.$i,'empty'=>'Country Code')); ?>
            <div class="errorMessage popup" id="ProfileData_country_codes<?php echo $i;?>_em_" style="display:none"></div>
        </div>

        <div class="grid_4 pull small_gutter_r relative">
            <input placeholder="Phone Number" maxlength="12" class="full-width" name="ProfileData[phones][<?php echo $i;?>]" id="ProfileData_phones_<?php echo $i;?>" type="text">
            <div class="errorMessage popup" id="ProfileData_phones_<?php echo $i;?>_em_" style="display:none"></div>
        </div>
    </div>
    <div class="clearfix push_2">
        <a href="javascript:void(0)" onclick="add_more(<?php echo $i; ?>)" id="add_<?php echo $i; ?>" rel="<?php echo $i; ?>" class="add_parent"><i class="fa fa-plus"></i> Add other parent</a>
        <a href="javascript:void(0)" onclick="remov(<?php echo $i; ?>)" style="display: none" class='rem_parent' id="remove_<?php echo $i; ?>">Remove</a>
    </div>
</div>