<?php

Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/protected/modules/student/views/profile/profile_validation.js", CClientScript::POS_HEAD);

?>
<div class="row multi_line small-gutter gray">
    <div class="clearfix gutter_vertical" style="border-bottom:1px solid #d8d8d8">
        <h4 class="gutter_vertical left">Basic Information</h4>
        <?php
        if ($this->_hasEdit) { ?><a href="<?php echo Yii::app()->createUrl('myProfile?uid='.Yii::app()->request->getParam('uid')); ?>" class="right gutter_vertical" target="_blank">Edit</a><?php } //echo Yii::app()->createUrl('student/profile/EditBasicInfo', $this->userParams); //'myProfile?uid='.Yii::app()->request->getParam('uid')?>
    </div>

    <div class="gutter_vertical">
        <div class="color-gray normal">
            Birthday
        </div>
        <div><?php echo ($this->userData->attributes['dob'] != '' && $this->userData->attributes['dob'] != '0000-00-00') ? date("F d, Y", strtotime($this->userData->attributes['dob'])) : 'N/A'; ?></div>
    </div>
    <h4 class="row  gutter_vertical" style="border-top:1px solid #d8d8d8"></h4>
    <div class="gutter_vertical">
        <div class="color-gray normal">
            Ethnicity
        </div>
        <div>
            <?php echo ($this->userData->ethnicityRef->attributes['ethnicity_name'] != '' ) ? $this->userData->ethnicityRef->attributes['ethnicity_name'] : 'N/A'; ?>
        </div>
    </div>
    <h4 class="row  gutter_vertical" style="border-top:1px solid #d8d8d8"></h4>
    <div class="gutter_vertical">
        <div class="color-gray normal">
            Citizenship
        </div>
        <div>
            <?php echo $this->citizenships['citizenship']; ?>
        </div>
    </div>
    <h4 class="row  gutter_vertical" style="border-top:1px solid #d8d8d8"></h4>
    <?php if ($this->isFullVisibilty): ?>
        <div class="color-gray normal">Address</div>
        <?php
        if ($this->userData->attributes['address1'] == '' && $this->userData->attributes['address2'] == '' && $this->userData->cityRef->attributes['city_name'] == '' && $this->userData->countryRef->attributes['country_name'] == '' && $this->userData->attributes['post_code'] == '') {
            echo 'N/A';
        } else {
            ?>
            <div for="address1"><?php echo isset($this->userData->attributes['address1']) ? $this->userData->attributes['address1'] : ''; ?></div>
            <div for="address1"><?php echo isset($this->userData->attributes['address2']) ? $this->userData->attributes['address2'] : ''; ?></div>
            <div for="country"><?php
                $address = array();
                $address[] = (isset($this->userData->cityRef->attributes['city_name'])) ? $this->userData->cityRef->attributes['city_name'] : '';
                $address[] = (isset($this->userData->stateRef->attributes['name'])) ? $this->userData->stateRef->attributes['name'] : '';
                $address[] = (isset($this->userData->countryRef->attributes['country_name'])) ? $this->userData->countryRef->attributes['country_name'] : '';
                $address[] = (isset($this->userData->attributes['post_code'])) ? $this->userData->attributes['post_code'] : '';
                $address = array_filter($address);
                echo implode(', ', $address);
                ?>
            </div>
        <?php
        }
        ?>

        <h4 class="row  gutter_vertical" style="border-top:1px solid #d8d8d8"></h4>
        <div class="gutter_vertical">
            <div class="color-gray normal">
                Contact Info
            </div>
            <?php
            $studentContactNumber = '';
            $studentContactNumber = StudentContactNumber::getContactNumbers($this->userData->attributes['user_id'], 1);
            ?>
            <div for="Phone"><?php echo ($studentContactNumber != '') ? $studentContactNumber : 'N/A'; ?></div>
            <div for="email"><a href="mailto:<?php echo $this->userData->loginRef->username; ?>"><?php echo wordwrap($this->userData->loginRef->attributes['username'], 24, "<br>", true); ?></a>
                <?php
                $referrer = Yii::app()->getRequest()->getUrlReferrer();
                if(strstr($referrer, 'MyAssignedGems') == 'MyAssignedGems'){
                    echo CHtml::CheckBox("chkEmailConf", $this->userData->loginRef->is_email_confirmed, array('disabled'=>'disabled'));
                }
                elseif ($this->profileValidationAccess && !$this->pdfDownload){
                    echo CHtml::CheckBox("chkEmailConf", $this->userData->loginRef->is_email_confirmed, array("value" => $this->userData->user_id . '_' . $this->userData->loginRef->login_id, 'title' => 'Email Confirmed?'));
                }

                ?>
            </div>
        </div>
        <div class="clearfix"></div>
        <h4 class="row  gutter_vertical" style="border-top:1px solid #d8d8d8"></h4>
        <div class="gutter_vertical">
            <div class="color-gray normal">Parent Info</div>

            <?php
            $parentData = array();
            $parentEmail = StudentAlternateEmail::getAllParentEmails($this->userData->attributes['login_ref_id']);
            $parentContactNumber = StudentContactNumber::getParentContactNumbers($this->userData->attributes['user_id']);


            foreach ($parentEmail as $key => $data) {
                $parentData[$data->contact_type_ref_id]['email'][] = wordwrap($data->email_id, 24, "<br>", true);
                //print_r($data->attributes);die;
            }



            foreach ($parentContactNumber as $key => $data) {
                $parentData[$data->contact_type_ref_id]['contact'][] = $data->country_code . '-' . $data->number;
                //print_r($data->attributes);die;
            }

            ksort($parentData);

            foreach ($parentData as $key => $data) {

                if ($key == 2) {
                    echo '<div for="father"><strong>Father</strong></div>';
                    echo '<div for="address">' . $this->userData->attributes['father_first_name'] . '</div>';
                } elseif ($key == 3) {
                    echo '<div for="father"><strong>Mother</strong></div>';
                    echo '<div for="address">' . $this->userData->attributes['mother_first_name'] .'</div>';
                } elseif ($key == 4) {
                    echo '<div for="father"><strong>Gaurdian</strong></div>';
                    echo '<div for="address">' . $this->userData->attributes['guardian_first_name'] .'</div>';
                }
                if ($data['contact']) {
                    foreach ($data['contact'] as $k => $val) {
                        echo '<div for="phone">' . $val . '</div>';
                    }
                }
                if($data['email']){
                    foreach ($data['email'] as $k => $val) {
                        echo '<div for="email"><a href="mailto:' . $val . '">' . $val . '</a></div>';
                    }
                }
            }
            if (!$parentData) {
                echo 'N/A';
            }
            ?>
        </div>
        <div class="clearfix"></div>
    <?php endif; ?>
</div>
