<?php
yii::import('zii.widgets.CPortlet');

class Preferences extends CPortlet
{
    public $rbacRole = '';
    public $_hasEdit = false;
    public $_isDI = false;
    public $userData;
    public $userParams = array();
    public $profileValidationAccess = false;
    public $pdfDownload = false;
	
	public $userPreferences = array();

    public function init() {
        // pre-process if any
    }

    public function run() {
     if($this->userData->present_class == '10' || $this->userData->present_class == '9')
        {
            //Subject Interest
            $subjectStreamPrefArray = array();
            $subjectWeakStreamPrefArray = array();
            $i = 1;
            $j = 1;
            foreach($this->userData->studentPreferredSubjects as $subjectStream){
                    if($subjectStream->not_sure){
                            $subjectStreamPrefArray[0] = 'Not Decided';
                            break;
                    }else{
                        if($i<=3){
                            if($subjectStream->type == 'Like'){
                                $subjectStreamPrefArray[$subjectStream->preference] = $subjectStream->studentSubjectRef->attributes['subject_name'];
                                $i++;
                            }
                        }
                        if($j<=3){
                            if($subjectStream->type == 'Dislike'){
                                $subjectWeakStreamPrefArray[$subjectStream->preference] = $subjectStream->studentSubjectRef->attributes['subject_name'];
                                $j++;
                            }
                        }
                    }
            }
            ksort($subjectStreamPrefArray);
            ksort($subjectWeakStreamPrefArray);
            if(count($subjectStreamPrefArray) > 0){
                    $this->userPreferences['subject_interest'] = implode(' <span style="padding:8px; text-align:center;"> | </span> ', $subjectStreamPrefArray);
            }else{
                    $this->userPreferences['subject_interest'] = 'N/A';
            }

            if(count($subjectWeakStreamPrefArray) > 0){
                $this->userPreferences['weak_subject_interest'] = implode(' <span style="padding:8px; text-align:center;"> | </span> ', $subjectWeakStreamPrefArray);
            }else{
                $this->userPreferences['weak_subject_interest'] = 'N/A';
            }
            //Study Interest END

            //Study Stream
            $studyStreamPref = '';
            foreach($this->userData->studentEducations as $studyStream){
                    if($studyStream->class_level == '10' || $studyStream->class_level == '9'){
                            $studyStreamPref = $studyStream->interested_stream;
                    }
            }
            if($studyStreamPref){
                    $this->userPreferences['study_stream'] = $studyStreamPref;

            }else{
                    $this->userPreferences['study_stream'] = 'N/A';
            }
            //Study Stream END

            //Career Interest
            $careerDet = LookupCareer::model()->findByAttributes(array('parent_choice'=>'Y', 'career_name'=>'Others'));
            Yii::app()->session['Others'] = $careerDet->career_id;

            $noParentChoice = StudentPreferredCareer::model()->findByAttributes(array('user_ref_id'=>$this->userData->user_id, 'parent_choice'=>'N'));
            $parentChoice = StudentPreferredCareer::model()->findByAttributes(array('user_ref_id'=>$this->userData->user_id, 'parent_choice'=>'Y'));

            $criteria = new CDbCriteria;
            $criteria->condition = "user_ref_id = '".$this->userData->user_id."' AND preference IN (0,1,2) AND (career_ref_id != '".Yii::app()->session['Others']."' OR career_ref_id IS NULL) ";
            if(count($noParentChoice)){
                $criteria->addCondition("parent_choice='N'", "AND");
            }
            elseif(count($parentChoice)){
                $criteria->addCondition("parent_choice='Y'", "AND");
            }
            else{
                $criteria->addCondition("parent_choice IS NULL", "AND");
            }
            $careers = StudentPreferredCareer::model()->findAll($criteria);

            $careerPrefArray = array();
            //foreach($this->userData->studentPreferredCareers as $careerInterest){
            foreach($careers as $careerInterest){
                    if($careerInterest->not_sure){
                            $careerPrefArray[0] = 'Not Decided';
                            break;
                    }else{
                          $careerPrefArray[$careerInterest->preference] = $careerInterest->career_ref_id ? $careerInterest->careerRef->career_name : $careerInterest->career_name;
                            //$careerInterest->careerRef->attributes['career_name'];
                    }
            }
            ksort($careerPrefArray);
            if(count($careerPrefArray) > 0){
                    $this->userPreferences['career_interest'] = implode(' <span style="padding:8px; text-align:center;"> | </span> ', $careerPrefArray);
            }else{
                    $this->userPreferences['career_interest'] = 'N/A';
            }
            //Career Interest END

        }else{
            //Study Level
            $studyLevelArray = array();
            foreach($this->userData->studentPreferredStudyLevels as $prefStudyLevel){
                    $studyLevelArray[] = $prefStudyLevel->courseLevelRef->attributes['course_level'];
            }
            if(count($studyLevelArray) > 0){
                    $this->userPreferences['study_level'] = implode(' <span style="padding:8px; text-align:center;">  | </span> ', $studyLevelArray);
            }else{
                    $this->userPreferences['study_level'] = 'N/A';
            }
            //Study Level_END

        }

		//Country Preferences

		$countryPrefArray = array();
        $i =1;
		foreach($this->userData->studentPreferredCountries as $prefCountry){
			if($prefCountry->not_sure){
				$countryPrefArray[0] = 'Not Decided';
				break;
			}else if($prefCountry->preference_order == 0){
                $countryPrefArray[$i] = $prefCountry->countryRef->attributes['country_name'];
                $i++;
                }
                else{
				$countryPrefArray[$prefCountry->preference_order] = $prefCountry->countryRef->attributes['country_name'];
			}

		}
		ksort($countryPrefArray);
		if(count($countryPrefArray) > 0){
            $countries = array();
            foreach($this->userData->studentPreferredCountries as $prefCountry){
                $location = StudentPreferredLocation::getAllPrefLocations($this->userData->user_id,$prefCountry->countryRef->attributes['country_id']);
                $countries[] = $prefCountry->countryRef->attributes['country_name']. ($location['location'] ? ' (<span class="small color-gray">'.$location['location'].'</span>)' : '');
            }
            $this->userPreferences['country'] = implode(' <span style="padding:8px; text-align:center;"> | </span> ', $countries);
			//$this->userPreferences['country'] = implode(' <span style="padding:8px; text-align:center;"> | </span> ', $countryPrefArray);
		}else{
			$this->userPreferences['country'] = 'N/A';
		}
		//Country Preferences_END
        //Department Preferences
        $departmentPrefArray = array();
        foreach($this->userData->studentPreferredDepartments as $prefDept){
            if($prefDept->not_sure){
                $departmentPrefArray[0] = 'Not Decided';
                break;
            }else{
                $departmentPrefArray[$prefDept->preference_order] = $prefDept->mainDeptRef->attributes['department_name'];
            }
        }
        ksort($departmentPrefArray);
        if(count($departmentPrefArray) > 0){
            $this->userPreferences['department'] = implode(' <span style="padding:8px; text-align:center;"> | </span> ', $departmentPrefArray);
        }else{
            $this->userPreferences['department'] = 'N/A';
        }
        //Department Preferences_END

        //Start Period
        $startPeriodArray = array();
        $separator = '';
        foreach($this->userData->studentPreferredPeriods as $prefPeriod){
            $startPeriodArray[] = $prefPeriod->periodRef->attributes['months'] . ' - ' . $prefPeriod->attributes['year'];
        }
        if(count($startPeriodArray) > 0){
            $this->userPreferences['start_period'] = implode(' <span style="padding:8px; text-align:center;"> | </span> ', $startPeriodArray);
        }else{
            $this->userPreferences['start_period'] = 'N/A';
        }
        //Start Period_END

        if(strtolower(Yii::app()->controller->action->id) == 'viewpdfdownload'){
            $this->pdfDownload = true;
            $this->render('preferences_table_structure');
        }else{
            $this->render('preferences');}
    }

    public function printr($array=array()){
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }
}