<?php 
    /**
     * @param $student
     * @param $departmentId
     */

// Lists to display.
$listTypes = array(
    StudentIdealList::TYPE_ASPIRATIONAL,
    StudentIdealList::TYPE_BEST_FIT,
    StudentIdealList::TYPE_SAFE
);

$listLabels = StudentIdealList::getTypeLabels();

$showEmptyList = false;
if(!$existingDepartment){
    $listTypes = array(StudentIdealList::TYPE_SAFE);
    $showEmptyList = true;
}

?>
<div>
	<?php
	    foreach($listTypes as $listType):
	        $list = $showEmptyList ? array() : StudentIdealList::getRecord($student->user_id, $departmentId, $listType);
	        $isSafeList = ($listType == StudentIdealList::TYPE_SAFE);
	    //var_dump($list->attributes);
	    if($showEmptyList === false){
	        $universities = $list->applyingCollegeList;
	        if(count($universities) == 0  && !$isSafeList)
	            continue;
	    }
	    
	?>
					<div class="width-300 left">
						<div class="green-bg-title">
						    <?php echo $listLabels[$listType]; ?> <?php echo $isSafeList? ' + Other' : ''; ?> Colleges List
						</div>
						<div class="clear"></div>
						<div class="height-120-scroll gradient_light_blue padding-0-20 left width-260 padding-btm-10 small border_bottom_left_right_radius_5"<?php echo $isSafeList? ' id="otherListContainer"' : ''; ?>>
						<?php 
						
						    if($showEmptyList === false):
						    
						    
                            foreach($universities as $university):
                                $randId = rand(9999, 99999);
						?>
							<div class="margin-top-10">
								<div class="left">
									<input type="checkbox" name="StudentOutplacementUniversity[<?php echo $randId; ?>][uni_ref_id]" value="<?php echo $university->university->uni_id; ?>" class="margin-right-5 left" />
									<input type="hidden" name="StudentOutplacementUniversity[<?php echo $randId; ?>][list_type]" value="<?php echo $listType; ?>" />
									<?php echo $university->university->uni_name; ?>
								</div>
								<div class="clear"></div>
							</div>
							<?php 
							endforeach;
							endif;
							?>
						</div>
					</div>
					<div class="spacer-18 left">&nbsp;</div>
		<?php 
		    endforeach;
		?>
		<div class="clear"></div>
</div>